/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0015\u001a\u00020\n*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "getInfo", "Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention$Info;", "isNot", "Lcom/intellij/sql/psi/SqlUnaryExpression;", "dbms", "Lcom/intellij/database/Dbms;", "Info", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertComparisonToBetweenIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertComparisonToBetweenIntention.kt\ncom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n296#2,2:88\n*S KotlinDebug\n*F\n+ 1 SqlConvertComparisonToBetweenIntention.kt\ncom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention\n*L\n54#1:88,2\n*E\n"})
public final class SqlConvertComparisonToBetweenIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.comparison.with.between.expression", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getInfo(element) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Info info = this.getInfo(element);
        if (info == null) {
            return;
        }
        Info info2 = info;
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)info2.getElementToReplace());
        String string = new DdlBuilder().configureBuilder(project, (SqlLanguageDialect)dialect).withDialect(dialect.getDatabaseDialect()).plain(info2.getSubject().getText()).keyword(info2.isNot() ? " not between " : " between ").plain(info2.getLowerBound().getText()).keyword(" and ").plain(info2.getUpperBound().getText()).getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String betweenExprText = string;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText((String)betweenExprText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (Project)project, null);
        Intrinsics.checkNotNull((Object)sqlExpression);
        SqlExpression betweenExpr = sqlExpression;
        info2.getElementToReplace().replace((PsiElement)betweenExpr);
    }

    /*
     * WARNING - void declaration
     */
    private final Info getInfo(PsiElement element) {
        PsiElement parent;
        SqlExpression sqlExpression;
        Object v2;
        Dbms dbms;
        block13: {
            void $this$firstOrNull$iv;
            Dbms dbms2 = SqlPsiUtilKt.getSqlDialect((PsiElement)element).getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"getDbms(...)");
            dbms = dbms2;
            JBIterable jBIterable = SqlImplUtil.sqlParents((PsiElement)element).filter(SqlBinaryExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBinaryExpression it = (SqlBinaryExpression)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!UtilsKt.isAnd((SqlBinaryExpression)it, (Dbms)dbms)) continue;
                v2 = element$iv;
                break block13;
            }
            v2 = null;
        }
        SqlBinaryExpression sqlBinaryExpression = v2;
        if (sqlBinaryExpression == null) {
            return null;
        }
        SqlBinaryExpression andExpr = sqlBinaryExpression;
        SqlExpression sqlExpression2 = andExpr.getLOperand();
        SqlBinaryExpression sqlBinaryExpression2 = sqlExpression2 instanceof SqlBinaryExpression ? (SqlBinaryExpression)sqlExpression2 : null;
        if (sqlBinaryExpression2 == null) {
            return null;
        }
        SqlBinaryExpression leftCmp = sqlBinaryExpression2;
        SqlExpression sqlExpression3 = andExpr.getROperand();
        SqlBinaryExpression sqlBinaryExpression3 = sqlExpression3 instanceof SqlBinaryExpression ? (SqlBinaryExpression)sqlExpression3 : null;
        if (sqlBinaryExpression3 == null) {
            return null;
        }
        SqlBinaryExpression rightCmp = sqlBinaryExpression3;
        Pair pair = UtilsKt.splitWithReference((SqlBinaryExpression)leftCmp);
        if (pair == null) {
            return null;
        }
        sqlExpression2 = pair;
        SqlReferenceExpression leftRef = (SqlReferenceExpression)sqlExpression2.component1();
        SqlExpression leftExpr = (SqlExpression)sqlExpression2.component2();
        Pair pair2 = UtilsKt.splitWithReference((SqlBinaryExpression)rightCmp);
        if (pair2 == null) {
            return null;
        }
        Pair pair3 = pair2;
        SqlReferenceExpression rightRef = (SqlReferenceExpression)pair3.component1();
        SqlExpression rightExpr = (SqlExpression)pair3.component2();
        if (!UtilsKt.checkEquivalence((SqlReferenceExpression)leftRef, (SqlReferenceExpression)rightRef)) {
            return null;
        }
        SqlExpression lowerBound = null;
        SqlExpression upperBound = null;
        if (Intrinsics.areEqual((Object)leftCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_LE) && Intrinsics.areEqual((Object)rightCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_GE)) {
            upperBound = leftExpr;
            lowerBound = rightExpr;
        } else if (Intrinsics.areEqual((Object)leftCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_GE) && Intrinsics.areEqual((Object)rightCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_LE)) {
            lowerBound = leftExpr;
            upperBound = rightExpr;
        }
        if ((sqlExpression = UtilsKt.topParenthesized((SqlExpression)((SqlExpression)andExpr))) == null) {
            sqlExpression = (SqlExpression)andExpr;
        }
        boolean isNot = (parent = sqlExpression.getParent()) instanceof SqlUnaryExpression && this.isNot((SqlUnaryExpression)parent, dbms);
        SqlExpression sqlExpression4 = lowerBound;
        if (sqlExpression4 == null) {
            return null;
        }
        SqlExpression sqlExpression5 = upperBound;
        if (sqlExpression5 == null) {
            return null;
        }
        return new Info(isNot, (PsiElement)(isNot ? (SqlOperatorExpression)parent : (SqlOperatorExpression)andExpr), leftRef, sqlExpression4, sqlExpression5);
    }

    private final boolean isNot(SqlUnaryExpression $this$isNot, Dbms dbms) {
        IElementType opToken = $this$isNot.getOpSign();
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_NOT)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NOT2) && dbms.isHive();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention$Info;", "", "isNot", "", "elementToReplace", "Lcom/intellij/psi/PsiElement;", "subject", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "lowerBound", "Lcom/intellij/sql/psi/SqlExpression;", "upperBound", "<init>", "(ZLcom/intellij/psi/PsiElement;Lcom/intellij/sql/psi/SqlReferenceExpression;Lcom/intellij/sql/psi/SqlExpression;Lcom/intellij/sql/psi/SqlExpression;)V", "()Z", "getElementToReplace", "()Lcom/intellij/psi/PsiElement;", "getSubject", "()Lcom/intellij/sql/psi/SqlReferenceExpression;", "getLowerBound", "()Lcom/intellij/sql/psi/SqlExpression;", "getUpperBound", "intellij.database.sql.impl"})
    private static final class Info {
        private final boolean isNot;
        @NotNull
        private final PsiElement elementToReplace;
        @NotNull
        private final SqlReferenceExpression subject;
        @NotNull
        private final SqlExpression lowerBound;
        @NotNull
        private final SqlExpression upperBound;

        public Info(boolean isNot, @NotNull PsiElement elementToReplace, @NotNull SqlReferenceExpression subject, @NotNull SqlExpression lowerBound, @NotNull SqlExpression upperBound) {
            Intrinsics.checkNotNullParameter((Object)elementToReplace, (String)"elementToReplace");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
            Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
            this.isNot = isNot;
            this.elementToReplace = elementToReplace;
            this.subject = subject;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public final boolean isNot() {
            return this.isNot;
        }

        @NotNull
        public final PsiElement getElementToReplace() {
            return this.elementToReplace;
        }

        @NotNull
        public final SqlReferenceExpression getSubject() {
            return this.subject;
        }

        @NotNull
        public final SqlExpression getLowerBound() {
            return this.lowerBound;
        }

        @NotNull
        public final SqlExpression getUpperBound() {
            return this.upperBound;
        }
    }
}

