/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jvm.advanced.java.log.capture;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import org.jetbrains.annotations.NotNull;

class OfflineStackFrame
extends XStackFrame {
    @NotNull
    private final SourcePosition myPosition;
    private final String myPath;
    @NlsSafe
    private final String myMethodName;
    private final int myLineNumber;

    OfflineStackFrame(StackFrameItem item, @NotNull SourcePosition position) {
        if (position == null) {
            OfflineStackFrame.$$$reportNull$$$0(0);
        }
        this.myPosition = position;
        this.myPath = item.path();
        this.myMethodName = item.method();
        this.myLineNumber = item.line();
    }

    public XSourcePosition getSourcePosition() {
        return DebuggerUtilsEx.toXSourcePosition((SourcePosition)this.myPosition);
    }

    @NotNull
    public SourcePosition getJavaSourcePosition() {
        SourcePosition sourcePosition = this.myPosition;
        if (sourcePosition == null) {
            OfflineStackFrame.$$$reportNull$$$0(1);
        }
        return sourcePosition;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            OfflineStackFrame.$$$reportNull$$$0(2);
        }
        ThreadsViewSettings settings = ThreadsViewSettings.getInstance();
        component.append(this.myMethodName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (settings.SHOW_LINE_NUMBER) {
            component.append(":" + this.myLineNumber, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (settings.SHOW_CLASS_NAME) {
            component.append(", " + StringUtil.getShortName((String)this.myPath), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String packageName = StringUtil.getPackageName((String)this.myPath);
            if (settings.SHOW_PACKAGE_NAME && !packageName.trim().isEmpty()) {
                component.append(" (" + packageName + ")", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jvm/advanced/java/log/capture/OfflineStackFrame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jvm/advanced/java/log/capture/OfflineStackFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSourcePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

