/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.ByteCodeViewerManager;
import com.intellij.byteCodeViewer.BytecodeViewerSettings;
import com.intellij.byteCodeViewer.ShowBytecodeActionKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.content.Content;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J%\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/byteCodeViewer/BytecodeEditorSynchronizer;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "findContentForSourceFile", "Lcom/intellij/ui/content/Content;", "contents", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/ui/content/Content;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/ui/content/Content;", "Companion", "intellij.java.byteCodeViewer"})
@SourceDebugExtension(value={"SMAP\nBytecodeEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeEditorSynchronizer.kt\ncom/intellij/byteCodeViewer/BytecodeEditorSynchronizer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,57:1\n1401#2,2:58\n*S KotlinDebug\n*F\n+ 1 BytecodeEditorSynchronizer.kt\ncom/intellij/byteCodeViewer/BytecodeEditorSynchronizer\n*L\n45#1:58,2\n*E\n"})
public final class BytecodeEditorSynchronizer
implements FileEditorManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public BytecodeEditorSynchronizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!BytecodeViewerSettings.Companion.getInstance().getState().getSyncWithEditor()) {
            return;
        }
        VirtualFile virtualFile = event.getNewFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Bytecode");
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (!toolWindow2.isVisible()) {
            return;
        }
        Content[] contentArray = toolWindow2.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Content content = this.findContentForSourceFile(contentArray, virtualFile2);
        if (content == null) {
            return;
        }
        Content content2 = content;
        toolWindow2.getContentManager().setSelectedContent(content2);
    }

    private final Content findContentForSourceFile(Content[] contents, VirtualFile sourceFile) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(sourceFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof PsiClassOwner)) {
            return null;
        }
        PsiClass[] psiClassArray = ((PsiClassOwner)psiFile2).getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
        for (PsiClass psiClass : psiClassArray) {
            Content content;
            block4: {
                Intrinsics.checkNotNull((Object)psiClass);
                if (ByteCodeViewerManager.INSTANCE.findClassFile(psiClass) == null) continue;
                Content[] $this$firstOrNull$iv = contents;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile classFile;
                    Content element$iv;
                    Content it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUserData(ShowBytecodeActionKt.getJAVA_CLASS_FILE()), (Object)classFile)) continue;
                    content = element$iv;
                    break block4;
                }
                content = null;
            }
            if (content == null) continue;
            Content content2 = content;
            return content2;
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/byteCodeViewer/BytecodeEditorSynchronizer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/byteCodeViewer/BytecodeEditorSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.byteCodeViewer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BytecodeEditorSynchronizer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(BytecodeEditorSynchronizer.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (BytecodeEditorSynchronizer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

