/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.config;

import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.api.ContextKey;
import com.intellij.kubernetes.config.HelmParameters;
import com.intellij.kubernetes.config.KubernetesProjectOptions;
import com.intellij.kubernetes.config.SpecSource;
import com.intellij.kubernetes.model.ConstantsKt;
import com.intellij.kubernetes.model.KustomizeVersion;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="KubernetesSettings", storages={@Storage(value="kubernetes-settings.xml", deprecated=true), @Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002 !B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/kubernetes/config/KubernetesProjectSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/kubernetes/config/KubernetesProjectOptions;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "Lcom/intellij/kubernetes/api/ContextKey;", "currentContextKey", "getCurrentContextKey", "()Lcom/intellij/kubernetes/api/ContextKey;", "setCurrentContextKey", "(Lcom/intellij/kubernetes/api/ContextKey;)V", "effectiveApiVersion", "", "getEffectiveApiVersion", "()Ljava/lang/String;", "effectiveKustomizeVersion", "Lcom/intellij/kubernetes/model/KustomizeVersion;", "getEffectiveKustomizeVersion", "()Lcom/intellij/kubernetes/model/KustomizeVersion;", "getEffectiveCrdSpecSources", "", "Lcom/intellij/kubernetes/config/SpecSource;", "getHelmParameters", "Lcom/intellij/kubernetes/config/HelmParameters;", "chartBaseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateHelmParameters", "getKnownValuesFiles", "", "Listener", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesProjectSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 MessageBusUtilities.kt\ncom/intellij/kubernetes/util/MessageBusUtilitiesKt\n*L\n1#1,248:1\n1#2:249\n125#3,5:250\n1480#4,5:255\n6#5,4:260\n*S KotlinDebug\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesProjectSettings\n*L\n129#1:250,5\n145#1:255,5\n82#1:260,4\n*E\n"})
public final class KubernetesProjectSettings
extends SimplePersistentStateComponent<KubernetesProjectOptions> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Topic.ProjectLevel
    @JvmField
    @NotNull
    public static final Topic<Listener> TOPIC;

    public KubernetesProjectSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((BaseState)new KubernetesProjectOptions());
        this.project = project;
    }

    @Nullable
    public final ContextKey getCurrentContextKey() {
        return ((KubernetesProjectOptions)this.getState()).getSelectedContext();
    }

    public final void setCurrentContextKey(@Nullable ContextKey value2) {
        ContextKey oldValue = ((KubernetesProjectOptions)this.getState()).getSelectedContext();
        if (Intrinsics.areEqual((Object)((Object)oldValue), (Object)((Object)value2))) {
            return;
        }
        ((KubernetesProjectOptions)this.getState()).setSelectedContext(value2);
        ContextKey contextKey = oldValue;
        ContextKey contextKey2 = value2;
        ((Listener)this.project.getMessageBus().syncPublisher(TOPIC)).onContextNameChanged(contextKey != null ? contextKey.getName() : null, contextKey2 != null ? contextKey2.getName() : null);
    }

    @NotNull
    public final String getEffectiveApiVersion() {
        String string = ((KubernetesProjectOptions)this.getState()).getApiVersion();
        if (string == null) {
            string = ConstantsKt.getDEFAULT_K8S_VERSION();
        }
        return string;
    }

    @NotNull
    public final KustomizeVersion getEffectiveKustomizeVersion() {
        Object object;
        block5: {
            block4: {
                KustomizeVersion kustomizeVersion;
                object = ((KubernetesProjectOptions)this.getState()).getKustomizeVersion();
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                boolean $i$f$unexceptionize = false;
                try {
                    boolean bl2 = false;
                    kustomizeVersion = KustomizeVersion.valueOf(it);
                }
                catch (Exception e$iv) {
                    kustomizeVersion = null;
                }
                KustomizeVersion kustomizeVersion2 = kustomizeVersion;
                object = kustomizeVersion2;
                if (kustomizeVersion2 != null) break block5;
            }
            object = ConstantsKt.getDEFAULT_KUSTOMIZE_VERSION();
        }
        return object;
    }

    @NotNull
    public final List<SpecSource> getEffectiveCrdSpecSources() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)((KubernetesProjectOptions)this.getState()).getSpecSources())), KubernetesProjectSettings::getEffectiveCrdSpecSources$lambda$0), arg_0 -> KubernetesProjectSettings.getEffectiveCrdSpecSources$lambda$1(this, arg_0)));
    }

    @Nullable
    public final HelmParameters getHelmParameters(@NotNull VirtualFile chartBaseDir) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)chartBaseDir, (String)"chartBaseDir");
            Iterable iterable = ((KubernetesProjectOptions)this.getState()).getHelmParameters();
            for (Object t : iterable) {
                HelmParameters it = (HelmParameters)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getChartPath(), (Object)chartBaseDir.getPath())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final HelmParameters getOrCreateHelmParameters(@NotNull VirtualFile chartBaseDir) {
        Intrinsics.checkNotNullParameter((Object)chartBaseDir, (String)"chartBaseDir");
        HelmParameters helmParameters = this.getHelmParameters(chartBaseDir);
        if (helmParameters == null) {
            HelmParameters helmParameters2;
            HelmParameters it = helmParameters2 = new HelmParameters(chartBaseDir.getPath());
            boolean bl = false;
            ((KubernetesProjectOptions)this.getState()).getHelmParameters().add(it);
            helmParameters = helmParameters2;
        }
        return helmParameters;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getKnownValuesFiles() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = ((KubernetesProjectOptions)this.getState()).getHelmParameters();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            HelmParameters it = (HelmParameters)((Object)element$iv);
            boolean bl = false;
            Iterable list$iv = it.getValuesFiles();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    private static final boolean getEffectiveCrdSpecSources$lambda$0(SpecSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it.getPathOrUrl();
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private static final SpecSource getEffectiveCrdSpecSources$lambda$1(KubernetesProjectSettings this$0, SpecSource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = this$0.project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        String string2 = MiscUtilKt.toAbsolutePathOrUrl(string, it.getPathOrUrl(), true);
        Intrinsics.checkNotNull((Object)string2);
        return new SpecSource(string2);
    }

    static {
        String displayName$iv = "K8s model settings changes";
        Topic.BroadcastDirection direction$iv = Topic.BroadcastDirection.TO_CHILDREN;
        boolean $i$f$createTopic = false;
        Topic topic = Topic.create((String)displayName$iv, Listener.class, (Topic.BroadcastDirection)direction$iv);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\fR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/config/KubernetesProjectSettings$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/kubernetes/config/KubernetesProjectSettings$Listener;", "getInstance", "Lcom/intellij/kubernetes/config/KubernetesProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceAsync", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesProjectSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,248:1\n30#2,2:249\n75#2:251\n*S KotlinDebug\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesProjectSettings$Companion\n*L\n84#1:249,2\n86#1:251\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KubernetesProjectSettings getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesProjectSettings> serviceClass$iv = KubernetesProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesProjectSettings)((Object)object);
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super KubernetesProjectSettings> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(KubernetesProjectSettings.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\r\u0010\u0007\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/config/KubernetesProjectSettings$Listener;", "", "onContextNameChanged", "", "oldValue", "", "Lcom/intellij/openapi/util/NlsSafe;", "newValue", "onCurrentClusterChanged", "intellij.clouds.kubernetes"})
    public static interface Listener {
        default public void onContextNameChanged(@Nullable String oldValue, @Nullable String newValue) {
        }

        default public void onCurrentClusterChanged() {
        }
    }
}

