/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.execution;

import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.view.execution.PortForwardingUtils;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1DaemonSetSpec;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentSpec;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobSpec;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicaSetSpec;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1ReplicationControllerSpec;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\r0\f0\u00052\u0006\u0010\u000e\u001a\u00020\u0007J&\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\r0\f0\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0014\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0018\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0005H\u0082@\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0086@\u00a2\u0006\u0002\u0010#J$\u0010\u001f\u001a\u00020 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010!\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010$J,\u0010%\u001a\u0004\u0018\u00010\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\u0005H\u0086@\u00a2\u0006\u0002\u0010\u001aR'\u0010\u0004\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0007\u0012\u0006\b\u0001\u0012\u00020\b0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/kubernetes/view/execution/PortForwardingUtils;", "", "<init>", "()V", "supportedEntities", "", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "Lio/kubernetes/client/common/KubernetesObject;", "Lio/kubernetes/client/common/KubernetesListObject;", "getSupportedEntities", "()Ljava/util/List;", "extractPorts", "Lkotlin/Pair;", "", "kubernetesObject", "extractPortForwardingPairs", "podSpec", "Lio/kubernetes/client/openapi/models/V1PodSpec;", "suggestPortMappings", "", "target", "addresses", "Ljava/net/InetAddress;", "(Lio/kubernetes/client/common/KubernetesObject;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "suggestLocalPort", "candidatePorts", "(Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shiftPortToUserSpace", "basePortToSuggest", "portCheckMutex", "Lkotlinx/coroutines/sync/Mutex;", "isPortAvailable", "", "port", "address", "(ILjava/net/InetAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/util/List;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAvailablePort", "portRange", "intellij.clouds.kubernetes"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPortForwardingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortForwardingUtils.kt\ncom/intellij/kubernetes/view/execution/PortForwardingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,116:1\n1642#2,10:117\n1915#2:127\n1916#2:129\n1652#2:130\n1391#2:131\n1480#2,2:132\n777#2:134\n873#2,2:135\n1586#2:137\n1661#2,3:138\n1482#2,3:141\n1786#2,3:156\n1#3:128\n1#3:155\n116#4,11:144\n*S KotlinDebug\n*F\n+ 1 PortForwardingUtils.kt\ncom/intellij/kubernetes/view/execution/PortForwardingUtils\n*L\n43#1:117,10\n43#1:127\n43#1:129\n43#1:130\n49#1:131\n49#1:132,2\n50#1:134\n50#1:135,2\n52#1:137\n52#1:138,3\n49#1:141,3\n107#1:156,3\n43#1:128\n93#1:144,11\n*E\n"})
public final class PortForwardingUtils {
    @NotNull
    public static final PortForwardingUtils INSTANCE = new PortForwardingUtils();
    @NotNull
    private static final List<KubernetesEntity<? extends KubernetesObject, ? extends KubernetesListObject>> supportedEntities;
    @NotNull
    private static final Mutex portCheckMutex;

    private PortForwardingUtils() {
    }

    @NotNull
    public final List<KubernetesEntity<? extends KubernetesObject, ? extends KubernetesListObject>> getSupportedEntities() {
        return supportedEntities;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Integer, Integer>> extractPorts(@NotNull KubernetesObject kubernetesObject) {
        List<Pair<Integer, Integer>> list2;
        Intrinsics.checkNotNullParameter((Object)kubernetesObject, (String)"kubernetesObject");
        KubernetesObject kubernetesObject2 = kubernetesObject;
        if (kubernetesObject2 instanceof V1Deployment) {
            V1DeploymentSpec v1DeploymentSpec = ((V1Deployment)kubernetesObject).getSpec();
            list2 = this.extractPortForwardingPairs(v1DeploymentSpec != null && (v1DeploymentSpec = v1DeploymentSpec.getTemplate()) != null ? v1DeploymentSpec.getSpec() : null);
        } else if (kubernetesObject2 instanceof V1ReplicaSet) {
            V1ReplicaSetSpec v1ReplicaSetSpec = ((V1ReplicaSet)kubernetesObject).getSpec();
            list2 = this.extractPortForwardingPairs(v1ReplicaSetSpec != null && (v1ReplicaSetSpec = v1ReplicaSetSpec.getTemplate()) != null ? v1ReplicaSetSpec.getSpec() : null);
        } else if (kubernetesObject2 instanceof V1DaemonSet) {
            V1DaemonSetSpec v1DaemonSetSpec = ((V1DaemonSet)kubernetesObject).getSpec();
            list2 = this.extractPortForwardingPairs(v1DaemonSetSpec != null && (v1DaemonSetSpec = v1DaemonSetSpec.getTemplate()) != null ? v1DaemonSetSpec.getSpec() : null);
        } else if (kubernetesObject2 instanceof V1ReplicationController) {
            V1ReplicationControllerSpec v1ReplicationControllerSpec = ((V1ReplicationController)kubernetesObject).getSpec();
            list2 = this.extractPortForwardingPairs(v1ReplicationControllerSpec != null && (v1ReplicationControllerSpec = v1ReplicationControllerSpec.getTemplate()) != null ? v1ReplicationControllerSpec.getSpec() : null);
        } else if (kubernetesObject2 instanceof V1Pod) {
            list2 = this.extractPortForwardingPairs(((V1Pod)kubernetesObject).getSpec());
        } else if (kubernetesObject2 instanceof V1Service) {
            List<Pair<Integer, Integer>> list3;
            Object object = ((V1Service)kubernetesObject).getSpec();
            if (object != null && (object = object.getPorts()) != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    V1ServicePort it = (V1ServicePort)element$iv$iv;
                    boolean bl2 = false;
                    if (TuplesKt.to((Object)it.getNodePort(), (Object)it.getPort()) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list3 = (List<Pair<Integer, Integer>>)destination$iv$iv;
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
        } else {
            V1JobSpec v1JobSpec;
            list2 = kubernetesObject2 instanceof V1Job ? this.extractPortForwardingPairs((v1JobSpec = ((V1Job)kubernetesObject).getSpec()) != null && (v1JobSpec = v1JobSpec.getTemplate()) != null ? v1JobSpec.getSpec() : null) : CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Integer, Integer>> extractPortForwardingPairs(V1PodSpec podSpec) {
        List list2;
        List list3;
        Object object = podSpec;
        if (object != null && (object = object.getContainers()) != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)object;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list4;
                List list5;
                V1Container it = (V1Container)element$iv$iv;
                boolean bl = false;
                List list6 = it.getPorts();
                if (list6 != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    V1ContainerPort it2;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = list6;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        it2 = (V1ContainerPort)element$iv$iv2;
                        boolean bl2 = false;
                        String string = it2.getProtocol();
                        boolean bl3 = string != null ? !StringsKt.equals((String)string, (String)"TCP", (boolean)true) : false;
                        if (!(!bl3)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (V1ContainerPort)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl4 = false;
                        collection.add(TuplesKt.to((Object)it2.getHostPort(), (Object)it2.getContainerPort()));
                    }
                    list5 = (List)destination$iv$iv2;
                } else {
                    list5 = list4 = null;
                }
                if (list5 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list4;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public final Object suggestPortMappings(@NotNull KubernetesObject target, @NotNull List<? extends InetAddress> addresses2, @NotNull Continuation<? super List<String>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<String>>, Object>(target, addresses2, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int label;
            final /* synthetic */ KubernetesObject $target;
            final /* synthetic */ List<InetAddress> $addresses;
            {
                this.$target = $target;
                this.$addresses = $addresses;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block11: {
                    var32_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var3_3 = PortForwardingUtils.INSTANCE.extractPorts(this.$target);
                            var4_4 = this.$addresses;
                            $i$f$map = 0;
                            var6_7 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = 0;
                            var9_13 = $this$mapTo$iv$iv.iterator();
lbl12:
                            // 2 sources

                            while (var9_13.hasNext()) {
                                item$iv$iv = var9_13.next();
                                var11_18 = (Pair)item$iv$iv;
                                var31_29 = destination$iv$iv;
                                $i$a$-map-PortForwardingUtils$suggestPortMappings$2$suggestedPortMappings$1 = 0;
                                hostPort = (Integer)var11_18.component1();
                                remotePort = ((Number)var11_18.component2()).intValue();
                                v0 = hostPort;
                                candidatePorts = CollectionsKt.toList((Iterable)((Iterable)new IntRange(PortForwardingUtils.access$shiftPortToUserSpace(PortForwardingUtils.INSTANCE, v0 != null ? v0 : remotePort), 65535)));
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$map$iv);
                                this.L$1 = var4_4;
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$mapTo$iv$iv);
                                this.L$3 = destination$iv$iv;
                                this.L$4 = var9_13;
                                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)item$iv$iv);
                                this.L$6 = SpillingKt.nullOutSpilledVariable((Object)hostPort);
                                this.L$7 = SpillingKt.nullOutSpilledVariable((Object)candidatePorts);
                                this.L$8 = var31_29;
                                this.I$0 = $i$f$map;
                                this.I$1 = $i$f$mapTo;
                                this.I$2 = $i$a$-map-PortForwardingUtils$suggestPortMappings$2$suggestedPortMappings$1;
                                this.I$3 = remotePort;
                                this.label = 1;
                                v1 = PortForwardingUtils.access$suggestLocalPort(PortForwardingUtils.INSTANCE, var4_4, candidatePorts, (Continuation)this);
                                if (v1 == var32_2) {
                                    return var32_2;
                                }
                                ** GOTO lbl56
                            }
                            break;
                        }
                        case 1: {
                            remotePort = this.I$3;
                            $i$a$-map-PortForwardingUtils$suggestPortMappings$2$suggestedPortMappings$1 = this.I$2;
                            $i$f$mapTo = this.I$1;
                            $i$f$map = this.I$0;
                            var31_29 = (Collection)this.L$8;
                            candidatePorts = (List)this.L$7;
                            hostPort = (Integer)this.L$6;
                            item$iv$iv = this.L$5;
                            var9_13 = (Iterator)this.L$4;
                            destination$iv$iv = (Collection)this.L$3;
                            $this$mapTo$iv$iv = (Iterable)this.L$2;
                            var4_4 = (List)this.L$1;
                            $this$map$iv = (Iterable)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl56:
                            // 2 sources

                            var31_29.add(TuplesKt.to((Object)v1, (Object)Boxing.boxInt((int)remotePort)));
                            ** GOTO lbl12
                        }
                    }
                    suggestedPortMappings = (List)destination$iv$iv;
                    var4_4 = suggestedPortMappings;
                    $i$f$map = new ArrayList<E>();
                    $i$f$mapTo = false;
                    for (E item$iv : $this$mapTo$iv) {
                        var9_13 = (Pair)item$iv;
                        var31_29 = destination$iv;
                        $i$a$-mapTo-PortForwardingUtils$suggestPortMappings$2$portMappings$1 = false;
                        var31_29.add(it.getFirst() + ":" + it.getSecond());
                    }
                    portMappings = (List)destination$iv;
                    if (portMappings.size() <= 1) break block11;
                    alreadySuggested = new LinkedHashSet<E>();
                    $i$f$mapTo = suggestedPortMappings;
                    var7_10 = this.$addresses;
                    $i$f$map = 0;
                    it = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = 0;
                    var12_21 = $this$mapTo$iv$iv.iterator();
lbl81:
                    // 2 sources

                    while (var12_21.hasNext()) {
                        block12: {
                            item$iv$iv = var12_21.next();
                            var14_25 = (Pair)item$iv$iv;
                            var31_29 = destination$iv$iv;
                            $i$a$-map-PortForwardingUtils$suggestPortMappings$2$joinedPorts$1 = 0;
                            localPort = ((Number)var14_25.component1()).intValue();
                            remotePort = ((Number)var14_25.component2()).intValue();
                            if (!alreadySuggested.add(Boxing.boxInt((int)localPort))) break block12;
                            v2 = TuplesKt.to((Object)Boxing.boxInt((int)localPort), (Object)Boxing.boxInt((int)remotePort));
                            ** GOTO lbl151
                        }
                        var18_33 = (Iterable)new IntRange(localPort, 65535);
                        var19_34 = var7_10;
                        var20_35 = PortForwardingUtils.INSTANCE;
                        $i$f$filter = false;
                        var22_37 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = ((Number)element$iv$iv).intValue();
                            $i$a$-filter-PortForwardingUtils$suggestPortMappings$2$joinedPorts$1$newSuggestedPort$1 = false;
                            if (!(alreadySuggested.contains(Boxing.boxInt((int)it)) == false)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        var29_44 = (List)destination$iv$iv;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)suggestedPortMappings);
                        this.L$1 = portMappings;
                        this.L$2 = alreadySuggested;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map$iv);
                        this.L$4 = var7_10;
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$mapTo$iv$iv);
                        this.L$6 = destination$iv$iv;
                        this.L$7 = var12_21;
                        this.L$8 = SpillingKt.nullOutSpilledVariable((Object)item$iv$iv);
                        this.L$9 = var31_29;
                        this.I$0 = $i$f$map;
                        this.I$1 = $i$f$mapTo;
                        this.I$2 = $i$a$-map-PortForwardingUtils$suggestPortMappings$2$joinedPorts$1;
                        this.I$3 = localPort;
                        this.I$4 = remotePort;
                        this.label = 2;
                        v3 = PortForwardingUtils.access$suggestLocalPort(var20_35, var19_34, var29_44, (Continuation)this);
                        if (v3 == var32_2) {
                            return var32_2;
                        }
                        ** GOTO lbl146
                    }
                    {
                        break;
                        case 2: {
                            remotePort = this.I$4;
                            localPort = this.I$3;
                            $i$a$-map-PortForwardingUtils$suggestPortMappings$2$joinedPorts$1 = this.I$2;
                            $i$f$mapTo = this.I$1;
                            $i$f$map = this.I$0;
                            var31_29 = (Collection)this.L$9;
                            item$iv$iv = this.L$8;
                            var12_21 = (Iterator<T>)this.L$7;
                            destination$iv$iv = (Collection)this.L$6;
                            $this$mapTo$iv$iv = (Iterable)this.L$5;
                            var7_10 = (List)this.L$4;
                            $this$map$iv = (Iterable)this.L$3;
                            alreadySuggested = (Set)this.L$2;
                            portMappings = (List)this.L$1;
                            suggestedPortMappings = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl146:
                            // 2 sources

                            newSuggestedPort = ((Number)v3).intValue();
                            alreadySuggested.add(Boxing.boxInt((int)newSuggestedPort));
                            v2 = TuplesKt.to((Object)Boxing.boxInt((int)newSuggestedPort), (Object)Boxing.boxInt((int)remotePort));
lbl151:
                            // 2 sources

                            var31_29.add(v2);
                            ** GOTO lbl81
                        }
                    }
                    joinedPorts = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$3(kotlin.Pair ), (Lkotlin/Pair;)Ljava/lang/CharSequence;)(), (int)30, null);
                    portMappings.add(joinedPorts);
                }
                return portMappings;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final CharSequence invokeSuspend$lambda$3(Pair it) {
                return it.getFirst() + ":" + it.getSecond();
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object suggestLocalPort(List<? extends InetAddress> addresses, List<Integer> candidatePorts, Continuation<? super Integer> $completion) {
        if (!($completion instanceof suggestLocalPort.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ PortForwardingUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PortForwardingUtils.access$suggestLocalPort(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)addresses);
                $continuation.L$1 = candidatePorts;
                $continuation.label = 1;
                v0 = this.findAvailablePort(addresses, candidatePorts, (Continuation<? super Integer>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                candidatePorts = (List)$continuation.L$1;
                addresses = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = (Integer)v0;
                if (v1 != null) {
                    v2 = v1;
                } else {
                    v3 = (Integer)CollectionsKt.firstOrNull((List)candidatePorts);
                    v2 = v3 != null ? v3 : -1;
                }
                return Boxing.boxInt((int)v2);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int shiftPortToUserSpace(int basePortToSuggest) {
        return basePortToSuggest <= 1024 ? basePortToSuggest + 8000 : basePortToSuggest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object isPortAvailable(int port, @Nullable InetAddress address, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isPortAvailable.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                int I$1;
                int I$2;
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ PortForwardingUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.isPortAvailable(0, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = PortForwardingUtils.portCheckMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = address;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = port;
                $continuation.I$1 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = $continuation.I$1;
                port = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                address = (InetAddress)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 3 sources

                $i$a$-withLock$default-PortForwardingUtils$isPortAvailable$2 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)address);
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = port;
                $continuation.I$1 = $i$f$withLock;
                $continuation.I$2 = $i$a$-withLock$default-PortForwardingUtils$isPortAvailable$2;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(port, address, null){
                    int label;
                    final /* synthetic */ int $port;
                    final /* synthetic */ InetAddress $address;
                    {
                        this.$port = $port;
                        this.$address = $address;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                boolean bl;
                                ResultKt.throwOnFailure((Object)$result);
                                try {
                                    boolean bl2;
                                    Closeable closeable = new ServerSocket(this.$port, 50, this.$address);
                                    Throwable throwable = null;
                                    try {
                                        ServerSocket it = (ServerSocket)closeable;
                                        boolean bl3 = false;
                                        bl2 = true;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                    bl = bl2;
                                }
                                catch (Exception exception) {
                                    bl = false;
                                }
                                return Boxing.boxBoolean((boolean)bl);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var12_6) goto lbl44
lbl43:
                // 1 sources

                return var12_6;
lbl44:
                // 1 sources

                ** GOTO lbl57
            }
            case 2: {
                $i$a$-withLock$default-PortForwardingUtils$isPortAvailable$2 = $continuation.I$2;
                $i$f$withLock = $continuation.I$1;
                port = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                address = (InetAddress)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl57:
                    // 2 sources

                    var8_13 = Boxing.boxBoolean((boolean)((Boolean)v1));
                }
                catch (Throwable var9_14) {
                    throw var9_14;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var8_13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object isPortAvailable(@NotNull List<? extends InetAddress> address, int port, @NotNull Continuation<? super Boolean> $completion) {
        block10: {
            if (!($completion instanceof isPortAvailable.3)) ** GOTO lbl-1000
            var12_4 = $completion;
            if ((var12_4.label & -2147483648) != 0) {
                var12_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    int I$1;
                    int I$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ PortForwardingUtils this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.isPortAvailable(null, 0, (Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var5_7 = address;
                    if (var5_7.isEmpty()) {
                        $i$a$-ifEmpty-PortForwardingUtils$isPortAvailable$addressesToCheck$1 = false;
                        v0 = CollectionsKt.listOf((Object)InetAddress.getByName("127.0.0.1"));
                    } else {
                        v0 = var5_7;
                    }
                    addressesToCheck = (List)v0;
                    $this$all$iv = addressesToCheck;
                    $i$f$all = 0;
                    if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl24
                    v1 = true;
                    break block10;
lbl24:
                    // 1 sources

                    var7_10 = $this$all$iv.iterator();
lbl25:
                    // 2 sources

                    while (var7_10.hasNext()) {
                        element$iv = var7_10.next();
                        it = (InetAddress)element$iv;
                        $i$a$-all-PortForwardingUtils$isPortAvailable$4 = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)address);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)addressesToCheck);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$all$iv);
                        $continuation.L$3 = var7_10;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = port;
                        $continuation.I$1 = $i$f$all;
                        $continuation.I$2 = $i$a$-all-PortForwardingUtils$isPortAvailable$4;
                        $continuation.label = 1;
                        v2 = PortForwardingUtils.INSTANCE.isPortAvailable(port, it, (Continuation<? super Boolean>)$continuation);
                        if (v2 == var13_6) {
                            return var13_6;
                        }
                        ** GOTO lbl56
                    }
                    break;
                }
                case 1: {
                    $i$a$-all-PortForwardingUtils$isPortAvailable$4 = $continuation.I$2;
                    $i$f$all = $continuation.I$1;
                    port = $continuation.I$0;
                    it = (InetAddress)$continuation.L$5;
                    element$iv = $continuation.L$4;
                    var7_10 = (Iterator<T>)$continuation.L$3;
                    $this$all$iv = (Iterable)$continuation.L$2;
                    addressesToCheck = (List)$continuation.L$1;
                    address = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl56:
                    // 2 sources

                    if (((Boolean)v2).booleanValue()) ** GOTO lbl25
                    v1 = false;
                    break block10;
                }
            }
            v1 = true;
        }
        return Boxing.boxBoolean((boolean)v1);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object findAvailablePort(@NotNull List<? extends InetAddress> address, @NotNull List<Integer> portRange, @NotNull Continuation<? super Integer> $completion) {
        block10: {
            if (!($completion instanceof findAvailablePort.1)) ** GOTO lbl-1000
            var12_4 = $completion;
            if ((var12_4.label & -2147483648) != 0) {
                var12_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ PortForwardingUtils this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.findAvailablePort(null, null, (Continuation<? super Integer>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var5_7 = address;
                    if (var5_7.isEmpty()) {
                        $i$a$-ifEmpty-PortForwardingUtils$findAvailablePort$addressesToCheck$1 = false;
                        v0 = CollectionsKt.listOf((Object)InetAddress.getByName("127.0.0.1"));
                    } else {
                        v0 = var5_7;
                    }
                    addressesToCheck = (List)v0;
                    var6_9 = portRange;
                    var7_11 = var6_9.iterator();
lbl21:
                    // 2 sources

                    while (var7_11.hasNext()) {
                        var8_12 = var7_11.next();
                        port = ((Number)var8_12).intValue();
                        $i$a$-find-PortForwardingUtils$findAvailablePort$2 = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)address);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)portRange);
                        $continuation.L$2 = addressesToCheck;
                        $continuation.L$3 = var7_11;
                        $continuation.L$4 = var8_12;
                        $continuation.I$0 = port;
                        $continuation.I$1 = $i$a$-find-PortForwardingUtils$findAvailablePort$2;
                        $continuation.label = 1;
                        v1 = PortForwardingUtils.INSTANCE.isPortAvailable(addressesToCheck, port, (Continuation<? super Boolean>)$continuation);
                        if (v1 == var13_6) {
                            return var13_6;
                        }
                        ** GOTO lbl48
                    }
                    break;
                }
                case 1: {
                    $i$a$-find-PortForwardingUtils$findAvailablePort$2 = $continuation.I$1;
                    port = $continuation.I$0;
                    var8_12 = $continuation.L$4;
                    var7_11 = (Iterator<T>)$continuation.L$3;
                    addressesToCheck = (List)$continuation.L$2;
                    portRange = (List)$continuation.L$1;
                    address = (List)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    if (!((Boolean)v1).booleanValue()) ** GOTO lbl21
                    v2 = var8_12;
                    break block10;
                }
            }
            v2 = null;
        }
        return v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ int access$shiftPortToUserSpace(PortForwardingUtils $this, int basePortToSuggest) {
        return $this.shiftPortToUserSpace(basePortToSuggest);
    }

    public static final /* synthetic */ Object access$suggestLocalPort(PortForwardingUtils $this, List addresses2, List candidatePorts, Continuation $completion) {
        return $this.suggestLocalPort(addresses2, candidatePorts, (Continuation<? super Integer>)$completion);
    }

    static {
        Object[] objectArray = new KubernetesEntity[]{KubernetesEntity.Pod, KubernetesEntity.Deployment, KubernetesEntity.Service, KubernetesEntity.ReplicaSet, KubernetesEntity.StatefulSet, KubernetesEntity.Job, KubernetesEntity.DaemonSet, KubernetesEntity.ReplicationController};
        supportedEntities = CollectionsKt.listOf((Object[])objectArray);
        portCheckMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }
}

