/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.notification;

import com.intellij.kubernetes.api.KubectlException;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.util.KubernetesRuntimeUtilitiesKt;
import com.intellij.kubernetes.view.notification.KubernetesNotificationManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0007J,\u0010\u0012\u001a\u00020\u000f2\u001c\u0010\u0010\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0013H\u0087@\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\"\u0010\u001a\u001a\u00020\u000f2\u000b\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\r\b\u0002\u0010\u001e\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001fJ\u0006\u0010#\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "notified", "Ljava/util/concurrent/atomic/AtomicBoolean;", "exceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "getExceptionHandler", "()Lkotlinx/coroutines/CoroutineExceptionHandler;", "tryAndReport", "", "body", "Lkotlin/Function0;", "tryAndReportAsync", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportRequestError", "throwable", "", "reset", "reportWarning", "message", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "title", "Lorg/jetbrains/annotations/Nls;", "installationNotification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "showKubernetesInstallationNotification", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n47#2,4:139\n23#3:143\n23#3:144\n1586#4:145\n1661#4,3:146\n*S KotlinDebug\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager\n*L\n33#1:139,4\n75#1:143\n97#1:144\n114#1:145\n114#1:146,3\n*E\n"})
public final class KubernetesNotificationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AtomicBoolean notified;
    @NotNull
    private final CoroutineExceptionHandler exceptionHandler;
    @NotNull
    private final AtomicReference<Notification> installationNotification;

    public KubernetesNotificationManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.notified = new AtomicBoolean();
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.exceptionHandler = new CoroutineExceptionHandler(key, this){
            final /* synthetic */ KubernetesNotificationManager this$0;
            {
                this.this$0 = kubernetesNotificationManager;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(CoroutineContext context, Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                this.this$0.reset();
                this.this$0.reportRequestError(throwable);
            }
        };
        this.installationNotification = new AtomicReference();
    }

    @NotNull
    public final CoroutineExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @ApiStatus.Internal
    public final void tryAndReport(@NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        try {
            body.invoke();
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            this.reportRequestError(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Internal
    @Nullable
    public final Object tryAndReportAsync(@NotNull Function1<? super Continuation<? super Unit>, ? extends Object> body, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof tryAndReportAsync.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ KubernetesNotificationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.tryAndReportAsync(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)body);
                $continuation.label = 1;
                v0 = body.invoke((Object)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                body = (Function1)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.reportRequestError(e);
                }
lbl31:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void reportRequestError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (throwable instanceof KubectlException) {
            this.showKubernetesInstallationNotification();
            return;
        }
        KubernetesNotificationManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(KubernetesNotificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        KubernetesRuntimeUtilitiesKt.logOrWarnWithDebug(logger, throwable);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, throwable, null){
            int label;
            final /* synthetic */ KubernetesNotificationManager this$0;
            final /* synthetic */ Throwable $throwable;
            {
                this.this$0 = $receiver;
                this.$throwable = $throwable;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!KubernetesNotificationManager.access$getNotified$p(this.this$0).compareAndSet(false, true)) {
                            return Unit.INSTANCE;
                        }
                        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
                        String string = KubernetesBundle.message("KubernetesNotificationManager.requestError.title", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Throwable $this$messageOrClass$iv = this.$throwable;
                        boolean $i$f$getMessageOrClass = false;
                        String string2 = $this$messageOrClass$iv.getMessage();
                        if (string2 == null) {
                            String string3 = $this$messageOrClass$iv.getClass().getName();
                            string2 = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        }
                        String string4 = StringUtil.shortenTextWithEllipsis((String)string2, (int)250, (int)15);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"shortenTextWithEllipsis(...)");
                        notificationGroup.createNotification(string, string4, NotificationType.ERROR).addAction(ActionManager.getInstance().getAction("Kubernetes.CustomizeNotifications")).notify(KubernetesNotificationManager.access$getProject$p(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void reset() {
        this.notified.set(false);
    }

    public final void reportWarning(@NotNull String message2, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        KubernetesNotificationManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(KubernetesNotificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Unable to perform operation " + message2);
        NotificationsKt.getKubernetesNotificationGroup().createNotification(title, message2, NotificationType.WARNING).notify(this.project);
    }

    public static /* synthetic */ void reportWarning$default(KubernetesNotificationManager kubernetesNotificationManager, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            String string3 = KubernetesBundle.message("KubernetesNotificationManager.message.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            string2 = string3;
        }
        kubernetesNotificationManager.reportWarning(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public final void showKubernetesInstallationNotification() {
        Notification updated;
        void $this$mapTo$iv$iv;
        ActionManager actionManager = ActionManager.getInstance();
        Object[] objectArray = new String[]{"Kubernetes.InstallKubectl", "Kubernetes.HowToInstallKubectlAction", "Kubernetes.ShowSettings"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(actionManager.getAction((String)it));
        }
        List actions = (List)destination$iv$iv;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Kubernetes.Executables");
        String string = KubernetesBundle.message("kubectl.not.found.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = KubernetesBundle.message("kubectl.not.found.notification.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).addActions((Collection)actions);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addActions(...)");
        Notification notification2 = notification;
        notification2.whenExpired(() -> KubernetesNotificationManager.showKubernetesInstallationNotification$lambda$1(this, notification2));
        Notification notification3 = updated = this.installationNotification.updateAndGet(arg_0 -> KubernetesNotificationManager.showKubernetesInstallationNotification$lambda$2(notification2, arg_0));
        boolean bl = notification3 != null ? !notification3.isExpired() : false;
        if (bl) {
            notification2.notify(this.project);
        }
    }

    private static final void showKubernetesInstallationNotification$lambda$1(KubernetesNotificationManager this$0, Notification $notification) {
        this$0.installationNotification.compareAndSet($notification, null);
    }

    private static final Notification showKubernetesInstallationNotification$lambda$2(Notification $notification, Notification prev) {
        block0: {
            Notification notification = prev;
            if (notification == null) break block0;
            notification.expire();
        }
        return $notification;
    }

    @JvmStatic
    @NotNull
    public static final KubernetesNotificationManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @Nullable
    public static final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super KubernetesNotificationManager> $completion) {
        return Companion.getInstanceAsync(project, $completion);
    }

    public static final /* synthetic */ AtomicBoolean access$getNotified$p(KubernetesNotificationManager $this) {
        return $this.notified;
    }

    public static final /* synthetic */ Project access$getProject$p(KubernetesNotificationManager $this) {
        return $this.project;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceAsync", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n30#2,2:139\n75#2:141\n*S KotlinDebug\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion\n*L\n41#1:139,2\n44#1:141\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KubernetesNotificationManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesNotificationManager> serviceClass$iv = KubernetesNotificationManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesNotificationManager)object;
        }

        @JvmStatic
        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super KubernetesNotificationManager> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(KubernetesNotificationManager.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

