/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.execution.KubernetesLogsService;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import io.kubernetes.client.openapi.models.V1Deployment;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeploymentDownloadLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes"})
public final class KubernetesDeploymentDownloadLogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        V1Deployment resource = (V1Deployment)ActionUtilsKt.getKubernetesResourceOrNull(event2);
        if (resource == null || ActionUtilsKt.getBackendApiModel(event2) == null) {
            event2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        event2.getPresentation().setEnabledAndVisible(true);
        Presentation presentation = event2.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Object[] objectArray = new Object[]{resource};
        Supplier<String> supplier = KubernetesBundle.messagePointer("action.Kubernetes.DeploymentDownloadLog.named.description", objectArray);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        Supplier<String> description = supplier;
        presentation2.setDescription(description);
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project = event2.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project2, "deployment-download");
        KubernetesApiModel kubernetesApiModel = ActionUtilsKt.getBackendApiModel(event2);
        if (kubernetesApiModel == null) {
            return;
        }
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        V1Deployment v1Deployment = (V1Deployment)ActionUtilsKt.getKubernetesResourceOrNull(event2);
        if (v1Deployment == null) {
            return;
        }
        V1Deployment resource = v1Deployment;
        KubernetesLogsService.Companion.getInstance(project2).scheduleDownloading(apiModel2, resource);
    }
}

