/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.BasicDialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.ECMA6LanguageDialect;
import com.intellij.lang.javascript.dialects.FlowJSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSBlockStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.stubs.StubBuildCachedValuesManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.XmlElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0012\u0010\u0015\u001a\u00020\u0012*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010*\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u001a\u0010+\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0007J\u001a\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0010H\u0007J\u001a\u00101\u001a\u0002022\b\u0010\u001c\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0007J\u001a\u00100\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/lang/javascript/DialectDetector;", "", "<init>", "()V", "KEY", "Lcom/intellij/psi/FilePropertyKey;", "", "JAVASCRIPT_FILE_TYPES_ARRAY", "", "Lcom/intellij/openapi/fileTypes/FileType;", "[Lcom/intellij/openapi/fileTypes/FileType;", "JAVASCRIPT_FILE_TYPES", "", "DIALECT_HOLDER_PROVIDER", "Lcom/intellij/psi/stubs/StubBuildCachedValuesManager$StubBuildCachedValueProvider;", "Lcom/intellij/lang/javascript/JSLanguageDialect;", "Lcom/intellij/psi/PsiFile;", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "element", "Lcom/intellij/psi/PsiElement;", "getOptionHolder", "hasFeature", "", "feature", "Lcom/intellij/lang/javascript/dialects/JSLanguageFeature;", "optionHolder", "dialectOfFileNoCache", "file", "languageOfElement", "Lcom/intellij/lang/Language;", "calculateJSLanguage", "getJSDialectOfFile", "languageDialectOfElement", "isTypeScript", "isActionScript", "isJavaScript", "isJavaScriptFamily", "hasJSSyntax", "isES6", "isES6OrES6Target", "isFlow", "isJSX", "getLanguageDialect", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageDialectForJSFile", "getConfiguredJSVersion", "getConfiguredJSLevel", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "intellij.javascript.psi.impl"})
public final class DialectDetector {
    @NotNull
    public static final DialectDetector INSTANCE = new DialectDetector();
    @JvmField
    @NotNull
    public static final FilePropertyKey<String> KEY = BasicDialectDetector.KEY;
    @JvmField
    @NotNull
    public static final FileType[] JAVASCRIPT_FILE_TYPES_ARRAY = BasicDialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY;
    @JvmField
    @NotNull
    public static final Collection<FileType> JAVASCRIPT_FILE_TYPES = ArraysKt.toList((Object[])JAVASCRIPT_FILE_TYPES_ARRAY);
    @NotNull
    private static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<JSLanguageDialect, PsiFile> DIALECT_HOLDER_PROVIDER = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("JavaScript.Dialect.Holder", DialectDetector::DIALECT_HOLDER_PROVIDER$lambda$0);

    private DialectDetector() {
    }

    @JvmStatic
    @Nullable
    public static final DialectOptionHolder dialectOfElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Language language = DialectDetector.languageOfElement(element);
        JSLanguageDialect jSLanguageDialect = language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
        return jSLanguageDialect != null ? INSTANCE.getOptionHolder(jSLanguageDialect, element) : null;
    }

    @NotNull
    public final DialectOptionHolder getOptionHolder(@NotNull JSLanguageDialect $this$getOptionHolder, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getOptionHolder), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)((Object)$this$getOptionHolder), (Object)((Object)JavascriptLanguage.INSTANCE)) || Intrinsics.areEqual((Object)((Object)$this$getOptionHolder), (Object)ECMA6LanguageDialect.INSTANCE)) {
            PsiFile psiFile = element.getContainingFile();
            VirtualFile virtualFile = psiFile != null && (psiFile = psiFile.getOriginalFile()) != null ? psiFile.getVirtualFile() : null;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JSLanguageLevel languageLevel = BasicDialectDetector.getConfiguredJSLevel(virtualFile, project);
            if (languageLevel != JSLanguageLevel.FLOW) {
                return languageLevel.getDialectOptionHolder();
            }
        }
        return $this$getOptionHolder.getOptionHolder();
    }

    @JvmStatic
    public static final boolean hasFeature(@Nullable PsiElement element, @NotNull JSLanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return element != null && DialectDetector.hasFeature(DialectDetector.dialectOfElement(element), feature);
    }

    @JvmStatic
    public static final boolean hasFeature(@Nullable DialectOptionHolder optionHolder, @NotNull JSLanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return optionHolder != null && optionHolder.hasFeature(feature);
    }

    private final JSLanguageDialect dialectOfFileNoCache(PsiFile file) {
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        if (Intrinsics.areEqual((Object)language2, (Object)ECMA6LanguageDialect.INSTANCE) && FlowJSAnnotation.hasFlowPrefix(file.getViewProvider().getVirtualFile())) {
            return FlowJSLanguageDialect.INSTANCE;
        }
        if (language2 instanceof JSLanguageDialect) {
            return (JSLanguageDialect)language2;
        }
        if (language2 == HTMLLanguage.INSTANCE) {
            return null;
        }
        if (FlexSupportLoader.isMxmlOrFxgFile(file)) {
            return FlexSupportLoader.ECMA_SCRIPT_L4;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile != null && (StringsKt.equals((String)"swf", (String)virtualFile.getExtension(), (boolean)true) || StringsKt.equals((String)"swc", (String)virtualFile.getExtension(), (boolean)true))) {
            return FlexSupportLoader.ECMA_SCRIPT_L4;
        }
        if (virtualFile != null) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JSLanguageDialect dialect = DialectDetector.getLanguageDialect(virtualFile, project);
            if (dialect != null) {
                return dialect;
            }
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final Language languageOfElement(@NotNull PsiElement element) {
        PsiFile file;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof LeafPsiElement) {
            PsiElement context = ((LeafPsiElement)element).getContext();
            if (context instanceof JSFile) {
                return DialectDetector.languageOfElement(context);
            }
            if (context instanceof JSElement) {
                Language language = ((JSElement)context).getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                return language;
            }
        }
        if (element instanceof XmlElement && FlexSupportLoader.isMxmlOrFxgFile(file = element.getContainingFile())) {
            JSLanguageDialect jSLanguageDialect = FlexSupportLoader.ECMA_SCRIPT_L4;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLanguageDialect), (String)"ECMA_SCRIPT_L4");
            return jSLanguageDialect;
        }
        if (element instanceof JSFile) {
            return INSTANCE.getJSDialectOfFile((PsiFile)element);
        }
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return language;
    }

    @JvmStatic
    @NotNull
    public static final Language calculateJSLanguage(@NotNull PsiElement element) {
        PsiElement parent;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof XmlBackedJSClass) {
            JSLanguageDialect jSLanguageDialect = FlexSupportLoader.ECMA_SCRIPT_L4;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLanguageDialect), (String)"ECMA_SCRIPT_L4");
            return jSLanguageDialect;
        }
        if (element instanceof PsiFile) {
            return INSTANCE.getJSDialectOfFile((PsiFile)element);
        }
        if (element instanceof JSEmbeddedContent && !(parent instanceof JSElement)) {
            Language language;
            PsiFile file = element.getContainingFile();
            if (file instanceof JSFile) {
                Language language2 = ((JSFile)file).getLanguage();
                language = language2;
                Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
            } else {
                JSLanguageDialect jSLanguageDialect = JSEmbeddedContentImpl.getLanguageForParser(((JSEmbeddedContent)element).getIElementType());
                Intrinsics.checkNotNullExpressionValue((Object)((Object)jSLanguageDialect), (String)"getLanguageForParser(...)");
                language = jSLanguageDialect;
            }
            return language;
        }
        for (parent = element.getContext(); parent != null; parent = parent.getContext()) {
            if (parent instanceof JSStubElementImpl || parent instanceof JSBlockStatementImpl || parent instanceof JSEmbeddedContent) {
                Language language = ((JSElement)parent).getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                return language;
            }
            if (!(parent instanceof PsiFile)) continue;
            return INSTANCE.getJSDialectOfFile((PsiFile)parent);
        }
        if (!element.isValid()) {
            throw new PsiInvalidElementAccessException(element);
        }
        return JavascriptLanguage.INSTANCE;
    }

    private final JSLanguageDialect getJSDialectOfFile(PsiFile file) {
        return (JSLanguageDialect)((Object)StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)((PsiElement)file), DIALECT_HOLDER_PROVIDER));
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect languageDialectOfElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (Language language = DialectDetector.languageOfElement(element); language != null; language = language.getBaseLanguage()) {
            if (!(language instanceof JSLanguageDialect)) continue;
            return (JSLanguageDialect)language;
        }
        return null;
    }

    @JvmStatic
    public static final boolean isTypeScript(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Language language = DialectDetector.languageOfElement(element);
        return language instanceof JSLanguageDialect && ((JSLanguageDialect)language).getOptionHolder().isTypeScript;
    }

    @JvmStatic
    public static final boolean isActionScript(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Language language = DialectDetector.languageOfElement(element);
        return Intrinsics.areEqual((Object)language, (Object)((Object)FlexSupportLoader.ECMA_SCRIPT_L4));
    }

    @JvmStatic
    public static final boolean isJavaScript(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Language language = DialectDetector.languageOfElement(element);
        return !(language instanceof JSLanguageDialect) || ((JSLanguageDialect)language).getOptionHolder().isJavaScript();
    }

    @JvmStatic
    public static final boolean isJavaScriptFamily(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return !DialectDetector.isActionScript(element);
    }

    @JvmStatic
    public static final boolean hasJSSyntax(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Language language = DialectDetector.languageOfElement(element);
        return language instanceof JSLanguageDialect && ((JSLanguageDialect)language).getOptionHolder().hasJSSyntax();
    }

    @JvmStatic
    public static final boolean isES6(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect != null && dialect.isECMA6;
    }

    @JvmStatic
    public static final boolean isES6OrES6Target(@NotNull PsiElement element) {
        TypeScriptConfig config;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (dialect != null && dialect.isTypeScript && (config = TypeScriptConfigService.Provider.get(element.getProject()).getPreferableConfig(element.getContainingFile().getVirtualFile())) != null) {
            return Intrinsics.areEqual((Object)config.getLanguageTarget(), (Object)TypeScriptConfig.LanguageTarget.ES6) || Intrinsics.areEqual((Object)config.getLanguageTarget(), (Object)TypeScriptConfig.LanguageTarget.NEXT);
        }
        return dialect != null && dialect.isECMA6;
    }

    @JvmStatic
    public static final boolean isFlow(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect != null && dialect.isFlow;
    }

    @JvmStatic
    @Contract(value="null->false")
    public static final boolean isJSX(@Nullable PsiElement element) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        return dialect != null && dialect.isJSX();
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect getLanguageDialect(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getLanguageDialect(file, project);
    }

    @JvmStatic
    @Nullable
    public static final JSLanguageDialect getLanguageDialectForJSFile(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getLanguageDialectForJSFile(file, project);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageDialect getConfiguredJSVersion(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return BasicDialectDetector.getConfiguredJSVersion(file);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageLevel getConfiguredJSLevel(@Nullable VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getConfiguredJSLevel(file, project);
    }

    @JvmStatic
    @NotNull
    public static final JSLanguageDialect getConfiguredJSVersion(@Nullable VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BasicDialectDetector.getConfiguredJSVersion(file, project);
    }

    private static final CachedValueProvider.Result DIALECT_HOLDER_PROVIDER$lambda$0(PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JSLanguageDialect jSLanguageDialect = INSTANCE.dialectOfFileNoCache(file);
        if (jSLanguageDialect == null) {
            jSLanguageDialect = JavascriptLanguage.INSTANCE;
        }
        Object[] objectArray = new Object[]{file};
        return CachedValueProvider.Result.create((Object)((Object)jSLanguageDialect), (Object[])objectArray);
    }
}

