/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.BasicJavaScriptElementFactory;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSFileElementTypes;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"Lcom/intellij/lang/javascript/JavascriptParserDefinition;", "Lcom/intellij/lang/ASTFactory;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "elementFactory", "Lcom/intellij/lang/javascript/BasicJavaScriptElementFactory;", "getElementFactory", "()Lcom/intellij/lang/javascript/BasicJavaScriptElementFactory;", "elementFactory$delegate", "Lkotlin/Lazy;", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getWhitespaceTokens", "Lcom/intellij/psi/tree/TokenSet;", "getCommentTokens", "getStringLiteralElements", "createParser", "Lcom/intellij/lang/PsiParser;", "createJSParser", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "builder", "Lcom/intellij/lang/PsiBuilder;", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "spaceExistenceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "Lcom/intellij/lang/ASTNode;", "right", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "createComposite", "Lcom/intellij/psi/impl/source/tree/CompositeElement;", "type", "Lcom/intellij/psi/tree/IElementType;", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJavascriptParserDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavascriptParserDefinition.kt\ncom/intellij/lang/javascript/JavascriptParserDefinition\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,93:1\n42#2,3:94\n*S KotlinDebug\n*F\n+ 1 JavascriptParserDefinition.kt\ncom/intellij/lang/javascript/JavascriptParserDefinition\n*L\n39#1:94,3\n*E\n"})
public class JavascriptParserDefinition
extends ASTFactory
implements ParserDefinition {
    @NotNull
    private final Lazy elementFactory$delegate = LazyKt.lazy(JavascriptParserDefinition::elementFactory_delegate$lambda$0);

    private final BasicJavaScriptElementFactory getElementFactory() {
        Lazy lazy = this.elementFactory$delegate;
        return (BasicJavaScriptElementFactory)lazy.getValue();
    }

    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new JSFlexAdapter(DialectOptionHolder.JS_WITH_JSX, false, false, 6, null);
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return JSFileElementTypes.INSTANCE.getFILE();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return JSTokenTypes.PARSER_WHITE_SPACE_TOKENS;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return JSElementTypes.COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return JSTokenTypes.STRING_LITERALS;
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        return (arg_0, arg_1) -> JavascriptParserDefinition.createParser$lambda$0(this, arg_0, arg_1);
    }

    @NotNull
    public JavaScriptParser createJSParser(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return new JSXParser(JavaScriptSupportLoader.ECMA_SCRIPT_6, builder);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        BasicJavaScriptElementFactory basicJavaScriptElementFactory = this.getElementFactory();
        Language language = this.getFileNodeType().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return basicJavaScriptElementFactory.createFile(viewProvider, language);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        if (left instanceof PsiWhiteSpace) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (left.getElementType() == JSTokenTypes.BACKQUOTE) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (left.getElementType() == JSTokenTypes.XML_LBRACE) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
        Intrinsics.checkNotNullExpressionValue((Object)spaceRequirements, (String)"canStickTokensTogetherByLexer(...)");
        return spaceRequirements;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getElementFactory().createElement(node);
    }

    @Nullable
    public CompositeElement createComposite(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.getElementFactory().createComposite(type);
    }

    private static final BasicJavaScriptElementFactory elementFactory_delegate$lambda$0() {
        boolean $i$f$service = false;
        Class<BasicJavaScriptElementFactory> serviceClass$iv = BasicJavaScriptElementFactory.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (BasicJavaScriptElementFactory)object;
    }

    private static final ASTNode createParser$lambda$0(JavascriptParserDefinition this$0, IElementType root, PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this$0.createJSParser(builder).parseJS(root);
        return builder.getTreeBuilt();
    }
}

