/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0014J\b\u0010\u0017\u001a\u00020\bH\u0014J\u001e\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001a\u0010\u0018\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0014J\b\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020!H\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/lang/javascript/parsing/JSPsiTypeParser;", "P", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase;", "parser", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "parseQualifiedTypeName", "", "parseType", "tryParseType", "tryParseArrowFunctionReturnType", "tryParseFunctionReturnType", "tryParseTypeParameterList", "tryParseTypeArgumentList", "revert", "allowNewLine", "isExpression", "allowStar", "parseIdentifierPart", "Lcom/intellij/lang/PsiBuilder$Marker;", "parseQualifiedTypeNameRest", "expr", "isAcceptableQualifierSeparator", "parseAfterDotInQualifiedTypeNameRest", "marker", "Lcom/intellij/openapi/util/Ref;", "separator", "Lcom/intellij/psi/tree/IElementType;", "tokenType", "parseQualifiedTypeNameTail", "parseTypeAliasType", "getTypeNameExpectedMessage", "", "intellij.javascript.parser"})
public class JSPsiTypeParser<P extends JavaScriptParser>
extends JavaScriptParserBase<P> {
    public JSPsiTypeParser(@NotNull P parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super(parser);
    }

    public boolean parseQualifiedTypeName() {
        return this.parseQualifiedTypeName(false);
    }

    public boolean parseType() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSKeywordSets.PRIMITIVE_TYPES.contains(tokenType)) {
            this.builder.advanceLexer();
        } else if (!this.parseQualifiedTypeName()) {
            this.builder.error(this.getTypeNameExpectedMessage());
        }
        return true;
    }

    public boolean tryParseType() {
        return false;
    }

    public boolean tryParseArrowFunctionReturnType() {
        return this.tryParseType();
    }

    public boolean tryParseFunctionReturnType() {
        return this.tryParseType();
    }

    public boolean tryParseTypeParameterList() {
        return true;
    }

    public boolean tryParseTypeArgumentList(boolean revert, boolean allowNewLine, boolean isExpression) {
        return true;
    }

    public final boolean parseQualifiedTypeName(boolean allowStar) {
        PsiBuilder.Marker expr = this.parseIdentifierPart();
        if (expr == null) {
            return false;
        }
        return this.parseQualifiedTypeNameRest(expr);
    }

    private final PsiBuilder.Marker parseIdentifierPart() {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            return null;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expr = marker;
        this.parser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
        return expr;
    }

    public final boolean parseQualifiedTypeNameRest(@NotNull PsiBuilder.Marker expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        PsiBuilder.Marker expr2 = expr;
        while (this.isAcceptableQualifierSeparator()) {
            IElementType separator;
            Intrinsics.checkNotNull((Object)this.builder.getTokenType());
            this.builder.advanceLexer();
            Ref ref = Ref.create((Object)expr2);
            Intrinsics.checkNotNull((Object)ref);
            boolean stop = this.parseAfterDotInQualifiedTypeNameRest((Ref<PsiBuilder.Marker>)ref, separator);
            Object object = ref.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            expr2 = (PsiBuilder.Marker)object;
            if (!stop) continue;
            break;
        }
        return this.parseQualifiedTypeNameTail(expr2);
    }

    protected boolean isAcceptableQualifierSeparator() {
        return this.builder.getTokenType() == JSTokenTypes.DOT;
    }

    protected boolean parseAfterDotInQualifiedTypeNameRest(@NotNull Ref<PsiBuilder.Marker> marker, @NotNull IElementType separator) {
        Intrinsics.checkNotNullParameter(marker, (String)"marker");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        IElementType tokenType = this.builder.getTokenType();
        PsiBuilder.Marker expr = (PsiBuilder.Marker)marker.get();
        boolean stop = this.parseAfterDotInQualifiedTypeNameRest(tokenType, separator);
        expr.done(JSElementTypes.REFERENCE_EXPRESSION);
        marker.set((Object)expr.precede());
        return stop;
    }

    protected boolean parseAfterDotInQualifiedTypeNameRest(@Nullable IElementType tokenType, @NotNull IElementType separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (tokenType != JSTokenTypes.IDENTIFIER && this.parser.isIdentifierName(tokenType)) {
            this.builder.advanceLexer();
        } else {
            JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.IDENTIFIER, "javascript.parser.message.expected.name");
        }
        return false;
    }

    protected boolean parseQualifiedTypeNameTail(@NotNull PsiBuilder.Marker expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        expr.drop();
        return true;
    }

    public boolean parseTypeAliasType() {
        throw new UnsupportedOperationException("Not supported");
    }

    @NlsContexts.ParsingError
    @NotNull
    protected String getTypeNameExpectedMessage() {
        return JavaScriptParserBundle.message("javascript.parser.message.expected.typename.or.*", new Object[0]);
    }
}

