/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.manipulators;

import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.manipulators.JSAbstractElementManipulator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSLiteralManipulator
extends JSAbstractElementManipulator<JSLiteralExpression> {
    @Override
    public JSLiteralExpression handleContentChange(@NotNull JSLiteralExpression element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            JSLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSLiteralManipulator.$$$reportNull$$$0(1);
        }
        if (newContent.isEmpty() && element.isRegExpLiteral()) {
            return null;
        }
        return super.handleContentChange(element, range, newContent);
    }

    @Override
    protected JSLiteralExpression createTree(String newText, JSLiteralExpression context) {
        PsiElement newExpr = JSInheritedLanguagesHelper.createExpressionFromText(newText, (PsiElement)context);
        return newExpr instanceof JSLiteralExpression ? (JSLiteralExpression)newExpr : context;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JSLiteralExpression element) {
        int lastIndexOfSlash;
        if (element == null) {
            JSLiteralManipulator.$$$reportNull$$$0(2);
        }
        int length = element.getTextLength();
        if (JSInheritedLanguagesHelper.isMultilineLiteral((PsiElement)element)) {
            TextRange textRange = JSInheritedLanguagesHelper.getRangeInElement((PsiElement)element);
            if (textRange == null) {
                JSLiteralManipulator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        if (element.isQuotedLiteral() && length >= 2) {
            String text = element.getText();
            if (text.charAt(0) == text.charAt(length - 1)) {
                return new TextRange(1, length - 1);
            }
            return new TextRange(1, length);
        }
        if (element.isRegExpLiteral() && length >= 2 && (lastIndexOfSlash = element.getText().lastIndexOf(47)) > 1) {
            return new TextRange(1, lastIndexOfSlash);
        }
        TextRange textRange = super.getRangeInElement((PsiElement)element);
        if (textRange == null) {
            JSLiteralManipulator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Override
    protected String getNewText(JSLiteralExpression element, TextRange range, String newContent) {
        if (JSInheritedLanguagesHelper.isMultilineLiteral((PsiElement)element)) {
            String escapedContent = JSInheritedLanguagesHelper.getMultilineLiteralContent((PsiElement)element, newContent);
            return range.replace(element.getText(), escapedContent);
        }
        if (element.isRegExpLiteral()) {
            String oldText = element.getText();
            StringBuilder sb = new StringBuilder(oldText.substring(0, range.getStartOffset()));
            JSLiteralManipulator.escapeRegex(newContent, sb);
            return sb.append(oldText.substring(range.getEndOffset())).toString();
        }
        return super.getNewText(element, range, newContent);
    }

    private static void escapeRegex(String text, StringBuilder out) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '/' && (i == 0 || text.charAt(i - 1) != '\\')) {
                out.append("\\/");
                continue;
            }
            out.append(c);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/manipulators/JSLiteralManipulator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

