/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/ClassContext;", "", "qualifierClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "thisClasses", "", "<init>", "(Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;Ljava/util/Set;)V", "getQualifierClass", "()Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "getThisClasses", "()Ljava/util/Set;", "acceptsProtectedInstanceMemberCached", "Lkotlin/Pair;", "", "acceptsProtectedStaticMemberCached", "acceptsMember", "memberClass", "accessType", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList$AccessType;", "isStatic", "computeAcceptProtected", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nAccessibilityProcessingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityProcessingHandler.kt\ncom/intellij/lang/javascript/psi/resolve/ClassContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n1807#2,3:309\n*S KotlinDebug\n*F\n+ 1 AccessibilityProcessingHandler.kt\ncom/intellij/lang/javascript/psi/resolve/ClassContext\n*L\n302#1:309,3\n*E\n"})
final class ClassContext {
    @NotNull
    private final JSClass qualifierClass;
    @NotNull
    private final Set<JSClass> thisClasses;
    @Nullable
    private Pair<? extends JSClass, Boolean> acceptsProtectedInstanceMemberCached;
    @Nullable
    private Pair<? extends JSClass, Boolean> acceptsProtectedStaticMemberCached;

    public ClassContext(@NotNull JSClass qualifierClass, @NotNull Set<? extends JSClass> thisClasses) {
        Intrinsics.checkNotNullParameter((Object)qualifierClass, (String)"qualifierClass");
        Intrinsics.checkNotNullParameter(thisClasses, (String)"thisClasses");
        this.qualifierClass = qualifierClass;
        this.thisClasses = thisClasses;
    }

    @NotNull
    public final JSClass getQualifierClass() {
        return this.qualifierClass;
    }

    @NotNull
    public final Set<JSClass> getThisClasses() {
        return this.thisClasses;
    }

    public final boolean acceptsMember(@NotNull JSClass memberClass, @NotNull JSAttributeList.AccessType accessType, boolean isStatic) {
        Intrinsics.checkNotNullParameter((Object)memberClass, (String)"memberClass");
        Intrinsics.checkNotNullParameter((Object)((Object)accessType), (String)"accessType");
        return switch (WhenMappings.$EnumSwitchMapping$0[accessType.ordinal()]) {
            case 1 -> this.thisClasses.contains(memberClass);
            case 2 -> {
                Pair<? extends JSClass, Boolean> fromCache;
                Pair<? extends JSClass, Boolean> v1 = fromCache = isStatic ? this.acceptsProtectedStaticMemberCached : this.acceptsProtectedInstanceMemberCached;
                if (fromCache != null && Intrinsics.areEqual((Object)fromCache.getFirst(), (Object)memberClass)) {
                    yield (Boolean)fromCache.getSecond();
                }
                boolean result = this.computeAcceptProtected(memberClass, isStatic);
                if (isStatic) {
                    this.acceptsProtectedStaticMemberCached = new Pair((Object)memberClass, (Object)result);
                } else {
                    this.acceptsProtectedInstanceMemberCached = new Pair((Object)memberClass, (Object)result);
                }
                yield result;
            }
            default -> true;
        };
    }

    private final boolean computeAcceptProtected(JSClass memberClass, boolean isStatic) {
        if (this.thisClasses.contains(memberClass)) {
            return true;
        }
        if (isStatic) {
            boolean acceptProtected = !JSTypeEvaluateManager.iterateTypeHierarchyFromJSClasses((Collection<JSClass>)this.thisClasses, false, (Processor<? super JSClass>)((Processor)arg_0 -> ClassContext.computeAcceptProtected$lambda$1(arg_0 -> ClassContext.computeAcceptProtected$lambda$0(memberClass, arg_0), arg_0)));
            return acceptProtected;
        }
        boolean acceptProtected = this.thisClasses.contains(this.qualifierClass) || !JSTypeEvaluateManager.iterateTypeHierarchyFromJSClasses(CollectionsKt.listOf((Object)this.qualifierClass), false, (Processor<? super JSClass>)((Processor)arg_0 -> ClassContext.computeAcceptProtected$lambda$3(arg_0 -> ClassContext.computeAcceptProtected$lambda$2(this, arg_0), arg_0)));
        return acceptProtected;
    }

    private static final boolean computeAcceptProtected$lambda$0(JSClass $memberClass, JSClass it) {
        return !$memberClass.isEquivalentTo(it);
    }

    private static final boolean computeAcceptProtected$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean computeAcceptProtected$lambda$2(ClassContext this$0, JSClass it) {
        boolean bl;
        block3: {
            void $this$any$iv;
            Iterable iterable = this$0.thisClasses;
            Intrinsics.checkNotNull((Object)it);
            JSClass jSClass = it;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement p0 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!jSClass.isEquivalentTo(p0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private static final boolean computeAcceptProtected$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSAttributeList.AccessType.values().length];
            try {
                nArray[JSAttributeList.AccessType.PRIVATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSAttributeList.AccessType.PROTECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

