/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.ProjectFileIndexSupport;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveStatus;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSPropertyAccessorChecker;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WalkUpResolveProcessor
extends BaseJSSymbolProcessor {
    private final JSResolveMatchData matchData;
    private boolean mySkipDefs;
    @NotNull
    protected final String myName;
    private boolean myTooManyCandidates;
    @Nullable
    private final JSType precomputedType;

    public WalkUpResolveProcessor(@NotNull String name, @NotNull PsiFile targetFile, @NotNull PsiElement context) {
        if (name == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(0);
        }
        if (targetFile == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(2);
        }
        this(name, targetFile, context, null);
    }

    public WalkUpResolveProcessor(@NotNull String name, @NotNull PsiFile targetFile, @NotNull PsiElement context, @Nullable JSType precomputedType) {
        if (name == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(3);
        }
        if (targetFile == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(5);
        }
        super(targetFile, context);
        this.matchData = new JSResolveMatchData();
        this.myName = name;
        this.precomputedType = precomputedType;
        if (context instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            JSExpression qualifier = refExpr.getQualifier();
            if (qualifier == null) {
                if (this.typescript) {
                    TypeScriptModule module = (TypeScriptModule)PsiTreeUtil.getParentOfType((PsiElement)refExpr, TypeScriptModule.class);
                    if (module != null) {
                        String qualifiedName = module.getQualifiedName();
                        assert (qualifiedName != null);
                        this.myTypeInfo.addAllParentScopes(qualifiedName);
                    }
                } else {
                    List<JSWithStatement> withStatements = JSPsiImplUtils.getWithStatementContexts(refExpr);
                    for (JSWithStatement withStatement : withStatements) {
                        JSExpression withExpression = withStatement.getExpression();
                        if (withExpression == null || PsiTreeUtil.isAncestor((PsiElement)withExpression, (PsiElement)this.myContext, (boolean)false)) continue;
                        this.evaluateTypeForTypeInfo((PsiElement)withExpression);
                    }
                }
            } else {
                if ((qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && qualifier instanceof JSThisExpression) {
                    JSClass clazz;
                    JSNamespace ns = JSContextResolver.resolveContext((PsiElement)qualifier);
                    this.updateTypeInfoFromThis(ns);
                    String contextQualifierText = JSNamespace.getQualifiedName(ns);
                    JSClass jSClass = clazz = contextQualifierText == null ? null : TypeScriptClassResolver.getInstance().findAnyClassByQName(contextQualifierText, JSResolveUtil.getResolveScope(context));
                    if (clazz != null) {
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(contextQualifierText, false, ns.getJSContext());
                    } else if (contextQualifierText != null) {
                        this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(contextQualifierText, true, ns.getJSContext());
                    }
                }
                this.evaluateTypeForTypeInfo((PsiElement)qualifier);
            }
        } else if (context instanceof JSDestructuringProperty) {
            PsiElement parent = context.getParent();
            this.evaluateTypeForTypeInfo(parent);
            if (this.typescript) {
                this.forceSetAddOnlyCompleteMatches();
            }
        }
        if (this.myTypeInfo.typeWasProcessed()) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.initCheckFileLevelAccess();
    }

    private void evaluateTypeForTypeInfo(@NotNull PsiElement qualifier) {
        if (qualifier == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(6);
        }
        BaseJSSymbolProcessor.JSTypeProcessorBase processor = this.createTypeProcessor();
        if (this.precomputedType != null) {
            processor.process(this.precomputedType, new JSEvaluateContext(this.myTargetFile));
        } else {
            processor.evaluateQualifier(qualifier, qualifier);
        }
    }

    @Override
    protected boolean isStrictTypingPossible(@NotNull JSType type) {
        if (type == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(7);
        }
        return super.isStrictTypingPossible(type) && !this.isPredefinedPartialResolve(type) && WalkUpResolveProcessor.isTypeSourceLimitsResolve(type);
    }

    private boolean isPredefinedPartialResolve(@NotNull JSType type) {
        if (type == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(8);
        }
        if (this.typescript || !(this.myContext instanceof JSReferenceExpression)) {
            return false;
        }
        JSExpression qualifier = ((JSReferenceExpression)this.myContext).getQualifier();
        boolean isUnqualifiedQualifier = qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null;
        return isUnqualifiedQualifier && WalkUpResolveProcessor.isJavaScriptPredefinedLibraryElement(type.getSourceElement(), false);
    }

    private static boolean isTypeSourceLimitsResolve(@NotNull JSType type) {
        JSQualifiedNamedElement initializedElement;
        JSDocComment comment;
        PsiElement sourceElement;
        if (type == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(9);
        }
        if ((sourceElement = type.getSourceElement()) instanceof JSDocComment || sourceElement instanceof JSTypeDeclaration || type.isTypeScript()) {
            return true;
        }
        if (sourceElement instanceof ImplicitJSVariableImpl && "arguments".equals(((ImplicitJSVariableImpl)sourceElement).getName())) {
            return true;
        }
        if (sourceElement instanceof JSQualifiedNamedElement && (comment = JSStubBasedPsiTreeUtil.findDocComment(sourceElement)) != null && comment.hasNamespaceTag()) {
            return true;
        }
        if (sourceElement instanceof JSObjectLiteralExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)sourceElement, false)) != null && ES6ImportHandler.isExportedWithNameOrDefault((PsiElement)initializedElement)) {
            return true;
        }
        return sourceElement instanceof JSClass && ((JSClass)sourceElement).getExtendsList() == null;
    }

    @NotNull
    public BaseJSSymbolProcessor.JSTypeProcessorBase createTypeProcessor() {
        return new JSResolveTypeProcessor();
    }

    @Override
    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context) {
        JSElement container;
        JSTypeInfo.GlobalStatusHint statusHint = super.initGlobalStatusHint(context);
        if (context instanceof JSReferenceExpression && (container = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSEmbeddedContent.class, JSFile.class})) != null && (container.getContainingFile().getContext() != null || container.getContext() instanceof XmlAttributeValue) && statusHint == JSTypeInfo.GlobalStatusHint.GLOBAL) {
            statusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = statusHint;
        if (globalStatusHint == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(10);
        }
        return globalStatusHint;
    }

    protected void doUnqualifiedCheck(@NotNull PsiElement element) {
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(11);
        }
        this.addPartialResult(element, null);
    }

    public void doQualifiedCheck(@NotNull JSPsiElementBase element) {
        JSResolveResult.ProblemKind isAcceptable;
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(12);
        }
        if ((isAcceptable = this.isAcceptable(element)) != null) {
            if (isAcceptable == JSResolveResult.ProblemKind.JS_NEED_TO_BE_EXPORTED && this.isInLibrary((PsiElement)element)) {
                return;
            }
            JSResolveResult o = new JSResolveResult((PsiElement)element, null, isAcceptable);
            EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = isAcceptable == JSResolveResult.ProblemKind.JS_NEED_TO_BE_IMPORTED ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.NOT_IMPORTED) : (isAcceptable == JSResolveResult.ProblemKind.JS_NEED_TO_BE_EXPORTED ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.NOT_EXPORTED, JSTaggedResolveResult.ResolveResultTag.PARTIAL) : EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class));
            this.matchData.addResult(o, tags);
            return;
        }
        JSQualifiedName namespace = element.getNamespace();
        IntRef matchLevel = new IntRef(-1);
        Ref isAccessible = Ref.create((Object)true);
        BaseJSSymbolProcessor.MatchType matchType = this.isAcceptableQualifiedItem(element, matchLevel, (Ref<Boolean>)isAccessible);
        if (WalkUpResolveProcessor.isCompleteOrWithContextMatchType(matchType)) {
            JSResolveResult.ProblemKind propertyAccessError = JSPropertyAccessorChecker.getPropertyAccessError(this.myContext, (PsiElement)element, false);
            if (propertyAccessError != null) {
                this.addCompleteResultWithProblem((PsiElement)element, propertyAccessError);
                return;
            }
            if (namespace != null && !((Boolean)isAccessible.get()).booleanValue() && this.checkAndAddNotAccessibleJSElement(element)) {
                return;
            }
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL) {
            this.addPartialResult((PsiElement)element, null);
        } else if (WalkUpResolveProcessor.isCompleteOrWithContextMatchType(matchType)) {
            EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT ? EnumSet.of(JSTaggedResolveResult.ResolveResultTag.CONTEXT_MATCHES) : EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
            this.matchData.addResult(new JSResolveResult((PsiElement)element), tags, matchLevel.get());
        }
    }

    private boolean isInLibrary(@NotNull PsiElement resolveResult) {
        VirtualFile file;
        if (resolveResult == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(13);
        }
        return (file = resolveResult.getContainingFile().getVirtualFile()) != null && ProjectFileIndexSupport.getInstance(this.myTargetFile.getProject()).isInLibrary(file);
    }

    private boolean checkAndAddNotAccessibleJSElement(@NotNull JSPsiElementBase element) {
        if (element == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(14);
        }
        if (this.typescript || !(this.myContext instanceof JSReferenceExpression) || JSResolveUtil.isSameReference((JSReferenceExpression)this.myContext, (PsiElement)element)) {
            return false;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        this.addCompleteResultWithProblem((PsiElement)element, accessType == JSAttributeList.AccessType.PRIVATE ? JSResolveResult.ProblemKind.JS_PRIVATE_MEMBER_IS_NOT_ACCESSIBLE : (accessType == JSAttributeList.AccessType.PROTECTED ? JSResolveResult.ProblemKind.JS_PROTECTED_MEMBER_IS_NOT_ACCESSIBLE : null));
        return true;
    }

    private void addCompleteResultWithProblem(PsiElement element, JSResolveResult.ProblemKind problemKey) {
        this.matchData.addResult(new JSResolveResult(element, null, problemKey), EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class));
    }

    private void addPartialResult(PsiElement element, @Nullable JSResolveResult.ProblemKind resolveProblem) {
        JSResolveResult o = new JSResolveResult(element, null, resolveProblem);
        this.matchData.addResult(o, EnumSet.of(JSTaggedResolveResult.ResolveResultTag.PARTIAL));
    }

    public PsiFile getBaseFile() {
        return this.myTargetFile;
    }

    @Override
    @NotNull
    public String getRequiredName() {
        String string = this.myName;
        if (string == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(15);
        }
        return string;
    }

    public ResolveResult[] getResults() {
        if (this.myTooManyCandidates) {
            return JSResolveResult.tooManyCandidatesResult();
        }
        List<JSTaggedResolveResult> taggedResolveResults = this.getTaggedResolveResults();
        if (taggedResolveResults.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        int resultCount = taggedResolveResults.size();
        ResolveResult[] result = new ResolveResult[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            JSTaggedResolveResult taggedResolveResult = taggedResolveResults.get(i);
            ResolveResult resolveResult = taggedResolveResult.result;
            if (resolveResult instanceof JSResolveResult) {
                JSResolveResult jsResolveResult = (JSResolveResult)resolveResult;
                if (taggedResolveResult.tags.contains((Object)JSTaggedResolveResult.ResolveResultTag.PARTIAL)) {
                    JSResolveStatus status = jsResolveResult.getStatus();
                    JSResolveStatus partialStatus = status.copy(status.usedImportOrExport, status.myResolveProblem, status.getSubstitutor(), true);
                    resolveResult = new JSResolveResult(jsResolveResult.getElement(), partialStatus);
                }
            }
            result[i] = resolveResult;
        }
        return result;
    }

    @NotNull
    public List<JSTaggedResolveResult> getTaggedResolveResults() {
        List<JSTaggedResolveResult> list = this.matchData.getTaggedResolveResults();
        if (list == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(16);
        }
        return list;
    }

    public void addLocalResults(@NotNull ResolveResultSink sink) {
        if (sink == null) {
            WalkUpResolveProcessor.$$$reportNull$$$0(17);
        }
        List<ResolveResultSink.JSResolveResultForSymbolProcessor> results = sink.getFilteredResults();
        for (ResolveResultSink.JSResolveResultForSymbolProcessor result : results) {
            ResolveResult e = result.getResolveResult();
            if (e.isValidResult() || !result.isCompleteMatch) {
                EnumSet<JSTaggedResolveResult.ResolveResultTag> tags = EnumSet.noneOf(JSTaggedResolveResult.ResolveResultTag.class);
                PsiElement element = e.getElement();
                if (element instanceof JSLocalImplicitElementImpl) {
                    JSLocalImplicitElementImpl localImplicitElement = (JSLocalImplicitElementImpl)element;
                    tags.add(JSTaggedResolveResult.ResolveResultTag.RECORD_TYPE_PROPERTY);
                    if (localImplicitElement.hasMinorImportance() && !localImplicitElement.hasExplicitJSType()) {
                        tags.add(JSTaggedResolveResult.ResolveResultTag.PARTIAL);
                        this.allowPartialResults();
                    }
                }
                if (result.isCompleteMatch) {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.CONTEXT_MATCHES);
                } else {
                    tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
                }
                this.matchData.addResult(e, tags, result.nestingLevel);
                continue;
            }
            if (!(e instanceof JSResolveResult)) continue;
            this.addPartialResult(e.getElement(), ((JSResolveResult)e).getResolveProblemKind());
        }
    }

    public void setSkipDefinitions(boolean b) {
        this.mySkipDefs = b;
    }

    public void setTooManyCandidates() {
        this.myTooManyCandidates = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "initGlobalStatusHint";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaggedResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypeForTypeInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedPartialResolve";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSourceLimitsResolve";
                break;
            }
            case 10: 
            case 15: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doUnqualifiedCheck";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doQualifiedCheck";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkAndAddNotAccessibleJSElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addLocalResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 15, 16 -> new IllegalStateException(string);
        };
    }

    private final class JSResolveMatchData {
        @Nullable
        private List<JSTaggedResolveResult> matchData = null;

        private JSResolveMatchData() {
        }

        void addResult(ResolveResult o, @NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags) {
            if (tags == null) {
                JSResolveMatchData.$$$reportNull$$$0(0);
            }
            this.addResult(o, tags, 0);
        }

        void addResult(ResolveResult o, @NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags, int completeMatchLevel) {
            PsiElement element;
            if (tags == null) {
                JSResolveMatchData.$$$reportNull$$$0(1);
            }
            if ((element = o.getElement()) instanceof JSDefinitionExpression && WalkUpResolveProcessor.this.mySkipDefs && JSPsiImplUtils.isUnqualifiedAssignment((JSDefinitionExpression)element)) {
                return;
            }
            if (this.matchData == null) {
                this.matchData = new SmartList();
            }
            if (WalkUpResolveProcessor.this.isFromRelevantFileOrDirectory()) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.CURRENT_FILE);
            }
            BaseJSSymbolProcessor.addResolveResultTags(tags, element, WalkUpResolveProcessor.this.myContext);
            this.matchData.add(new JSTaggedResolveResult(o, tags, completeMatchLevel));
        }

        List<JSTaggedResolveResult> getTaggedResolveResults() {
            if (this.matchData == null) {
                return Collections.emptyList();
            }
            Collections.sort(this.matchData);
            JSTaggedResolveResult topResult = this.matchData.getFirst();
            boolean topResultIsPartial = topResult.tags.contains((Object)JSTaggedResolveResult.ResolveResultTag.PARTIAL);
            if (WalkUpResolveProcessor.this.addOnlyCompleteMatches() && topResultIsPartial) {
                this.matchData = null;
                return Collections.emptyList();
            }
            int resultCount = 0;
            for (JSTaggedResolveResult taggedResolveResult : this.matchData) {
                int compare;
                if (!topResultIsPartial && (compare = taggedResolveResult.comparePriorityTo(topResult)) != 0) {
                    assert (compare > 0);
                    break;
                }
                ++resultCount;
            }
            this.matchData = this.matchData.subList(0, resultCount);
            return this.matchData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveMatchData", "addResult"));
        }
    }

    private final class JSResolveTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private JSResolveTypeProcessor() {
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext context) {
            if (type == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(1);
            }
            this.processType(type);
        }

        private void processType(@NotNull JSType type) {
            if (type == null) {
                JSResolveTypeProcessor.$$$reportNull$$$0(2);
            }
            JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)candidate -> {
                this.processCandidate((JSType)candidate);
                return true;
            }), type, WalkUpResolveProcessor.this.typescript, true, false);
            this.processCandidate(type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/WalkUpResolveProcessor$JSResolveTypeProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

