/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.syntaxSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.types.JSLiteralExpressionElementType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/syntaxSelection/JavaScriptLiteralSelectioner;", "Lcom/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase;", "<init>", "()V", "canSelect", "", "e", "Lcom/intellij/psi/PsiElement;", "select", "", "Lcom/intellij/openapi/util/TextRange;", "editorText", "", "cursorOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.javascript.psi.impl"})
public final class JavaScriptLiteralSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IElementType type = PsiTreeUtilKt.getElementType((PsiElement)e);
        return type == JSTokenTypes.STRING_LITERAL || type == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL || type == JSElementTypes.ARRAY_LITERAL_EXPRESSION || type == JSElementTypes.OBJECT_LITERAL_EXPRESSION;
    }

    @NotNull
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)editorText, (String)"editorText");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange range = e.getTextRange();
        if (range.getLength() > 2 && (!(PsiTreeUtilKt.getElementType((PsiElement)e.getParent()) instanceof JSLiteralExpressionElementType) || StringUtil.isQuotedString((String)e.getText()))) {
            return (List)new SmartList((Object)new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
        }
        return CollectionsKt.emptyList();
    }
}

