/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.instanceContainer.internal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.instanceContainer.InstanceNotOverridableException;
import com.intellij.platform.instanceContainer.InstanceNotRegisteredException;
import com.intellij.platform.instanceContainer.internal.InstanceAlreadyRegisteredException;
import com.intellij.platform.instanceContainer.internal.InstanceHolder;
import com.intellij.platform.instanceContainer.internal.InstanceInitializer;
import com.intellij.platform.instanceContainer.internal.InstanceRegistrar;
import com.intellij.platform.instanceContainer.internal.RegistrationAction;
import com.intellij.platform.instanceContainer.internal.RegistrationResult;
import com.intellij.platform.instanceContainer.internal.UtilKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012 \u0010\t\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\n\u0010\u0012\u001a\u00020\u0003H\u0096\u0080\u0004J\n\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/instanceContainer/internal/InstanceRegistrarImpl;", "Lcom/intellij/platform/instanceContainer/internal/InstanceRegistrar;", "debugString", "", "existingKeys", "", "Lcom/intellij/platform/instanceContainer/internal/InstanceHolder;", "shouldTolerateIncorrectOverrides", "", "completion", "Lkotlin/Function1;", "Lcom/intellij/platform/instanceContainer/internal/RegistrationAction;", "Lcom/intellij/platform/instanceContainer/internal/RegistrationResult;", "<init>", "(Ljava/lang/String;Ljava/util/Map;ZLkotlin/jvm/functions/Function1;)V", "_actions", "", "actions", "toString", "complete", "registerInitializer", "", "keyClassName", "initializer", "Lcom/intellij/platform/instanceContainer/internal/InstanceInitializer;", "overrideInitializer", "logIncorrectOverride", "exception", "Lcom/intellij/platform/instanceContainer/InstanceNotOverridableException;", "intellij.platform.instanceContainer"})
@SourceDebugExtension(value={"SMAP\nInstanceRegistrarImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstanceRegistrarImpl.kt\ncom/intellij/platform/instanceContainer/internal/InstanceRegistrarImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,126:1\n1#2:127\n67#3,4:128\n67#3,4:132\n67#3,4:136\n*S KotlinDebug\n*F\n+ 1 InstanceRegistrarImpl.kt\ncom/intellij/platform/instanceContainer/internal/InstanceRegistrarImpl\n*L\n79#1:128,4\n98#1:132,4\n107#1:136,4\n*E\n"})
public final class InstanceRegistrarImpl
implements InstanceRegistrar {
    @NotNull
    private final String debugString;
    @NotNull
    private final Map<String, InstanceHolder> existingKeys;
    private final boolean shouldTolerateIncorrectOverrides;
    @NotNull
    private final Function1<Map<String, ? extends RegistrationAction>, RegistrationResult> completion;
    @Nullable
    private Map<String, RegistrationAction> _actions;

    public InstanceRegistrarImpl(@NotNull String debugString, @NotNull Map<String, ? extends InstanceHolder> existingKeys, boolean shouldTolerateIncorrectOverrides, @NotNull Function1<? super Map<String, ? extends RegistrationAction>, RegistrationResult> completion) {
        Intrinsics.checkNotNullParameter((Object)debugString, (String)"debugString");
        Intrinsics.checkNotNullParameter(existingKeys, (String)"existingKeys");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        this.debugString = debugString;
        this.existingKeys = existingKeys;
        this.shouldTolerateIncorrectOverrides = shouldTolerateIncorrectOverrides;
        this.completion = completion;
        this._actions = new LinkedHashMap();
    }

    private final Map<String, RegistrationAction> actions() {
        Map<String, RegistrationAction> map = this._actions;
        if (map == null) {
            boolean bl = false;
            String string = this.debugString + " : instance registrar is already completed";
            throw new IllegalStateException(string.toString());
        }
        return map;
    }

    @NotNull
    public String toString() {
        Map<String, RegistrationAction> map;
        block3: {
            block2: {
                map = this._actions;
                if (map == null) break block2;
                Map<String, RegistrationAction> it = map;
                boolean bl = false;
                String string = "size: " + it.size();
                map = string;
                if (string != null) break block3;
            }
            map = "completed";
        }
        Map<String, RegistrationAction> stateString = map;
        return this.debugString + " instance registrar (" + (String)((Object)stateString) + ")";
    }

    @Override
    @Nullable
    public RegistrationResult complete() {
        Map<String, RegistrationAction> actions = this.actions();
        this._actions = null;
        return (RegistrationResult)this.completion.invoke(actions);
    }

    @Override
    public void registerInitializer(@NotNull String keyClassName, @NotNull InstanceInitializer initializer) {
        Intrinsics.checkNotNullParameter((Object)keyClassName, (String)"keyClassName");
        Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
        Map<String, RegistrationAction> actions = this.actions();
        InstanceHolder existingHolder = this.existingKeys.get(keyClassName);
        if (existingHolder != null) {
            UtilKt.getLOG().error((Throwable)new InstanceAlreadyRegisteredException(keyClassName, existingHolder.instanceClassName(), initializer.getInstanceClassName()));
            return;
        }
        RegistrationAction existingAction = actions.get(keyClassName);
        if (existingAction == null) {
            actions.put(keyClassName, new RegistrationAction.Register(initializer));
        } else if (existingAction instanceof RegistrationAction.Register) {
            UtilKt.getLOG().error((Throwable)new InstanceAlreadyRegisteredException(keyClassName, ((RegistrationAction.Register)existingAction).getInitializer().getInstanceClassName(), initializer.getInstanceClassName()));
        } else {
            if (existingAction instanceof RegistrationAction.Override) {
                throw new IllegalStateException("must not happen unless keyClassName is in existingKeys which is false".toString());
            }
            if (Intrinsics.areEqual((Object)existingAction, (Object)RegistrationAction.Remove.INSTANCE)) {
                throw new IllegalStateException("must not happen unless keyClassName is in existingKeys which is false".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void overrideInitializer(@NotNull String keyClassName, @Nullable InstanceInitializer initializer) {
        RegistrationAction registrationAction;
        RegistrationAction existingAction;
        Intrinsics.checkNotNullParameter((Object)keyClassName, (String)"keyClassName");
        Map<String, RegistrationAction> actions = this.actions();
        RegistrationAction registrationAction2 = existingAction = actions.get(keyClassName);
        if (registrationAction2 == null) {
            InstanceHolder existingInstanceHolder = this.existingKeys.get(keyClassName);
            if (existingInstanceHolder == null) {
                Logger logger = UtilKt.getLOG();
                Object object = initializer;
                if (object == null || (object = object.getInstanceClassName()) == null) {
                    object = "<removed>";
                }
                logger.error((Throwable)new InstanceNotRegisteredException(keyClassName + " -> " + (String)object));
                return;
            }
            if (!existingInstanceHolder.getOverridable()) {
                InstanceInitializer instanceInitializer = initializer;
                InstanceNotOverridableException exception = new InstanceNotOverridableException(keyClassName, existingInstanceHolder.instanceClassName(), instanceInitializer != null ? instanceInitializer.getInstanceClassName() : null);
                this.logIncorrectOverride(exception);
            }
            registrationAction = initializer == null ? (RegistrationAction)RegistrationAction.Remove.INSTANCE : (RegistrationAction)new RegistrationAction.Override(initializer);
        } else if (registrationAction2 instanceof RegistrationAction.Register) {
            if (!(!this.existingKeys.containsKey(keyClassName))) {
                throw new IllegalStateException("Check failed.");
            }
            if (!((RegistrationAction.Register)existingAction).getInitializer().getOverridable()) {
                InstanceInitializer instanceInitializer = initializer;
                exception = new InstanceNotOverridableException(keyClassName, ((RegistrationAction.Register)existingAction).getInitializer().getInstanceClassName(), instanceInitializer != null ? instanceInitializer.getInstanceClassName() : null);
                this.logIncorrectOverride(exception);
            }
            $this$trace$iv = UtilKt.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                var10_11 = $this$trace$iv;
                boolean bl = false;
                String string = ((RegistrationAction.Register)existingAction).getInitializer().getInstanceClassName();
                Object object = initializer;
                if (object == null || (object = object.getInstanceClassName()) == null) {
                    object = "<removed>";
                }
                var10_11.trace(this.debugString + " : " + keyClassName + " is registered and overridden in the same scope (" + string + " -> " + (String)object + ")");
            }
            if (initializer == null) {
                actions.remove(keyClassName);
                return;
            }
            registrationAction = new RegistrationAction.Register(initializer);
        } else if (registrationAction2 instanceof RegistrationAction.Override) {
            if (!this.existingKeys.containsKey(keyClassName)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!((RegistrationAction.Override)existingAction).getInitializer().getOverridable()) {
                InstanceInitializer instanceInitializer = initializer;
                exception = new InstanceNotOverridableException(keyClassName, ((RegistrationAction.Override)existingAction).getInitializer().getInstanceClassName(), instanceInitializer != null ? instanceInitializer.getInstanceClassName() : null);
                this.logIncorrectOverride(exception);
            }
            $this$trace$iv = UtilKt.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                var10_11 = $this$trace$iv;
                boolean bl = false;
                String string = ((RegistrationAction.Override)existingAction).getInitializer().getInstanceClassName();
                Object object = initializer;
                if (object == null || (object = object.getInstanceClassName()) == null) {
                    object = "<removed>";
                }
                var10_11.trace(this.debugString + " : " + keyClassName + " is overridden again in the same scope (" + string + " -> " + (String)object + ")");
            }
            registrationAction = initializer == null ? (RegistrationAction)RegistrationAction.Remove.INSTANCE : (RegistrationAction)new RegistrationAction.Override(initializer);
        } else if (registrationAction2 instanceof RegistrationAction.Remove) {
            if (!this.existingKeys.containsKey(keyClassName)) {
                throw new IllegalStateException("Check failed.");
            }
            $this$trace$iv = UtilKt.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                var10_11 = $this$trace$iv;
                boolean bl = false;
                InstanceInitializer instanceInitializer = initializer;
                var10_11.trace(this.debugString + " : " + keyClassName + " is removed and overridden again in the same scope (<removed> -> " + (instanceInitializer != null ? instanceInitializer.getInstanceClassName() : null) + ")");
            }
            registrationAction = initializer == null ? (RegistrationAction)RegistrationAction.Remove.INSTANCE : (RegistrationAction)new RegistrationAction.Override(initializer);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RegistrationAction newAction = registrationAction;
        actions.put(keyClassName, newAction);
    }

    private final void logIncorrectOverride(InstanceNotOverridableException exception) {
        if (this.shouldTolerateIncorrectOverrides) {
            UtilKt.getLOG().warn("InstanceNotOverridableException: " + exception.getMessage());
        } else {
            UtilKt.getLOG().error((Throwable)exception);
        }
    }
}

