/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.speedSearch.SpeedSearchActivator;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.matching.MatchingMode;
import com.intellij.util.ui.UIUtil;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedSearch
extends SpeedSearchSupply
implements KeyListener,
SpeedSearchActivator {
    public static final String PUNCTUATION_MARKS = "*_-+\"'/.#$>: ,;?!@%^&";
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private final boolean myMatchAllOccurrences;
    private String myString = "";
    private boolean myEnabled;
    private Matcher myMatcher;
    private boolean myJustActivated = false;

    public SpeedSearch() {
        this(false);
    }

    public SpeedSearch(boolean matchAllOccurrences) {
        this.myMatchAllOccurrences = matchAllOccurrences;
    }

    public void type(String letter) {
        this.updatePattern(this.myString + letter);
    }

    public void backspace() {
        if (!this.myString.isEmpty()) {
            this.updatePattern(this.myString.substring(0, this.myString.length() - 1));
        }
    }

    public boolean shouldBeShowing(String string) {
        return string == null || this.myString.isEmpty() || this.myMatcher != null && this.myMatcher.matches(string);
    }

    public void processKeyEvent(KeyEvent e) {
        if (e.isConsumed() || !this.myEnabled) {
            return;
        }
        String old = this.myString;
        if (e.getID() == 401) {
            if (KeymapUtil.isEventForAction(e, "EditorDeleteToWordStart")) {
                if (this.isHoldingFilter()) {
                    while (!this.myString.isEmpty() && !Character.isWhitespace(this.myString.charAt(this.myString.length() - 1))) {
                        this.backspace();
                    }
                    e.consume();
                }
            } else if (e.getKeyCode() == 8) {
                this.backspace();
                e.consume();
            } else if (e.getKeyCode() == 27) {
                if (this.isHoldingFilter()) {
                    this.updatePattern("");
                    e.consume();
                } else if (this.myJustActivated) {
                    this.myJustActivated = false;
                    this.update();
                    e.consume();
                }
            }
        } else if (e.getID() == 400) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            char ch = e.getKeyChar();
            if (Character.isLetterOrDigit(ch) || !this.startedWithWhitespace(ch) && PUNCTUATION_MARKS.indexOf(ch) != -1) {
                this.type(Character.toString(ch));
                e.consume();
            }
        }
        if (!old.equalsIgnoreCase(this.myString)) {
            WriteIntentReadAction.run(() -> this.update());
        }
    }

    private boolean startedWithWhitespace(char ch) {
        return !this.isHoldingFilter() && Character.isWhitespace(ch);
    }

    public void update() {
    }

    public void noHits() {
    }

    public boolean isHoldingFilter() {
        return this.myEnabled && !this.myString.isEmpty();
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void reset() {
        if (this.isHoldingFilter()) {
            this.updatePattern("");
        }
        if (this.myEnabled) {
            this.update();
        }
    }

    public String getFilter() {
        return this.myString;
    }

    public void updatePattern(String searchText) {
        if (this.myString.equals(searchText)) {
            return;
        }
        this.myJustActivated = false;
        String prevString = this.myString;
        this.myString = searchText;
        try {
            this.myMatcher = this.createNewMatcher(searchText);
        }
        catch (Exception e) {
            this.myMatcher = null;
        }
        this.fireStateChanged(prevString);
    }

    @NotNull
    protected Matcher createNewMatcher(String searchText) {
        String pattern = "*" + searchText;
        MatchingMode matchingMode = MatchingMode.IGNORE_CASE;
        String separators = SpeedSearchUtil.getDefaultHardSeparators();
        NameUtil.MatcherBuilder builder = new NameUtil.MatcherBuilder(pattern).withMatchingMode(matchingMode).withSeparators(separators);
        if (this.myMatchAllOccurrences) {
            builder = builder.allOccurrences();
        }
        MinusculeMatcher minusculeMatcher = builder.build();
        if (minusculeMatcher == null) {
            SpeedSearch.$$$reportNull$$$0(0);
        }
        return minusculeMatcher;
    }

    @Nullable
    public Matcher getMatcher() {
        return this.myMatcher;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @Nullable
    public Iterable<TextRange> matchingFragments(@NotNull String text) {
        Matcher matcher;
        if (text == null) {
            SpeedSearch.$$$reportNull$$$0(1);
        }
        if ((matcher = this.getMatcher()) instanceof MinusculeMatcher) {
            MinusculeMatcher matcher2 = (MinusculeMatcher)matcher;
            @NotNull List fragments = matcher2.match(text);
            return fragments != null ? ContainerUtil.map((Collection)fragments, f -> TextRange.create((int)f.getStartOffset(), (int)f.getEndOffset())) : null;
        }
        return null;
    }

    @Override
    public void refreshSelection() {
    }

    @Override
    public boolean isPopupActive() {
        return this.isHoldingFilter();
    }

    @Override
    @Nullable
    public String getEnteredPrefix() {
        return this.myString;
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isActive() {
        return this.isPopupActive();
    }

    protected boolean shouldBeActive() {
        return this.myJustActivated || this.isHoldingFilter();
    }

    @Override
    @Nullable
    public JComponent getTextField() {
        return null;
    }

    @Override
    public void activate() {
        this.myJustActivated = true;
        this.doActivate();
    }

    protected void doActivate() {
    }

    @Override
    public void addChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            SpeedSearch.$$$reportNull$$$0(2);
        }
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            SpeedSearch.$$$reportNull$$$0(3);
        }
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    private void fireStateChanged(String prevString) {
        this.myChangeSupport.firePropertyChange("enteredPrefix", prevString, this.getEnteredPrefix());
    }

    @Override
    public void findAndSelectElement(@NotNull String searchQuery) {
        if (searchQuery == null) {
            SpeedSearch.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.processKeyEvent(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.processKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.processKeyEvent(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/speedSearch/SpeedSearch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewMatcher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/speedSearch/SpeedSearch";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "matchingFragments";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelectElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

