/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.testframework.sm.ConfigurationBean;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="TestHistory", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public class TestHistoryConfiguration
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static TestHistoryConfiguration getInstance(Project project) {
        return (TestHistoryConfiguration)project.getService(TestHistoryConfiguration.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            TestHistoryConfiguration.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    public Collection<String> getFiles() {
        return new ArrayList<String>(this.myState.getHistoryElements().keySet());
    }

    public String getConfigurationName(String file) {
        ConfigurationBean bean = this.myState.getHistoryElements().get(file);
        return bean != null ? bean.name : null;
    }

    public Icon getIcon(String file) {
        ConfigurationType type;
        ConfigurationBean bean = this.myState.getHistoryElements().get(file);
        if (bean != null && (type = ConfigurationTypeUtil.findConfigurationType((String)bean.configurationId)) != null) {
            return type.getIcon();
        }
        return null;
    }

    public void registerHistoryItem(String file, String configName, String configId) {
        ConfigurationBean bean = new ConfigurationBean();
        bean.name = configName;
        bean.configurationId = configId;
        Map<String, ConfigurationBean> historyElements = this.myState.getHistoryElements();
        historyElements.put(file, bean);
        if (historyElements.size() > AbstractImportTestsAction.getHistorySize()) {
            String first = historyElements.keySet().iterator().next();
            historyElements.remove(first);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/testframework/sm/TestHistoryConfiguration", "loadState"));
    }

    public static class State {
        private final Map<String, ConfigurationBean> myHistoryElements = Collections.synchronizedMap(new LinkedHashMap());

        @Property(surroundWithTag=false)
        @XMap(entryTagName="history-entry", keyAttributeName="file")
        public Map<String, ConfigurationBean> getHistoryElements() {
            return this.myHistoryElements;
        }
    }
}

