/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestProxyPrinterProvider {
    private final TestProxyFilterProvider myFilterProvider;
    private final BaseTestsOutputConsoleView myTestOutputConsoleView;

    public TestProxyPrinterProvider(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull TestProxyFilterProvider filterProvider) {
        if (testsOutputConsoleView == null) {
            TestProxyPrinterProvider.$$$reportNull$$$0(0);
        }
        if (filterProvider == null) {
            TestProxyPrinterProvider.$$$reportNull$$$0(1);
        }
        this.myTestOutputConsoleView = testsOutputConsoleView;
        this.myFilterProvider = filterProvider;
    }

    @Nullable
    public Printer getPrinterByType(@NotNull String nodeType, @NotNull String nodeName, @Nullable String nodeArguments) {
        Filter filter;
        if (nodeType == null) {
            TestProxyPrinterProvider.$$$reportNull$$$0(2);
        }
        if (nodeName == null) {
            TestProxyPrinterProvider.$$$reportNull$$$0(3);
        }
        if ((filter = this.myFilterProvider.getFilter(nodeType, nodeName, nodeArguments)) != null && !Disposer.isDisposed((Disposable)this.myTestOutputConsoleView)) {
            return new HyperlinkPrinter(this.myTestOutputConsoleView, HyperlinkPrinter.ERROR_CONTENT_TYPE, filter);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsOutputConsoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrinterByType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HyperlinkPrinter
    extends TestsOutputConsolePrinter {
        public static final Condition<ConsoleViewContentType> ERROR_CONTENT_TYPE = contentType -> ConsoleViewContentType.ERROR_OUTPUT == contentType;
        private static final String NL = "\n";
        private final Condition<? super ConsoleViewContentType> myContentTypeCondition;
        private final Filter myFilter;

        HyperlinkPrinter(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull Condition<? super ConsoleViewContentType> contentTypeCondition, @NotNull Filter filter) {
            if (testsOutputConsoleView == null) {
                HyperlinkPrinter.$$$reportNull$$$0(0);
            }
            if (contentTypeCondition == null) {
                HyperlinkPrinter.$$$reportNull$$$0(1);
            }
            if (filter == null) {
                HyperlinkPrinter.$$$reportNull$$$0(2);
            }
            super(testsOutputConsoleView, testsOutputConsoleView.getProperties(), null);
            this.myContentTypeCondition = contentTypeCondition;
            this.myFilter = filter;
        }

        public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
            if (text == null) {
                HyperlinkPrinter.$$$reportNull$$$0(3);
            }
            if (contentType == null) {
                HyperlinkPrinter.$$$reportNull$$$0(4);
            }
            if (!this.myContentTypeCondition.value((Object)contentType)) {
                this.defaultPrint(text, contentType);
                return;
            }
            text = StringUtil.replace((String)text, (String)"\r\n", (String)NL, (boolean)false);
            StringTokenizer tokenizer = new StringTokenizer(text, NL, true);
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if (NL.equals(line)) {
                    this.defaultPrint(line, contentType);
                    continue;
                }
                this.printLine(line, contentType);
            }
        }

        private void defaultPrint(String text, ConsoleViewContentType contentType) {
            super.print(text, contentType);
        }

        private void printLine(@NotNull String line, @NotNull ConsoleViewContentType contentType) {
            Filter.Result result;
            if (line == null) {
                HyperlinkPrinter.$$$reportNull$$$0(5);
            }
            if (contentType == null) {
                HyperlinkPrinter.$$$reportNull$$$0(6);
            }
            if ((result = (Filter.Result)ReadAction.compute(() -> {
                try {
                    return this.myFilter.applyFilter(line, line.length());
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error while applying " + String.valueOf(this.myFilter) + " to '" + line + "'", t);
                }
            })) != null) {
                List<Filter.ResultItem> items = HyperlinkPrinter.sort(result.getResultItems());
                int lastOffset = 0;
                for (Filter.ResultItem item : items) {
                    this.defaultPrint(line.substring(lastOffset, item.getHighlightStartOffset()), contentType);
                    String linkText = line.substring(item.getHighlightStartOffset(), item.getHighlightEndOffset());
                    this.printHyperlink(linkText, item.getHyperlinkInfo());
                    lastOffset = item.getHighlightEndOffset();
                }
                this.defaultPrint(line.substring(lastOffset), contentType);
            } else {
                this.defaultPrint(line, contentType);
            }
        }

        @NotNull
        private static List<Filter.ResultItem> sort(@NotNull List<Filter.ResultItem> items) {
            if (items == null) {
                HyperlinkPrinter.$$$reportNull$$$0(7);
            }
            if (items.size() <= 1) {
                List<Filter.ResultItem> list = items;
                if (list == null) {
                    HyperlinkPrinter.$$$reportNull$$$0(8);
                }
                return list;
            }
            ArrayList<Filter.ResultItem> copy = new ArrayList<Filter.ResultItem>(items);
            copy.sort(Comparator.comparingInt(Filter.ResultItem::getHighlightStartOffset));
            ArrayList<Filter.ResultItem> arrayList = copy;
            if (arrayList == null) {
                HyperlinkPrinter.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testsOutputConsoleView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentTypeCondition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sort";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "print";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "printLine";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "sort";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

