/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.profiler;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.profiler.MavenProfileableGoal;
import org.jetbrains.idea.maven.ext.profiler.PluginAnalyzer;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/maven/ext/profiler/MavenTestGoal;", "Lorg/jetbrains/idea/maven/ext/profiler/MavenProfileableGoal;", "goalName", "", "shortName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "pluginGroupId", "getPluginGroupId", "()Ljava/lang/String;", "pluginArtifactId", "getPluginArtifactId", "propertyName", "getPropertyName", "getPluginAnalyzer", "Lorg/jetbrains/idea/maven/ext/profiler/PluginAnalyzer;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "intellij.maven.profiler"})
@SourceDebugExtension(value={"SMAP\nMavenParametersPatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenParametersPatcher.kt\norg/jetbrains/idea/maven/ext/profiler/MavenTestGoal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1#2:309\n*E\n"})
abstract non-sealed class MavenTestGoal
extends MavenProfileableGoal {
    @NotNull
    private final String pluginGroupId;
    @NotNull
    private final String pluginArtifactId;
    @NotNull
    private final String propertyName;

    public MavenTestGoal(@NotNull String goalName, @NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)goalName, (String)"goalName");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        super(goalName, null);
        this.pluginGroupId = "org.apache.maven.plugins";
        this.pluginArtifactId = "maven-" + shortName + "-plugin";
        this.propertyName = "maven." + shortName + ".debug";
    }

    @Override
    @NotNull
    public String getPluginGroupId() {
        return this.pluginGroupId;
    }

    @Override
    @NotNull
    public String getPluginArtifactId() {
        return this.pluginArtifactId;
    }

    @Override
    @NotNull
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    @Nullable
    public PluginAnalyzer getPluginAnalyzer(@NotNull MavenProject mavenProject) {
        PluginAnalyzer.Test test;
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        MavenPlugin mavenPlugin = this.getPlugin(mavenProject);
        if (mavenPlugin != null) {
            MavenPlugin it = mavenPlugin;
            boolean bl = false;
            test = new PluginAnalyzer.Test(mavenProject, it);
        } else {
            test = null;
        }
        return test;
    }
}

