/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeClass {
    @NotNull
    private final String myJavaxFqn;
    @NotNull
    private final String myJakartaFqn;

    protected JavaeeClass(@NotNull String javaxFqn) {
        if (javaxFqn == null) {
            JavaeeClass.$$$reportNull$$$0(0);
        }
        if (javaxFqn.startsWith(JavaeeType.JAVAX.pkg)) {
            this.myJavaxFqn = javaxFqn;
            this.myJakartaFqn = javaxFqn.replace(JavaeeType.JAVAX.pkg, JavaeeType.JAKARTA.pkg);
        } else {
            this.myJakartaFqn = javaxFqn;
            this.myJavaxFqn = javaxFqn.replace(JavaeeType.JAKARTA.pkg, JavaeeType.JAVAX.pkg);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaeeClass)) {
            return false;
        }
        JavaeeClass aClass = (JavaeeClass)o;
        return this.myJavaxFqn.equals(aClass.myJavaxFqn);
    }

    public int hashCode() {
        return this.myJavaxFqn.hashCode();
    }

    public String toString() {
        return this.javax();
    }

    public static JavaeeClass create(@NotNull String fqn) {
        if (fqn == null) {
            JavaeeClass.$$$reportNull$$$0(1);
        }
        return new JavaeeClass(fqn);
    }

    public String fqn(@NotNull Module module) {
        if (module == null) {
            JavaeeClass.$$$reportNull$$$0(2);
        }
        return this.fqn(JavaeeType.discover(module, this));
    }

    @NotNull
    public String fqn(@NotNull Project project) {
        if (project == null) {
            JavaeeClass.$$$reportNull$$$0(3);
        }
        String string = this.fqn(JavaeeType.discover(project));
        if (string == null) {
            JavaeeClass.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String fqn(@NotNull PsiElement context) {
        if (context == null) {
            JavaeeClass.$$$reportNull$$$0(5);
        }
        String string = this.fqn(JavaeeType.discover(context, this));
        if (string == null) {
            JavaeeClass.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String fqnFromAnnotated(@NotNull PsiModifierListOwner context) {
        if (context == null) {
            JavaeeClass.$$$reportNull$$$0(7);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)context, (String)this.javax(), (int)0)) {
            String string = this.javax();
            if (string == null) {
                JavaeeClass.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)context, (String)this.jakarta(), (int)0)) {
            String string = this.jakarta();
            if (string == null) {
                JavaeeClass.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.fqn((PsiElement)context);
        if (string == null) {
            JavaeeClass.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public JavaeeType typeFromAnnotated(@NotNull PsiModifierListOwner context) {
        if (context == null) {
            JavaeeClass.$$$reportNull$$$0(11);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)context, (String)this.javax(), (int)0)) {
            JavaeeType javaeeType = JavaeeType.JAVAX;
            if (javaeeType == null) {
                JavaeeClass.$$$reportNull$$$0(12);
            }
            return javaeeType;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)context, (String)this.jakarta(), (int)0)) {
            JavaeeType javaeeType = JavaeeType.JAKARTA;
            if (javaeeType == null) {
                JavaeeClass.$$$reportNull$$$0(13);
            }
            return javaeeType;
        }
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)context, this);
        if (javaeeType == null) {
            JavaeeClass.$$$reportNull$$$0(14);
        }
        return javaeeType;
    }

    public boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, int flags) {
        if (listOwner == null) {
            JavaeeClass.$$$reportNull$$$0(15);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)listOwner, (String)this.javax(), (int)flags) || AnnotationUtil.isAnnotated((PsiModifierListOwner)listOwner, (String)this.jakarta(), (int)flags);
    }

    public boolean isAnnotated(@NotNull PsiClass psiClass, int flags) {
        if (psiClass == null) {
            JavaeeClass.$$$reportNull$$$0(16);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)this.javax(), (int)flags) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)this.jakarta(), (int)flags);
    }

    @NotNull
    public String fqn(@NotNull JavaeeType javaeeType) {
        if (javaeeType == null) {
            JavaeeClass.$$$reportNull$$$0(17);
        }
        String string = JavaeeType.JAVAX.equals((Object)javaeeType) ? this.myJavaxFqn : this.myJakartaFqn;
        if (string == null) {
            JavaeeClass.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String javax() {
        String string = this.myJavaxFqn;
        if (string == null) {
            JavaeeClass.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String jakarta() {
        String string = this.myJakartaFqn;
        if (string == null) {
            JavaeeClass.$$$reportNull$$$0(20);
        }
        return string;
    }

    public String[] all() {
        return new String[]{this.myJavaxFqn, this.myJakartaFqn};
    }

    public boolean isFqn(@Nullable String fqn) {
        return this.myJavaxFqn.equals(fqn) || this.myJakartaFqn.equals(fqn);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        JavaPsiFacade javaPsi;
        if (project == null) {
            JavaeeClass.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            JavaeeClass.$$$reportNull$$$0(22);
        }
        return (javaPsi = JavaPsiFacade.getInstance((Project)project)).findClass(this.javax(), scope) != null || javaPsi.findClass(this.jakarta(), scope) != null;
    }

    public boolean isClass(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        String qualifiedName = psiClass.getQualifiedName();
        return this.javax().equals(qualifiedName) || this.jakarta().equals(qualifiedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 9, 10, 12, 13, 14, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaxFqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/utils/JavaeeClass";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/utils/JavaeeClass";
                break;
            }
            case 4: 
            case 6: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "fqn";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fqnFromAnnotated";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "typeFromAnnotated";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "javax";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "jakarta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fqn";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fqnFromAnnotated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "typeFromAnnotated";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 9, 10, 12, 13, 14, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

