/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.microservices.jvm.config.hints.HintReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanReferenceProvider
implements HintReferenceProvider {
    @Nullable
    private final String myBaseClass;

    BeanReferenceProvider(@Nullable String baseClass) {
        this.myBaseClass = baseClass;
    }

    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        if (element == null) {
            BeanReferenceProvider.$$$reportNull$$$0(0);
        }
        if (textRanges == null) {
            BeanReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            BeanReferenceProvider.$$$reportNull$$$0(2);
        }
        String text = element.getText();
        Object[] result = PsiReference.EMPTY_ARRAY;
        for (TextRange range : textRanges) {
            String value = range.substring(text);
            if (StringUtil.contains((CharSequence)value, (CharSequence)"${")) continue;
            result = (PsiReference[])ArrayUtil.append((Object[])result, (Object)this.createReference(element, range));
        }
        return result;
    }

    @NotNull
    private PsiReference createReference(PsiElement element, TextRange textRange) {
        PsiClass requiredClass = this.myBaseClass == null ? null : JavaPsiFacade.getInstance((Project)element.getProject()).findClass(this.myBaseClass, element.getResolveScope());
        return new SpringBeanReference(element, textRange, requiredClass, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "textRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/config/hints/BeanReferenceProvider";
        objectArray[2] = "getReferences";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

