/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.boot.application.metadata.SourcesKeyCollector;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyImpl;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKetPathBeanPropertyResolver;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeyDeclarationPsiElement;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeyGroupImpl;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeyLocations;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeysCollectorKt;
import com.intellij.spring.boot.application.metadata.SpringBootConfigKeysData;
import com.intellij.spring.boot.application.metadata.SpringBootKeyDefinition;
import com.intellij.spring.boot.application.metadata.SpringBootLanguageSpecificBridge;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/spring/boot/application/metadata/SpringBootConfigKeysCollector;", "", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "resolver", "Lcom/intellij/spring/boot/application/metadata/SpringBootConfigKetPathBeanPropertyResolver;", "additionalKeyDefinitions", "", "", "Lcom/intellij/spring/boot/application/metadata/SpringBootKeyDefinition;", "keyHints", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$ItemHint;", "collectConfigGroupsFromSources", "", "Lcom/intellij/spring/boot/application/metadata/SpringBootConfigKeyGroupImpl;", "collectConfigKeysFromSources", "Lcom/intellij/spring/boot/application/metadata/SpringBootConfigKeyLocations;", "collectConfigurationPropertiesDeclarations", "Lcom/intellij/spring/boot/model/properties/jam/ConfigurationProperties;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getConfigurationPropertiesClass", "Lcom/intellij/psi/PsiClass;", "configurationProperties", "intellij.spring.boot.core"})
@SourceDebugExtension(value={"SMAP\nSpringBootConfigKeysCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootConfigKeysCollector.kt\ncom/intellij/spring/boot/application/metadata/SpringBootConfigKeysCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,581:1\n1586#2:582\n1661#2,3:583\n1391#2:586\n1480#2,5:587\n18#3:592\n18#3:593\n*S KotlinDebug\n*F\n+ 1 SpringBootConfigKeysCollector.kt\ncom/intellij/spring/boot/application/metadata/SpringBootConfigKeysCollector\n*L\n58#1:582\n58#1:583,3\n59#1:586\n59#1:587,5\n144#1:592\n150#1:593\n*E\n"})
public final class SpringBootConfigKeysCollector {
    @NotNull
    private final Module module;
    @NotNull
    private final SpringBootConfigKetPathBeanPropertyResolver resolver;
    @NotNull
    private final Map<String, SpringBootKeyDefinition> additionalKeyDefinitions;
    @NotNull
    private final Map<String, MetaConfigKey.ItemHint> keyHints;

    public SpringBootConfigKeysCollector(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.resolver = new SpringBootConfigKetPathBeanPropertyResolver(this.module);
        this.additionalKeyDefinitions = new LinkedHashMap();
        this.keyHints = new LinkedHashMap();
    }

    @NotNull
    public final List<SpringBootConfigKeyGroupImpl> collectConfigGroupsFromSources() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesScope((Module)this.module).union((SearchScope)GlobalSearchScope.moduleWithDependentsScope((Module)this.module));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"union(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        List result = new ArrayList();
        for (ConfigurationProperties declaration : this.collectConfigurationPropertiesDeclarations(searchScope)) {
            Object object;
            PsiModifierListOwner psiElement;
            PsiElement psiElement2 = declaration.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsiElement(...)");
            PsiModifierListOwner psiModifierListOwner = psiElement = (PsiModifierListOwner)psiElement2;
            if (psiModifierListOwner instanceof PsiClass) {
                object = (PsiClass)psiElement;
            } else if (psiModifierListOwner instanceof PsiMethod) {
                PsiType psiType = ((PsiMethod)psiElement).getReturnType();
                PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                object = psiClassType != null ? psiClassType.resolve() : null;
            } else {
                object = null;
            }
            PsiClass sourceClass = object;
            result.add(new SpringBootConfigKeyGroupImpl(declaration.getValueOrPrefix(), SpringBootConfigKeysCollectorKt.access$getDeclarationTypeName((PsiModifierListOwner)sourceClass), psiElement));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SpringBootConfigKeyLocations collectConfigKeysFromSources() {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesScope((Module)this.module).union((SearchScope)GlobalSearchScope.moduleWithDependentsScope((Module)this.module));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"union(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        Iterable $this$map$iv = SpringBootLanguageSpecificBridge.EP_NAME.getExtensionList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SpringBootLanguageSpecificBridge springBootLanguageSpecificBridge = (SpringBootLanguageSpecificBridge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.collectKeysInModule(this.module, searchScope));
        }
        List contributedMetadata = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = contributedMetadata;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean bl = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SpringBootConfigKeysData it = (SpringBootConfigKeysData)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getConfigFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List contributedConfigFiles = (List)destination$iv$iv2;
        for (Object e : contributedMetadata) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            SpringBootConfigKeysData entry = (SpringBootConfigKeysData)e;
            this.additionalKeyDefinitions.putAll(entry.getAdditionalKeyDefinitions());
            this.keyHints.putAll(entry.getKeyHints());
        }
        GlobalSearchScope globalSearchScope2 = GlobalSearchScope.projectScope((Project)this.module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"projectScope(...)");
        GlobalSearchScope projectScope = globalSearchScope2;
        Set sourceFiles = new LinkedHashSet();
        Map allKeys = new LinkedHashMap();
        for (ConfigurationProperties configurationProperties : this.collectConfigurationPropertiesDeclarations(searchScope)) {
            Module configClassModule;
            String string;
            VirtualFile virtualFile;
            PsiClass configPsiClass;
            if (this.getConfigurationPropertiesClass(configurationProperties) == null || ModuleUtilCore.findModuleForPsiElement((PsiElement)configurationProperties.getPsiElement()) == null) continue;
            PsiFile psiFile = configPsiClass.getContainingFile();
            Object object = virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
            if (virtualFile != null && projectScope.contains(virtualFile)) {
                PsiFile psiFile2 = configPsiClass.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                sourceFiles.add(psiFile2);
            }
            if ((string = configurationProperties.getValueOrPrefix()) == null) {
                string = "";
            }
            allKeys.putAll(new SourcesKeyCollector(string, configPsiClass, configClassModule, this.resolver, this.additionalKeyDefinitions, this.keyHints, this.module).collectKeys());
        }
        for (Map.Entry entry : this.additionalKeyDefinitions.entrySet()) {
            String keyName = (String)entry.getKey();
            SpringBootKeyDefinition keyDefinition = (SpringBootKeyDefinition)entry.getValue();
            if (allKeys.containsKey(keyName)) continue;
            MetaConfigKey.AccessType accessType = MetaConfigKey.AccessType.forPsiType((PsiType)keyDefinition.getType());
            String configKeyName = SpringBootConfigKeysCollectorKt.access$toKeyName(keyName);
            Intrinsics.checkNotNull((Object)accessType);
            Pair pair = SpringBootConfigKeysCollectorKt.access$getKeyHints(this.keyHints, configKeyName, accessType);
            MetaConfigKey.ItemHint valueHint = (MetaConfigKey.ItemHint)pair.component1();
            MetaConfigKey.ItemHint keyHint = (MetaConfigKey.ItemHint)pair.component2();
            if (!SpringBootAdditionalConfigUtils.isJsonFile((PsiFile)keyDefinition.getDefiningElement().getContainingFile())) continue;
            PsiElement keyDefinitionElement = keyDefinition.getDefiningElement();
            SpringBootConfigKeyDeclarationPsiElement declarationElement = new SpringBootConfigKeyDeclarationPsiElement(null, keyDefinitionElement, keyDefinitionElement, configKeyName, configKeyName, keyDefinition.getType());
            allKeys.put(keyName, new SpringBootApplicationMetaConfigKeyImpl((PsiElement)declarationElement, MetaConfigKey.DeclarationResolveResult.ADDITIONAL_JSON, configKeyName, keyDefinition.getDescriptionText(), (Lazy<String>)keyDefinition.getDefaultValue(), (Lazy<MetaConfigKey.Deprecation>)keyDefinition.getDeprecation(), keyDefinition.getType(), accessType, valueHint, keyHint, this.resolver, null));
        }
        return new SpringBootConfigKeyLocations((Collection)SetsKt.plus((Set)sourceFiles, (Iterable)contributedConfigFiles), CollectionsKt.toList((Iterable)allKeys.values()));
    }

    private final List<ConfigurationProperties> collectConfigurationPropertiesDeclarations(GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)this.module.getProject());
        List classDeclarations = jamService.getJamClassElements((JamMemberMeta)ConfigurationProperties.CLASS_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope);
        List methodDeclarations = jamService.getJamMethodElements((JamMemberMeta)ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", scope);
        Intrinsics.checkNotNull((Object)classDeclarations);
        Collection collection = classDeclarations;
        Intrinsics.checkNotNull((Object)methodDeclarations);
        return CollectionsKt.plus((Collection)collection, (Iterable)methodDeclarations);
    }

    private final PsiClass getConfigurationPropertiesClass(ConfigurationProperties configurationProperties) {
        PsiElement psiElement = configurationProperties.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiModifierListOwner psiElement2 = (PsiModifierListOwner)psiElement;
        if (psiElement2 instanceof PsiClass) {
            return (PsiClass)psiElement2;
        }
        if (psiElement2 instanceof PsiMethod) {
            PsiClassType psiClassType;
            PsiType $this$asSafely$iv = ((PsiMethod)psiElement2).getReturnType();
            boolean $i$f$asSafely = false;
            PsiType psiType = $this$asSafely$iv;
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            if ((psiClassType = (PsiClassType)psiType) == null || (psiClassType = psiClassType.resolve()) == null) {
                return null;
            }
            PsiClassType psiClass = psiClassType;
            if (psiClass.isInterface() || psiClass.hasModifier(JvmModifier.ABSTRACT)) {
                PsiClassType psiClassType2;
                PsiType extractedType;
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null || StringsKt.startsWith$default((String)qualifiedName, (String)"java.util", (boolean)false, (int)2, null)) {
                    return psiClass;
                }
                UExpression uExpression = (UExpression)ContainerUtil.getOnlyItem((Collection)SpringCommonUtils.getReturnedUExpression((PsiMethod)((PsiMethod)psiElement2)));
                PsiType $this$asSafely$iv2 = extractedType = uExpression != null ? uExpression.getExpressionType() : null;
                boolean $i$f$asSafely2 = false;
                PsiType psiType2 = $this$asSafely$iv2;
                if (!(psiType2 instanceof PsiClassType)) {
                    psiType2 = null;
                }
                if ((psiClassType2 = (PsiClassType)psiType2) == null || (psiClassType2 = psiClassType2.resolve()) == null) {
                    return psiClass;
                }
                return psiClassType2;
            }
            return psiClass;
        }
        return null;
    }
}

