/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesValueRegexInjector
implements MultiHostInjector {
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    private static final Set<String> REGEX_CONFIG_KEYS = Set.of("endpoints.configprops.keys-to-sanitize", "endpoints.env.keys-to-sanitize");

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            SpringBootApplicationPropertiesValueRegexInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringBootApplicationPropertiesValueRegexInjector.$$$reportNull$$$0(1);
        }
        if (!SpringCommonUtils.isSpringConfigured((Project)context.getProject())) {
            return;
        }
        PsiFile file = context.getContainingFile();
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        PropertyImpl property = (PropertyImpl)context;
        String key = property.getKey();
        if (key == null || !REGEX_CONFIG_KEYS.contains(key)) {
            return;
        }
        if (!SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(file)) {
            return;
        }
        String text = property.getValue();
        if (StringUtil.isEmptyOrSpaces((String)text) || !SpringBootApplicationPropertiesValueRegexInjector.isRegEx(text)) {
            return;
        }
        ASTNode valueNode = property.getValueNode();
        if (valueNode == null) {
            return;
        }
        registrar.startInjecting((Language)RegExpLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)property, TextRange.from((int)valueNode.getPsi().getStartOffsetInParent(), (int)text.length())).doneInjecting();
    }

    private static boolean isRegEx(String value) {
        for (String part : REGEX_PARTS) {
            if (!value.contains(part)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PropertyImpl>> list = Collections.singletonList(PropertyImpl.class);
        if (list == null) {
            SpringBootApplicationPropertiesValueRegexInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueRegexInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueRegexInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

