/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.structure;

import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigModificationTracker;
import com.intellij.spring.boot.application.structure.SpringBootConfiguredPropertiesProvider;
import com.intellij.spring.boot.application.structure.SpringBootMetaKey;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/boot/application/structure/SpringBootConfiguredPropertiesPresentationProvider;", "Lcom/intellij/ide/presentation/PresentationProvider;", "Lcom/intellij/spring/boot/application/structure/SpringBootConfiguredPropertiesProvider;", "<init>", "()V", "getName", "", "t", "getIcon", "Ljavax/swing/Icon;", "Companion", "intellij.spring.boot.core"})
public final class SpringBootConfiguredPropertiesPresentationProvider
extends PresentationProvider<SpringBootConfiguredPropertiesProvider> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public String getName(@Nullable SpringBootConfiguredPropertiesProvider t) {
        return SpringBootApiBundle.message((String)"logical.spring.configured.properties", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon(@Nullable SpringBootConfiguredPropertiesProvider t) {
        return SpringBootApiIcons.SpringBoot;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/boot/application/structure/SpringBootConfiguredPropertiesPresentationProvider$Companion;", "", "<init>", "()V", "collectAllConfigProperties", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/spring/boot/application/structure/SpringBootMetaKey;", "module", "Lcom/intellij/openapi/module/Module;", "getConfigPropertiesMap", "intellij.spring.boot.core"})
    @SourceDebugExtension(value={"SMAP\nSpringBootConfiguredPropertiesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootConfiguredPropertiesProvider.kt\ncom/intellij/spring/boot/application/structure/SpringBootConfiguredPropertiesPresentationProvider$Companion\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,118:1\n18#2:119\n*S KotlinDebug\n*F\n+ 1 SpringBootConfiguredPropertiesProvider.kt\ncom/intellij/spring/boot/application/structure/SpringBootConfiguredPropertiesPresentationProvider$Companion\n*L\n98#1:119\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultiMap<PsiClass, SpringBootMetaKey> collectAllConfigProperties(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> Companion.collectAllConfigProperties$lambda$0(module));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (MultiMap)object;
        }

        private final MultiMap<PsiClass, SpringBootMetaKey> getConfigPropertiesMap(Module module) {
            List virtualFiles = SpringBootConfigurationFileService.getInstance().findConfigFilesWithImports(module, false);
            if (virtualFiles.isEmpty()) {
                MultiMap multiMap = MultiMap.empty();
                Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty(...)");
                return multiMap;
            }
            MultiMap multiMap = MultiMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
            MultiMap propertiesMap = multiMap;
            Processor processor = arg_0 -> Companion.getConfigPropertiesMap$lambda$0(propertiesMap, arg_0);
            for (VirtualFile virtualFile : virtualFiles) {
                PsiFile psiFile;
                SpringBootModelConfigFileContributor contributor;
                if (SpringBootModelConfigFileContributor.getContributor((VirtualFile)virtualFile) == null || PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile) == null) continue;
                contributor.processAllKeys(psiFile, processor);
            }
            return propertiesMap;
        }

        private static final CachedValueProvider.Result collectAllConfigProperties$lambda$0(Module $module) {
            List dependencies = new ArrayList();
            MultiMap<PsiClass, SpringBootMetaKey> configPropertiesMap = Companion.getConfigPropertiesMap($module);
            ModificationTracker modificationTracker = OuterModelsModificationTrackerManager.getTracker((Project)$module.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"getTracker(...)");
            dependencies.add(modificationTracker);
            Project project = $module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            dependencies.add(SpringBootAdditionalConfigModificationTracker.Companion.getInstance(project));
            Set set = configPropertiesMap.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
            dependencies.addAll(set);
            return CachedValueProvider.Result.create(configPropertiesMap, (Collection)dependencies);
        }

        private static final boolean getConfigPropertiesMap$lambda$0(MultiMap $propertiesMap, Pair pair) {
            block4: {
                MetaConfigKey key = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)pair.first));
                if (key == null) break block4;
                MetaConfigKey.DeclarationResolveResult declarationResolveResult = key.getDeclarationResolveResult();
                Intrinsics.checkNotNullExpressionValue((Object)declarationResolveResult, (String)"getDeclarationResolveResult(...)");
                MetaConfigKey.DeclarationResolveResult result = declarationResolveResult;
                if (result == MetaConfigKey.DeclarationResolveResult.PROPERTY) {
                    UClass containingClass;
                    UClass uClass;
                    UElement uElement = UastContextKt.toUElement((PsiElement)key.getDeclaration().getNavigationElement());
                    if (uElement != null) {
                        UElement $this$getParentOfType_u24default$iv = uElement;
                        boolean strict$iv = true;
                        boolean $i$f$getParentOfType = false;
                        uClass = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
                    } else {
                        uClass = null;
                    }
                    UClass uClass2 = containingClass = uClass;
                    if (uClass2 != null) {
                        UClass it = uClass2;
                        boolean bl = false;
                        PsiClass psiClass = it.getJavaPsi();
                        Intrinsics.checkNotNull((Object)pair);
                        $propertiesMap.putValue((Object)psiClass, (Object)new SpringBootMetaKey((Pair<PsiElement, PsiElement>)pair, key));
                    }
                }
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

