/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.spring.SpringAutodetectedModelsSearcher;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootApplicationLocalModel;
import com.intellij.spring.boot.model.SpringBootAutodetectedFilesetsSearcher;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassCollector;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContextBase;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.boot.utils.SpringBootAutodetectedModelsUtils;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringLocalModelUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.profiles.SpringProfilesService;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;

public class SpringBootAutodetectedModelsSearcher
implements SpringAutodetectedModelsSearcher {
    @NotNull
    public Set<SpringModel> getAutodetectedModels(@NotNull Module module, @NotNull Module contextModule) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(0);
        }
        if (contextModule == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(1);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(2);
            }
            return set;
        }
        List springApplications = SpringBootApplicationService.getInstance().getSpringApplications(module);
        if (springApplications.isEmpty() && !SpringBootAutodetectedModelsSearcher.hasSpringBootApplicationInDependentModules(module)) {
            Set<SpringModel> models = SpringBootAutodetectedModelsSearcher.getStarterModels(module);
            Set<SpringModel> set = models.isEmpty() ? SpringBootAutodetectedModelsSearcher.getNonBootLauncherModels(module) : models;
            if (set == null) {
                SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(3);
            }
            return set;
        }
        return SpringBootAutodetectedModelsSearcher.getSpringBootApplicationModels(contextModule, springApplications);
    }

    @NotNull
    private static Set<SpringModel> getNonBootLauncherModels(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(4);
        }
        Set<SpringModel> set = SpringBootAutodetectedModelsUtils.getSpringApplicationLauncherConfigurations(module).stream().map(launcherConfig -> launcherConfig.getLocalModels(module)).map(models -> SpringModelUtils.getInstance().getCombinedSpringModel(models, module)).collect(Collectors.toSet());
        if (set == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static boolean hasSpringBootApplicationInDependentModules(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(6);
        }
        LinkedHashSet dependentModules = new LinkedHashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)module, dependentModules);
        for (Module dependentModule : dependentModules) {
            if (SpringBootApplicationService.getInstance().getSpringApplications(dependentModule).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<SpringModel> getSpringBootApplicationModels(@NotNull Module module, @NotNull List<PsiClass> springApplications) {
        Set<LauncherConfigurations> launcherConfigurations;
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(7);
        }
        if (springApplications == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(8);
        }
        if ((launcherConfigurations = SpringBootAutodetectedModelsUtils.getSpringApplicationLauncherConfigurations(module)).isEmpty()) {
            Set localModels = ContainerUtil.map2Set(springApplications, aClass -> SpringBootAutodetectedModelsSearcher.createSpringBootApplicationModel(module, aClass));
            Set<SpringModel> set = localModels.isEmpty() ? Collections.emptySet() : Collections.singleton(SpringModelUtils.getInstance().getCombinedSpringModel(localModels, module));
            if (set == null) {
                SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(9);
            }
            return set;
        }
        return SpringBootAutodetectedModelsSearcher.createCombinedSpringBootLauncherModels(module, springApplications, launcherConfigurations);
    }

    @NotNull
    private static Set<SpringModel> createCombinedSpringBootLauncherModels(@NotNull Module module, @NotNull List<PsiClass> springApplications, @NotNull Set<LauncherConfigurations> configurations) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(10);
        }
        if (springApplications == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(11);
        }
        if (configurations == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(12);
        }
        HashSet<SpringModel> launcherModels = new HashSet<SpringModel>();
        for (LauncherConfigurations launcherConfigurations : configurations) {
            HashSet<LocalAnnotationModel> models = new HashSet<LocalAnnotationModel>();
            for (PsiClass configuration : launcherConfigurations.configurations) {
                if (springApplications.contains(configuration)) {
                    models.add(SpringBootAutodetectedModelsSearcher.createSpringBootApplicationModel(module, configuration));
                    continue;
                }
                models.add(SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(configuration, module, Collections.emptySet()));
            }
            launcherModels.add(SpringModelUtils.getInstance().getCombinedSpringModel(models, module));
        }
        HashSet<SpringModel> hashSet = launcherModels;
        if (hashSet == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    private static SpringBootApplicationLocalModel createSpringBootApplicationModel(@NotNull Module module, PsiClass aClass) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(14);
        }
        return new SpringBootApplicationLocalModel(aClass, module, SpringProfilesService.getInstance((Project)module.getProject()).getActiveProfiles(module));
    }

    private static Set<SpringModel> getStarterModels(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(15);
        }
        if (!Registry.is((String)"spring.boot.starter.autodetected.fileset")) {
            return Collections.emptySet();
        }
        PsiClass contextClass = SpringBootAutodetectedFilesetsSearcher.findAutoConfiguration(module);
        if (contextClass == null) {
            return Collections.emptySet();
        }
        Set models = SpringLocalModelUtils.getLocalAnnotationModels((Module)module, new HashSet<PsiClass>(AutoConfigClassCollector.collectConfigurationClasses((EnableAutoConfiguration)null, (ConditionalOnEvaluationContext)SpringBootAutodetectedModelsSearcher.createContext(module, contextClass))), (Set)SpringProfilesService.getInstance((Project)module.getProject()).getActiveProfiles(module));
        return models.isEmpty() ? Collections.emptySet() : Collections.singleton(SpringModelUtils.getInstance().getCombinedSpringModel(models, module));
    }

    @NotNull
    private static ConditionalOnEvaluationContextBase createContext(@NotNull Module module, PsiClass contextClass) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(16);
        }
        return new ConditionalOnEvaluationContextBase(contextClass, module, null, NotNullLazyValue.lazy(() -> Collections.emptyList()), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootAutodetectedModelsSearcher";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springApplications";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootAutodetectedModelsSearcher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutodetectedModels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonBootLauncherModels";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBootApplicationModels";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCombinedSpringBootLauncherModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutodetectedModels";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNonBootLauncherModels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringBootApplicationInDependentModules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBootApplicationModels";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCombinedSpringBootLauncherModels";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSpringBootApplicationModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStarterModels";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 9, 13 -> new IllegalStateException(string);
        };
    }

    public record LauncherConfigurations(@NotNull UCallExpression expression, @NotNull Set<PsiClass> configurations) {
        @NotNull
        private final UCallExpression expression;
        @NotNull
        private final Set<PsiClass> configurations;

        public LauncherConfigurations(@NotNull UCallExpression expression, @NotNull Set<PsiClass> configurations) {
            if (expression == null) {
                LauncherConfigurations.$$$reportNull$$$0(0);
            }
            if (configurations == null) {
                LauncherConfigurations.$$$reportNull$$$0(1);
            }
        }

        public Set<LocalAnnotationModel> getLocalModels(@NotNull Module module) {
            if (module == null) {
                LauncherConfigurations.$$$reportNull$$$0(2);
            }
            return this.configurations.stream().map(psiClass -> SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet())).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @NotNull
        public UCallExpression expression() {
            UCallExpression uCallExpression = this.expression;
            if (uCallExpression == null) {
                LauncherConfigurations.$$$reportNull$$$0(3);
            }
            return uCallExpression;
        }

        @NotNull
        public Set<PsiClass> configurations() {
            Set<PsiClass> set = this.configurations;
            if (set == null) {
                LauncherConfigurations.$$$reportNull$$$0(4);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/model/SpringBootAutodetectedModelsSearcher$LauncherConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/model/SpringBootAutodetectedModelsSearcher$LauncherConfigurations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "configurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocalModels";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

