/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.PairProcessor;
import java.util.LinkedHashMap;
import java.util.Map;

final class EnableCachingModelProvider
extends LocalAnnotationModelDependentModelsProvider {
    private static final Map<String, String> CACHE_CONFIGURATION;
    private static final Map<String, String> CACHE_CONFIGURATION_SB4;

    EnableCachingModelProvider() {
    }

    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<? super LocalModel<?>, ? super LocalModelDependency> processor) {
        String fqn = localAnnotationModel.getConfig().getQualifiedName();
        if ("org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration.CacheConfigurationImportSelector".equals(fqn)) {
            return EnableCachingModelProvider.processCacheConfigs(localAnnotationModel, processor, CACHE_CONFIGURATION);
        }
        if ("org.springframework.boot.cache.autoconfigure.CacheAutoConfiguration.CacheConfigurationImportSelector".equals(fqn)) {
            return EnableCachingModelProvider.processCacheConfigs(localAnnotationModel, processor, CACHE_CONFIGURATION_SB4);
        }
        return true;
    }

    private static boolean processCacheConfigs(LocalAnnotationModel localAnnotationModel, PairProcessor<? super LocalModel<?>, ? super LocalModelDependency> processor, Map<String, String> cacheConfigurationMap) {
        Module module = localAnnotationModel.getModule();
        for (Map.Entry<String, String> entry : cacheConfigurationMap.entrySet()) {
            PsiClass cacheConfiguration;
            if (SpringCommonUtils.findLibraryClass((Module)module, (String)entry.getValue()) == null || (cacheConfiguration = SpringCommonUtils.findLibraryClass((Module)module, (String)entry.getKey())) == null) continue;
            LocalAnnotationModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(cacheConfiguration, module, localAnnotationModel.getActiveProfiles());
            return processor.process((Object)model, (Object)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)cacheConfiguration));
        }
        return true;
    }

    static {
        LinkedHashMap<String, String> cacheConfiguration = new LinkedHashMap<String, String>();
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.CouchbaseCacheConfiguration", "com.couchbase.client.spring.cache.CouchbaseCacheManager");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.RedisCacheConfiguration", "org.springframework.data.redis.cache.RedisCacheManager");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.CaffeineCacheConfiguration", "com.github.benmanes.caffeine.cache.Caffeine");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.HazelcastCacheConfiguration", "com.hazelcast.spring.cache.HazelcastCacheManager");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.SimpleCacheConfiguration", "org.springframework.cache.CacheManager");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.GenericCacheConfiguration", "org.springframework.cache.Cache");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.JCacheCacheConfiguration", "org.springframework.cache.jcache.JCacheCacheManager");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.InfinispanCacheConfiguration", "org.infinispan.spring.provider.SpringEmbeddedCacheManager");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.EhCacheCacheConfiguration", "org.springframework.cache.Cache");
        cacheConfiguration.put("org.springframework.boot.autoconfigure.cache.Cache2kCacheConfiguration", "org.cache2k.extra.spring.SpringCache2kCacheManager");
        CACHE_CONFIGURATION = cacheConfiguration;
        LinkedHashMap<String, String> cacheConfigurationSb4 = new LinkedHashMap<String, String>();
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.CouchbaseCacheConfiguration", "org.springframework.data.couchbase.cache.CouchbaseCacheManager");
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.RedisCacheConfiguration", "org.springframework.data.redis.cache.RedisCacheManager");
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.CaffeineCacheConfiguration", "com.github.benmanes.caffeine.cache.Caffeine");
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.HazelcastCacheConfiguration", "com.hazelcast.spring.cache.HazelcastCacheManager");
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.SimpleCacheConfiguration", "org.springframework.cache.CacheManager");
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.GenericCacheConfiguration", "org.springframework.cache.Cache");
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.JCacheCacheConfiguration", "org.springframework.cache.jcache.JCacheCacheManager");
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.InfinispanCacheConfiguration", "org.infinispan.spring.provider.SpringEmbeddedCacheManager");
        cacheConfigurationSb4.put("org.springframework.boot.cache.autoconfigure.Cache2kCacheConfiguration", "org.cache2k.extra.spring.SpringCache2kCacheManager");
        CACHE_CONFIGURATION_SB4 = cacheConfigurationSb4;
    }
}

