/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnWebApplication;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConditionalOnManagementPort
implements ConditionalOnJamElement {
    private static final SemKey<ConditionalOnManagementPort> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnManagementPort", new SemKey[0]);
    private static final JamEnumAttributeMeta.Single<ManagementPortType> VALUE_ATTRIBUTE_META = JamAttributeMeta.singleEnum((String)"value", ManagementPortType.class);
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort").addAttribute(VALUE_ATTRIBUTE_META);
    public static final JamClassMeta<ConditionalOnManagementPort> CLASS_META = new JamClassMeta(null, ConditionalOnManagementPort::new, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnManagementPort> METHOD_META = new JamMethodMeta(null, ConditionalOnManagementPort::new, SEM_KEY).addAnnotation(ANNOTATION_META);
    @NonNls
    private static final String MANAGEMENT_SERVER_PORT = "management.server.port";
    private static final int MANAGEMENT_SERVER_DEFAULT_PORT = 8080;
    @NonNls
    private static final String SERVER_PORT = "server.port";
    private final PsiElementRef<PsiAnnotation> myAnnotationRef;

    private ConditionalOnManagementPort(@NotNull PsiElementRef<?> psiRef) {
        if (psiRef == null) {
            ConditionalOnManagementPort.$$$reportNull$$$0(0);
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)Objects.requireNonNull(psiRef.getPsiElement());
        this.myAnnotationRef = ANNOTATION_META.getAnnotationRef(owner);
    }

    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        if (!ConditionalOnManagementPort.isWebApplication(context)) {
            return ConditionOutcome.noMatch((String)"Not a (reactive) web application");
        }
        ManagementPortType actualType = this.getValue();
        if (actualType == null) {
            return ConditionOutcome.noMatch((String)"Invalid 'value'");
        }
        ManagementPortType requiredType = ManagementPortType.DIFFERENT;
        String managementServerPortValue = ConditionalOnManagementPort.findConfigurationValue(context, MANAGEMENT_SERVER_PORT);
        if (StringUtil.isEmptyOrSpaces((String)managementServerPortValue)) {
            requiredType = ManagementPortType.SAME;
        } else {
            int managementPort;
            try {
                managementPort = Integer.parseInt(managementServerPortValue);
            }
            catch (NumberFormatException e) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.foundConfigKeyWithValue((String)MANAGEMENT_SERVER_PORT, (String)managementServerPortValue));
            }
            if (managementPort < 0) {
                requiredType = ManagementPortType.DISABLED;
            } else {
                String serverPortValue = ConditionalOnManagementPort.findConfigurationValue(context, SERVER_PORT);
                if (serverPortValue == null) {
                    if (managementPort == 8080) {
                        requiredType = ManagementPortType.SAME;
                    }
                } else if (managementPort != 0) {
                    int serverPort;
                    try {
                        serverPort = Integer.parseInt(serverPortValue);
                    }
                    catch (NumberFormatException e) {
                        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.foundConfigKeyWithValue((String)SERVER_PORT, (String)serverPortValue));
                    }
                    if (managementPort == serverPort) {
                        requiredType = ManagementPortType.SAME;
                    }
                }
            }
        }
        if (actualType == requiredType) {
            return ConditionOutcome.match((String)("Management Port Type '" + String.valueOf((Object)actualType) + "' matched required type"));
        }
        return ConditionOutcome.noMatch((String)("Management Port Type '" + String.valueOf((Object)actualType) + "' did not match required type '" + String.valueOf((Object)requiredType) + "'"));
    }

    private static String findConfigurationValue(ConditionalOnEvaluationContext context, String configKey) {
        Ref configuredValueRef = Ref.create();
        Processor findValue = results -> {
            ConfigurationValueResult item = (ConfigurationValueResult)ContainerUtil.getFirstItem((List)results);
            if (item != null) {
                configuredValueRef.set((Object)item.getValueText());
            }
            return false;
        };
        context.processConfigurationValues(findValue, true, configKey);
        return (String)configuredValueRef.get();
    }

    private static boolean isWebApplication(ConditionalOnEvaluationContext context) {
        ConditionOutcome servletOutcome = ConditionalOnWebApplication.getServletOutcome(context);
        if (servletOutcome.isMatch()) {
            return true;
        }
        ConditionOutcome reactiveOutcome = ConditionalOnWebApplication.getReactiveOutcome(context);
        return reactiveOutcome.isMatch();
    }

    @Nullable
    public ManagementPortType getValue() {
        return (ManagementPortType)VALUE_ATTRIBUTE_META.getJam(this.myAnnotationRef).getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiRef", "com/intellij/spring/boot/model/autoconfigure/conditions/jam/ConditionalOnManagementPort", "<init>"));
    }

    public static enum ManagementPortType {
        DISABLED,
        SAME,
        DIFFERENT;

    }
}

