/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.refactoring.introduceVariable;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.refactoring.introduceVariable.CssExtractVariableDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.index.CssCustomPropertyIndex;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssExtractVariableHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(CssExtractVariableHandler.class);

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(1);
        }
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, DataContext dataContext) {
        if (project == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(4);
        }
        if (!(file instanceof StylesheetFile)) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        CssElement toExtract = CssExtractVariableHandler.getElementToExtract(editor, file);
        if (toExtract == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"cannot.extract.variable.in.this.context", (Object[])new Object[0]), (String)"", null);
            return;
        }
        CssExtractVariableHandler.askAndExtractVariable(editor, (StylesheetFile)file, toExtract);
    }

    @Nullable
    private static CssElement getElementToExtract(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(6);
        }
        PsiElement selectedElement = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement element1 = file.findElementAt(selectionModel.getSelectionStart());
            PsiElement element2 = file.findElementAt(selectionModel.getSelectionEnd());
            if (element1 != null && element2 != null) {
                if (selectionModel.getSelectionEnd() > selectionModel.getSelectionStart() && (element2 instanceof PsiWhiteSpace || element2 instanceof PsiComment || element2 instanceof LeafPsiElement && ((LeafPsiElement)element2).getElementType() == CssElementTypes.CSS_SEMICOLON)) {
                    element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
                }
                if (element2 != null) {
                    selectedElement = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
                }
            }
        } else {
            selectedElement = file.findElementAt(editor.getCaretModel().getOffset());
            if (editor.getCaretModel().getOffset() > 0 && (selectedElement instanceof PsiWhiteSpace || selectedElement instanceof PsiComment || selectedElement instanceof LeafPsiElement && ((LeafPsiElement)selectedElement).getElementType() == CssElementTypes.CSS_SEMICOLON)) {
                selectedElement = file.findElementAt(editor.getCaretModel().getOffset() - 1);
            }
        }
        CssFunction function = (CssFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)selectedElement, (Class[])new Class[]{CssFunction.class});
        if (function != null && "var".equalsIgnoreCase(function.getName())) {
            return null;
        }
        return (CssElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)selectedElement, (Class[])new Class[]{CssTerm.class, CssTermList.class});
    }

    private static void askAndExtractVariable(final @NotNull Editor editor, final @NotNull StylesheetFile file, final @NotNull CssElement toExtract) {
        if (editor == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(8);
        }
        if (toExtract == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(9);
        }
        final String name = CssExtractVariableHandler.getSuggestedName(toExtract);
        final List<PsiElement> occurrences = CssExtractVariableHandler.findOccurrences(toExtract);
        if (editor.getSettings().isVariableInplaceRenameEnabled()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                CssExtractVariableHandler.performExtraction(editor, file, occurrences, name);
            } else {
                OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)toExtract, occurrences, (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                    public void pass(OccurrencesChooser.ReplaceChoice choice) {
                        if (choice != OccurrencesChooser.ReplaceChoice.ALL) {
                            occurrences.clear();
                            occurrences.add(toExtract);
                        }
                        CssExtractVariableHandler.performExtraction(editor, file, occurrences, name);
                    }
                });
            }
        } else {
            editor.getSelectionModel().setSelection(toExtract.getTextRange().getStartOffset(), toExtract.getTextRange().getEndOffset());
            CssExtractVariableDialog dialog = new CssExtractVariableDialog(file.getProject(), (PsiFile)file, name, occurrences.size());
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            if (!dialog.isReplaceAllOccurrences()) {
                occurrences.clear();
                occurrences.add((PsiElement)toExtract);
            }
            CssExtractVariableHandler.performExtraction(editor, file, occurrences, dialog.getName());
        }
    }

    private static void performExtraction(@NotNull Editor editor, @NotNull StylesheetFile file, @NotNull List<PsiElement> occurrences, @NotNull String name) {
        if (editor == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(10);
        }
        if (file == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(11);
        }
        if (occurrences == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(12);
        }
        if (name == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(13);
        }
        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), (String)RefactoringBundle.message((String)"introduce.variable.title"), null, () -> {
            CssBlock block = CssExtractVariableHandler.getOrCreateRootRuleset(file);
            CssDeclaration declaration = block.addDeclaration(name, ((PsiElement)occurrences.getFirst()).getText(), (CssDeclaration)ArrayUtil.getLastElement((Object[])block.getDeclarations()));
            SmartPsiElementPointer declarationPointer = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer((PsiElement)declaration);
            PsiElement nameElement = declaration.getPropertyNameElement();
            String declarationText = declaration.getText();
            LOG.assertTrue(nameElement != null, (Object)declarationText);
            editor.getCaretModel().moveToOffset(nameElement.getTextRange().getEndOffset());
            for (PsiElement occurrence : occurrences) {
                CssTermList varCall = CssElementFactory.getInstance((Project)file.getProject()).createPropertyValue("var(" + name + ")", (Language)CSSLanguage.INSTANCE);
                occurrence.replace((PsiElement)varCall);
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            CssDeclaration restoredDeclaration = (CssDeclaration)declarationPointer.getElement();
            LOG.assertTrue(restoredDeclaration != null, (Object)declarationText);
            if (editor.getSettings().isVariableInplaceRenameEnabled()) {
                CssExtractVariableHandler.runInplaceNameEditing(editor, file, restoredDeclaration);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void runInplaceNameEditing(@NotNull Editor editor, @NotNull StylesheetFile file, final @NotNull CssDeclaration createdDeclaration) {
        if (editor == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(14);
        }
        if (file == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(15);
        }
        if (createdDeclaration == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(16);
        }
        InplaceVariableIntroducer<PsiElement> inplaceRenamer = new InplaceVariableIntroducer<PsiElement>((PsiNamedElement)createdDeclaration, editor, file.getProject(), RefactoringBundle.message((String)"introduce.variable.title"), PsiElement.EMPTY_ARRAY, null){

            @Nullable
            protected PsiElement getNameIdentifier() {
                return createdDeclaration.getPropertyNameElement();
            }

            public String getInitialName() {
                return StringUtil.trimStart((String)createdDeclaration.getPropertyName(), (String)"--");
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiReference reference) {
                TextRange range;
                String text;
                if (reference == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((text = (range = reference.getRangeInElement()).substring(reference.getElement().getText())).startsWith("--")) {
                    TextRange textRange = TextRange.create((int)(range.getStartOffset() + 2), (int)range.getEndOffset());
                    if (textRange == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return textRange;
                }
                TextRange textRange = range;
                if (textRange == null) {
                    2.$$$reportNull$$$0(2);
                }
                return textRange;
            }

            protected PsiElement checkLocalScope() {
                return this.myElementToRename.getContainingFile();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableHandler$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableHandler$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeToRename";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeToRename";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        inplaceRenamer.performInplaceRefactoring(new LinkedHashSet());
    }

    @NotNull
    private static String getSuggestedName(@NotNull CssElement toExtract) {
        CssDeclaration declaration;
        if (toExtract == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(17);
        }
        String name = (declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)toExtract, CssDeclaration.class)) != null ? "--" + StringUtil.trimLeading((String)declaration.getPropertyName(), (char)'-') : "--var";
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)toExtract.getContainingFile());
        Project project = toExtract.getProject();
        String string = UniqueNameGenerator.generateUniqueName((String)name, s -> StubIndex.getElements((StubIndexKey)CssCustomPropertyIndex.KEY, (Object)s, (Project)project, (GlobalSearchScope)scope, CssDeclaration.class).isEmpty());
        if (string == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static CssBlock getOrCreateRootRuleset(@NotNull StylesheetFile file) {
        if (file == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(19);
        }
        CssRulesetList rulesetList = file.getStylesheet().getRulesetList();
        for (CssRuleset ruleset : rulesetList.getRulesets()) {
            for (CssSelector selector : ruleset.getSelectors()) {
                CssBlock block;
                CssSimpleSelector[] simpleSelectors = selector.getSimpleSelectors();
                if (simpleSelectors.length != 1 || !simpleSelectors[0].getText().equals(":root") || (block = ruleset.getBlock()) == null) continue;
                CssBlock cssBlock = block;
                if (cssBlock == null) {
                    CssExtractVariableHandler.$$$reportNull$$$0(20);
                }
                return cssBlock;
            }
        }
        CssRuleset ruleset = CssElementFactory.getInstance((Project)file.getProject()).createRuleset(":root{\n}", (Language)CSSLanguage.INSTANCE);
        CssRuleset addedRuleset = (CssRuleset)rulesetList.addBefore((PsiElement)ruleset, rulesetList.getFirstChild());
        LOG.assertTrue(addedRuleset != null, (Object)ruleset.getText());
        CssBlock block = addedRuleset.getBlock();
        LOG.assertTrue(block != null, (Object)ruleset.getText());
        CssBlock cssBlock = block;
        if (cssBlock == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(21);
        }
        return cssBlock;
    }

    @NotNull
    private static List<PsiElement> findOccurrences(final @NotNull CssElement pattern) {
        if (pattern == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(22);
        }
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        pattern.getContainingFile().accept(new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                ProgressIndicatorProvider.checkCanceled();
                if (element.getClass() == pattern.getClass() && element.getText().equals(pattern.getText())) {
                    result.add(element);
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableHandler$3", "visitElement"));
            }
        });
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            CssExtractVariableHandler.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 20, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExtract";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdDeclaration";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableHandler";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRootRuleset";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToExtract";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "askAndExtractVariable";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performExtraction";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runInplaceNameEditing";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedName";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRootRuleset";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 20, 21, 23 -> new IllegalStateException(string);
        };
    }
}

