/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.backend.impl;

import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.model.Pointer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataMap;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DataSnapshot;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataRule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.NavBarItemProvider;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItemProviderKt;
import com.intellij.platform.navbar.backend.impl.ModuleNavBarItem;
import com.intellij.platform.navbar.backend.impl.ProjectNavBarItem;
import com.intellij.platform.navbar.backend.impl.PsiNavBarItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/navbar/backend/impl/DefaultNavBarItemDataRule;", "Lcom/intellij/openapi/actionSystem/UiDataRule;", "<init>", "()V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "snapshot", "Lcom/intellij/openapi/actionSystem/DataSnapshot;", "getNavBarItem", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataMap;", "fromDataContext", "Lcom/intellij/psi/PsiElement;", "intellij.platform.navbar.backend"})
@SourceDebugExtension(value={"SMAP\nDefaultNavBarItemDataRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultNavBarItemDataRule.kt\ncom/intellij/platform/navbar/backend/impl/DefaultNavBarItemDataRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class DefaultNavBarItemDataRule
implements UiDataRule {
    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull DataSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        sink.lazyValue(NavBarItem.NAVBAR_ITEM_KEY, arg_0 -> DefaultNavBarItemDataRule.uiDataSnapshot$lambda$0(this, arg_0));
    }

    @Nullable
    public final NavBarItem getNavBarItem(@NotNull DataMap dataProvider) {
        Project project;
        PsiElement it;
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Pair pair = (Pair)DefaultNavBarItemProviderKt.fromOldExtensions(arg_0 -> DefaultNavBarItemDataRule.getNavBarItem$lambda$0(dataProvider, arg_0));
        if (pair == null) {
            Pair pair2;
            PsiElement psiElement = this.fromDataContext(dataProvider);
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                pair2 = new Pair((Object)it, null);
            } else {
                pair2 = pair = null;
            }
            if (pair2 == null) {
                return null;
            }
        }
        Pair pair3 = pair;
        PsiElement leaf = (PsiElement)pair3.component1();
        NavBarModelExtension owner = (NavBarModelExtension)pair3.component2();
        if (leaf.isValid()) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)leaf);
            if (virtualFile != null ? Intrinsics.areEqual((Object)virtualFile.getUserData(NavBarModelExtension.IGNORE_IN_NAVBAR), (Object)true) : false) {
                return null;
            }
            return new PsiNavBarItem(leaf, owner);
        }
        DataKey dataKey = PlatformCoreDataKeys.MODULE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"MODULE");
        Module module = (Module)dataProvider.get(dataKey);
        if (module != null) {
            PsiElement it2 = it = module;
            boolean bl = false;
            Object object = project = !ModuleType.isInternal((Module)it2) ? it : null;
            if (project != null) {
                it2 = project;
                boolean bl2 = false;
                return new ModuleNavBarItem((Module)it2);
            }
        }
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        project = (Project)dataProvider.get(dataKey2);
        if (project == null) {
            return null;
        }
        Project p0 = project;
        boolean bl = false;
        ProjectNavBarItem projectItem = new ProjectNavBarItem(p0);
        NavBarItem navBarItem = (NavBarItem)SequencesKt.firstOrNull((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)NavBarItemProvider.EP_NAME.getExtensionList()), arg_0 -> DefaultNavBarItemDataRule.getNavBarItem$lambda$4(projectItem, arg_0)));
        if (navBarItem == null) {
            return projectItem;
        }
        NavBarItem childItem = navBarItem;
        NavBarItem navBarItem2 = (NavBarItem)SequencesKt.firstOrNull((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)NavBarItemProvider.EP_NAME.getExtensionList()), arg_0 -> DefaultNavBarItemDataRule.getNavBarItem$lambda$5(childItem, arg_0)));
        if (navBarItem2 == null) {
            return childItem;
        }
        NavBarItem grandChildItem = navBarItem2;
        return grandChildItem;
    }

    private final PsiElement fromDataContext(DataMap dataProvider) {
        DataKey dataKey = CommonDataKeys.PSI_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_FILE");
        PsiFile psiFile = (PsiFile)dataProvider.get(dataKey);
        if (psiFile != null) {
            DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid((PsiElement)psiFile, "Context PSI_FILE is invalid", psiFile.getClass());
            return DefaultNavBarItemProviderKt.adjustWithAllExtensions((PsiElement)psiFile);
        }
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        Project project = (Project)dataProvider.get(dataKey2);
        DataKey dataKey3 = CommonDataKeys.VIRTUAL_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"VIRTUAL_FILE");
        PsiFileSystemItem fileSystemItem = PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)((VirtualFile)dataProvider.get(dataKey3)));
        if (fileSystemItem != null) {
            DefaultNavBarItemProviderKt.ensurePsiFromExtensionIsValid((PsiElement)fileSystemItem, "Context fileSystemItem is invalid", fileSystemItem.getClass());
            return DefaultNavBarItemProviderKt.adjustWithAllExtensions((PsiElement)fileSystemItem);
        }
        return null;
    }

    private static final Pointer uiDataSnapshot$lambda$0(DefaultNavBarItemDataRule this$0, DataMap dataProvider) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        NavBarItem navBarItem = this$0.getNavBarItem(dataProvider);
        return navBarItem != null ? navBarItem.createPointer() : null;
    }

    private static final Pair getNavBarItem$lambda$0(DataMap $dataProvider, NavBarModelExtension ext) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        PsiElement psiElement = ext.getLeafElement($dataProvider);
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            pair = TuplesKt.to((Object)it, (Object)ext);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Iterable getNavBarItem$lambda$4(ProjectNavBarItem $projectItem, NavBarItemProvider ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        return ext.iterateChildren($projectItem);
    }

    private static final Iterable getNavBarItem$lambda$5(NavBarItem $childItem, NavBarItemProvider ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        return ext.iterateChildren($childItem);
    }
}

