/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.quic.Quiche;
import com.jetbrains.quiche.stubs.QuicheLibrary;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.sun.jna.Pointer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\n\u0010\f\u001a\u00020\r*\u00020\u000eJ\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011J\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0005J\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0007J\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0015J\n\u0010\u0016\u001a\u00020\u0015*\u00020\u0010J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0005J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\r0\r0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010!\u001a\u00020\u0010*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u00070$\u00a2\u0006\u0002\b%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicheCommon;", "", "<init>", "()V", "MAX_SIGNAL_DATAGRAM_SIZE", "", "DEFAULT_BIDI_STREAM_ID", "", "endpointUrlToInetSocketAddress", "Ljava/net/InetSocketAddress;", "uri", "Ljava/net/URI;", "toHexString", "", "", "isNull", "", "Lcom/sun/jna/Pointer;", "toNativeSize", "Lcom/ochafik/lang/jnaerator/runtime/NativeSize;", "toBoolean", "", "toByte", "enableDebugLogging", "", "quicheErrors", "", "kotlin.jvm.PlatformType", "getQuicheErrorName", "value", "assertQuicheError", "errorText", "rc", "isQuicheErrDone", "(J)Z", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nQuicheCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuicheCommon.kt\ncom/intellij/platform/split/connection/network/quic/QuicheCommon\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n60#2,5:75\n3938#3:80\n4474#3,2:81\n1586#4:83\n1661#4,3:84\n*S KotlinDebug\n*F\n+ 1 QuicheCommon.kt\ncom/intellij/platform/split/connection/network/quic/QuicheCommon\n*L\n43#1:75,5\n48#1:80\n48#1:81,2\n49#1:83\n49#1:84,3\n*E\n"})
public final class QuicheCommon {
    @NotNull
    public static final QuicheCommon INSTANCE;
    public static final int MAX_SIGNAL_DATAGRAM_SIZE = 1600;
    public static final long DEFAULT_BIDI_STREAM_ID = 4L;
    @NotNull
    private static final Map<Integer, String> quicheErrors;
    @NotNull
    private static final Logger LOG;

    private QuicheCommon() {
    }

    @NotNull
    public final InetSocketAddress endpointUrlToInetSocketAddress(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"quic")) {
            boolean $i$a$-require-QuicheCommon$endpointUrlToInetSocketAddress$32 = false;
            String $i$a$-require-QuicheCommon$endpointUrlToInetSocketAddress$32 = "Required 'quic' URI scheme: " + uri;
            throw new IllegalArgumentException($i$a$-require-QuicheCommon$endpointUrlToInetSocketAddress$32.toString());
        }
        if (!(uri.getPort() > 0)) {
            boolean bl = false;
            String string = "Port must be specified for 'quic' URI scheme: " + uri;
            throw new IllegalArgumentException(string.toString());
        }
        InetAddress inetAddress = InetAddresses.forString((String)uri.getHost());
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"forString(...)");
        InetAddress inetAddress2 = inetAddress;
        return new InetSocketAddress(inetAddress2, uri.getPort());
    }

    @NotNull
    public final String toHexString(@NotNull byte[] $this$toHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)"", null, null, (int)0, null, QuicheCommon::toHexString$lambda$0, (int)30, null);
    }

    public final boolean isNull(@NotNull Pointer $this$isNull) {
        Intrinsics.checkNotNullParameter((Object)$this$isNull, (String)"<this>");
        return Pointer.nativeValue((Pointer)$this$isNull) == 0L;
    }

    @NotNull
    public final NativeSize toNativeSize(int $this$toNativeSize) {
        return this.toNativeSize((long)$this$toNativeSize);
    }

    @NotNull
    public final NativeSize toNativeSize(long $this$toNativeSize) {
        return new NativeSize($this$toNativeSize);
    }

    public final boolean toBoolean(byte $this$toBoolean) {
        return $this$toBoolean != 0;
    }

    public final byte toByte(boolean $this$toByte) {
        return $this$toByte ? (byte)1 : 0;
    }

    public final void enableDebugLogging() {
        Quiche.INSTANCE.getLibrary().quiche_enable_debug_logging(QuicheCommon::enableDebugLogging$lambda$0, Pointer.NULL);
    }

    @NotNull
    public final String getQuicheErrorName(int value) {
        Object object = quicheErrors.get(value);
        if (object == null) {
            object = "QUICHE_ERR_UNKNOWN (" + value + ")";
        }
        return object;
    }

    public final void assertQuicheError(@NotNull String errorText, int rc) {
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        if (rc < 0) {
            throw new IllegalStateException("Quic Error. Name: " + this.getQuicheErrorName(rc) + ". Message: " + errorText);
        }
    }

    public final void assertQuicheError(@NotNull String errorText, long rc) {
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        if (rc > Integer.MAX_VALUE || rc < Integer.MIN_VALUE) {
            return;
        }
        this.assertQuicheError(errorText, (int)rc);
    }

    public final boolean isQuicheErrDone(long $this$isQuicheErrDone) {
        return $this$isQuicheErrDone == -1L;
    }

    private static final CharSequence toHexString$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final void enableDebugLogging$lambda$0(Pointer line, Pointer pointer) {
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            String string = line.getString(0L);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            logger.debug(string, t$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        String string;
        Map map;
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        INSTANCE = new QuicheCommon();
        Field[] fieldArray = QuicheLibrary.quiche_error.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] $this$filter$iv = fieldArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Field element$iv$iv : $this$filterTo$iv$iv) {
            Field it = element$iv$iv;
            boolean bl = false;
            if (!Modifier.isStatic(it.getModifiers())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Field element$iv$iv;
            element$iv$iv = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getInt(null), (Object)it.getName()));
        }
        Map it = map = MapsKt.toMap((Iterable)((List)((Object)string)));
        boolean bl = false;
        if (!Intrinsics.areEqual(it.get(-1), (Object)"QUICHE_ERR_DONE")) {
            string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual(it.get(-5), (Object)"QUICHE_ERR_INVALID_PACKET")) {
            string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual(it.get(-14), (Object)"QUICHE_ERR_CONGESTION_CONTROL")) {
            string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        quicheErrors = map;
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

