/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.platform.split.connection.network.quic.SockAddrI;
import com.intellij.util.system.OS;
import com.jetbrains.quiche.stubs.QuicheLibrary;
import com.sun.jna.Structure;
import java.net.Inet4Address;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/split/connection/network/quic/QuicheSockAddrIn;", "Lcom/sun/jna/Structure;", "Lcom/intellij/platform/split/connection/network/quic/SockAddrI;", "address", "Ljava/net/Inet4Address;", "port", "", "<init>", "(Ljava/net/Inet4Address;I)V", "getFieldOrder", "", "", "sin_family", "", "sin_port", "sin_addr", "sin_pad", "", "quicheSockAddr", "Lcom/jetbrains/quiche/stubs/QuicheLibrary$sockaddr;", "getQuicheSockAddr", "()Lcom/jetbrains/quiche/stubs/QuicheLibrary$sockaddr;", "intellij.platform.split.connection"})
public final class QuicheSockAddrIn
extends Structure
implements SockAddrI {
    @JvmField
    public short sin_family;
    @JvmField
    public short sin_port;
    @JvmField
    public int sin_addr;
    @JvmField
    public final long sin_pad;

    public QuicheSockAddrIn(@NotNull Inet4Address address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.sin_family = (short)(OS.CURRENT == OS.macOS || OS.CURRENT == OS.FreeBSD ? 528 : 2);
        this.sin_port = (short)port;
        this.sin_addr = ByteBuffer.wrap(address.getAddress()).getInt();
        if (!Intrinsics.areEqual((Object)ByteOrder.nativeOrder(), (Object)ByteOrder.LITTLE_ENDIAN)) {
            boolean bl = false;
            String string = "Only little endian byte order is supported, current order is: " + ByteOrder.nativeOrder();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    protected List<String> getFieldOrder() {
        Object[] objectArray = new String[]{"sin_family", "sin_port", "sin_addr", "sin_pad"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public QuicheLibrary.sockaddr getQuicheSockAddr() {
        this.write();
        return new QuicheLibrary.sockaddr(this.getPointer());
    }
}

