/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.turn.data;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\n\u0010#\u001a\u00020\u0007H\u0096\u0080\u0004J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\t\u0010(\u001a\u00020\nH\u00c6\u0003J\t\u0010)\u001a\u00020\nH\u00c6\u0003JE\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0014\u0010+\u001a\u00020\"2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010-\u001a\u00020 H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lcom/intellij/platform/split/connection/network/turn/data/AllocationInfo;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "allocationLifetimeSeconds", "Ljava/util/concurrent/atomic/AtomicInteger;", "username", "", "password", "relayedAddress", "Ljava/net/InetSocketAddress;", "mappedAddress", "<init>", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Ljava/util/concurrent/atomic/AtomicInteger;Ljava/lang/String;Ljava/lang/String;Ljava/net/InetSocketAddress;Ljava/net/InetSocketAddress;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getAllocationLifetimeSeconds", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getUsername", "()Ljava/lang/String;", "getPassword", "getRelayedAddress", "()Ljava/net/InetSocketAddress;", "getMappedAddress", "allocationExpiration", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/Instant;", "getAllocationExpiration", "()Ljava/util/concurrent/atomic/AtomicReference;", "updateAllocationLifetimeFromNow", "", "lifetimeSeconds", "", "isRefreshRequired", "", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nAllocationInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllocationInfo.kt\ncom/intellij/platform/split/connection/network/turn/data/AllocationInfo\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,74:1\n60#2,5:75\n60#2,5:80\n60#2,5:85\n13#2:91\n13#3:90\n*S KotlinDebug\n*F\n+ 1 AllocationInfo.kt\ncom/intellij/platform/split/connection/network/turn/data/AllocationInfo\n*L\n57#1:75,5\n59#1:80,5\n66#1:85,5\n25#1:91\n25#1:90\n*E\n"})
public final class AllocationInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LifetimeDefinition lifetime;
    @NotNull
    private final AtomicInteger allocationLifetimeSeconds;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @NotNull
    private final InetSocketAddress relayedAddress;
    @NotNull
    private final InetSocketAddress mappedAddress;
    @NotNull
    private final AtomicReference<Instant> allocationExpiration;
    @NotNull
    private static final Logger logger;
    private static final DateTimeFormatter dateFormatter;

    public AllocationInfo(@NotNull LifetimeDefinition lifetime, @NotNull AtomicInteger allocationLifetimeSeconds, @NotNull String username, @NotNull String password, @NotNull InetSocketAddress relayedAddress, @NotNull InetSocketAddress mappedAddress) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)allocationLifetimeSeconds, (String)"allocationLifetimeSeconds");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)relayedAddress, (String)"relayedAddress");
        Intrinsics.checkNotNullParameter((Object)mappedAddress, (String)"mappedAddress");
        this.lifetime = lifetime;
        this.allocationLifetimeSeconds = allocationLifetimeSeconds;
        this.username = username;
        this.password = password;
        this.relayedAddress = relayedAddress;
        this.mappedAddress = mappedAddress;
        this.allocationExpiration = new AtomicReference<Instant>(Instant.now());
        this.updateAllocationLifetimeFromNow(this.allocationLifetimeSeconds.get());
    }

    @NotNull
    public final LifetimeDefinition getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final AtomicInteger getAllocationLifetimeSeconds() {
        return this.allocationLifetimeSeconds;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @NotNull
    public final InetSocketAddress getRelayedAddress() {
        return this.relayedAddress;
    }

    @NotNull
    public final InetSocketAddress getMappedAddress() {
        return this.mappedAddress;
    }

    @NotNull
    public final AtomicReference<Instant> getAllocationExpiration() {
        return this.allocationExpiration;
    }

    public final void updateAllocationLifetimeFromNow(int lifetimeSeconds) {
        this.allocationLifetimeSeconds.set(lifetimeSeconds);
        long lifetimeEpochSeconds = Instant.now().getEpochSecond() + (long)lifetimeSeconds;
        this.allocationExpiration.set(Instant.ofEpochSecond(lifetimeEpochSeconds));
        Instant allocationExceptionValue = this.allocationExpiration.get();
        logger.info("Updated allocation lifetime to '" + dateFormatter.format(allocationExceptionValue) + "' (+" + lifetimeSeconds + " sec, epoch: " + allocationExceptionValue.getEpochSecond() + " sec)");
    }

    public final boolean isRefreshRequired() {
        Logger logger;
        Logger $this$debug_u24default$iv = AllocationInfo.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("TURN Allocation Check is refresh required", t$iv);
        }
        if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)this.lifetime))) {
            $this$debug_u24default$iv = AllocationInfo.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("TURN Allocation lifetime is not alive. Refresh is not required.", t$iv);
            }
            return false;
        }
        long nowEpochSeconds = Instant.now().getEpochSecond();
        boolean isRefreshRequired = nowEpochSeconds >= this.allocationExpiration.get().getEpochSecond() - Duration.ofMinutes(2L).toSeconds();
        Logger $this$debug_u24default$iv2 = AllocationInfo.logger;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("TURN Allocation is refresh required: " + isRefreshRequired, t$iv2);
        }
        return isRefreshRequired;
    }

    @NotNull
    public String toString() {
        return "TURN Allocation info. Related address: " + this.relayedAddress + ", Mapped address: " + this.mappedAddress + ", Lifetime: " + this.allocationLifetimeSeconds + " sec, Expiration: " + dateFormatter.format(this.allocationExpiration.get());
    }

    @NotNull
    public final LifetimeDefinition component1() {
        return this.lifetime;
    }

    @NotNull
    public final AtomicInteger component2() {
        return this.allocationLifetimeSeconds;
    }

    @NotNull
    public final String component3() {
        return this.username;
    }

    @NotNull
    public final String component4() {
        return this.password;
    }

    @NotNull
    public final InetSocketAddress component5() {
        return this.relayedAddress;
    }

    @NotNull
    public final InetSocketAddress component6() {
        return this.mappedAddress;
    }

    @NotNull
    public final AllocationInfo copy(@NotNull LifetimeDefinition lifetime, @NotNull AtomicInteger allocationLifetimeSeconds, @NotNull String username, @NotNull String password, @NotNull InetSocketAddress relayedAddress, @NotNull InetSocketAddress mappedAddress) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)allocationLifetimeSeconds, (String)"allocationLifetimeSeconds");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)relayedAddress, (String)"relayedAddress");
        Intrinsics.checkNotNullParameter((Object)mappedAddress, (String)"mappedAddress");
        return new AllocationInfo(lifetime, allocationLifetimeSeconds, username, password, relayedAddress, mappedAddress);
    }

    public static /* synthetic */ AllocationInfo copy$default(AllocationInfo allocationInfo, LifetimeDefinition lifetimeDefinition, AtomicInteger atomicInteger, String string, String string2, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n, Object object) {
        if ((n & 1) != 0) {
            lifetimeDefinition = allocationInfo.lifetime;
        }
        if ((n & 2) != 0) {
            atomicInteger = allocationInfo.allocationLifetimeSeconds;
        }
        if ((n & 4) != 0) {
            string = allocationInfo.username;
        }
        if ((n & 8) != 0) {
            string2 = allocationInfo.password;
        }
        if ((n & 0x10) != 0) {
            inetSocketAddress = allocationInfo.relayedAddress;
        }
        if ((n & 0x20) != 0) {
            inetSocketAddress2 = allocationInfo.mappedAddress;
        }
        return allocationInfo.copy(lifetimeDefinition, atomicInteger, string, string2, inetSocketAddress, inetSocketAddress2);
    }

    public int hashCode() {
        int result = this.lifetime.hashCode();
        result = result * 31 + this.allocationLifetimeSeconds.hashCode();
        result = result * 31 + this.username.hashCode();
        result = result * 31 + this.password.hashCode();
        result = result * 31 + this.relayedAddress.hashCode();
        result = result * 31 + this.mappedAddress.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AllocationInfo)) {
            return false;
        }
        AllocationInfo allocationInfo = (AllocationInfo)other;
        if (!Intrinsics.areEqual((Object)this.lifetime, (Object)allocationInfo.lifetime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.allocationLifetimeSeconds, (Object)allocationInfo.allocationLifetimeSeconds)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.username, (Object)allocationInfo.username)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)allocationInfo.password)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relayedAddress, (Object)allocationInfo.relayedAddress)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mappedAddress, (Object)allocationInfo.mappedAddress);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AllocationInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AllocationInfo.logger = logger;
        dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.systemDefault());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/split/connection/network/turn/data/AllocationInfo$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

