/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.core.filter;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.liquibase.core.SearchHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/liquibase/core/filter/LiquibaseChangeSetFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myPart", "", "myPattern", "Ljava/util/regex/Pattern;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "createOpenFileHyperlink", "Lcom/intellij/execution/filters/HyperlinkInfo;", "filePath", "changeSetId", "getChangeSetOffset", "foundFile", "Lcom/intellij/psi/xml/XmlFile;", "intellij.liquibase.core"})
@SourceDebugExtension(value={"SMAP\nLiquibaseChangeSetFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseChangeSetFilter.kt\ncom/intellij/liquibase/core/filter/LiquibaseChangeSetFilter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n13#2:70\n1#3:71\n*S KotlinDebug\n*F\n+ 1 LiquibaseChangeSetFilter.kt\ncom/intellij/liquibase/core/filter/LiquibaseChangeSetFilter\n*L\n32#1:70\n*E\n"})
public final class LiquibaseChangeSetFilter
implements Filter {
    @NotNull
    private final Project project;
    @NotNull
    private final String myPart;
    @NotNull
    private final Pattern myPattern;

    public LiquibaseChangeSetFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myPart = ".xml::";
        Pattern pattern = Pattern.compile("((?:[\\S]+?)\\.xml)::(.+?)::", 8);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.myPattern = pattern;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)this.myPart, (boolean)false, (int)2, null)) {
            return null;
        }
        Matcher matcher = this.myPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
        try {
            if (!matcher.find()) {
                return null;
            }
        }
        catch (ProcessCanceledException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LiquibaseChangeSetFilter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Too long matching '" + line + "' by '" + this.myPattern + "' in " + this.getClass().getName());
            throw e;
        }
        String string = matcher.group(1);
        if (string == null) {
            return null;
        }
        String filePath = string;
        String string2 = matcher.group(2);
        if (string2 == null) {
            return null;
        }
        String changeSetId = string2;
        int startLineIdx = entireLength - line.length();
        int highlightStartOffset = startLineIdx + matcher.start(1);
        int highlightEndOffset = startLineIdx + matcher.end(2);
        HyperlinkInfo hyperlinkInfo = this.createOpenFileHyperlink(StringsKt.replace$default((String)filePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), changeSetId);
        if (hyperlinkInfo == null) {
            return null;
        }
        HyperlinkInfo info = hyperlinkInfo;
        return new Filter.Result(highlightStartOffset, highlightEndOffset, info);
    }

    private final HyperlinkInfo createOpenFileHyperlink(String filePath, String changeSetId) {
        return (HyperlinkInfo)new FileHyperlinkInfo(this, filePath, changeSetId){
            final /* synthetic */ LiquibaseChangeSetFilter this$0;
            final /* synthetic */ String $filePath;
            final /* synthetic */ String $changeSetId;
            {
                this.this$0 = $receiver;
                this.$filePath = $filePath;
                this.$changeSetId = $changeSetId;
            }

            public void navigate(Project project) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    OpenFileDescriptor openFileDescriptor = this.getDescriptor();
                    if (openFileDescriptor == null) break block0;
                    openFileDescriptor.navigate(true);
                }
            }

            public OpenFileDescriptor getDescriptor() {
                SearchHelper searchHelper = SearchHelper.getInstance(this.this$0.getProject());
                XmlFile xmlFile = searchHelper.findFile(this.$filePath, XmlFile.class, GlobalSearchScope.projectScope((Project)this.this$0.getProject()));
                if (xmlFile == null) {
                    return null;
                }
                XmlFile foundFile = xmlFile;
                return new OpenFileDescriptor(this.this$0.getProject(), foundFile.getVirtualFile(), LiquibaseChangeSetFilter.access$getChangeSetOffset(this.this$0, foundFile, this.$changeSetId));
            }
        };
    }

    private final int getChangeSetOffset(XmlFile foundFile, String changeSetId) {
        Object object;
        block3: {
            XmlTag xmlTag = foundFile.getRootTag();
            if (xmlTag == null) {
                return 0;
            }
            XmlTag rootTag = xmlTag;
            XmlTag[] xmlTagArray = rootTag.findSubTags("changeSet");
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"findSubTags(...)");
            for (Object object2 : (Object[])xmlTagArray) {
                XmlTag changeSetTag = (XmlTag)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)changeSetTag.getAttributeValue("id"), (Object)changeSetId)) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        XmlTag xmlTag = (XmlTag)object;
        if (xmlTag == null) {
            return 0;
        }
        XmlTag changeSetTag = xmlTag;
        return PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)changeSetTag));
    }

    public static final /* synthetic */ int access$getChangeSetOffset(LiquibaseChangeSetFilter $this, XmlFile foundFile, String changeSetId) {
        return $this.getChangeSetOffset(foundFile, changeSetId);
    }
}

