/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.core.inspection;

import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.liquibase.core.LiquibaseFileType;
import com.intellij.liquibase.core.LiquibaseUtilKt;
import com.intellij.liquibase.core.dom.DatabaseChangeLog;
import com.intellij.liquibase.core.extension.LiquibaseFrameworkContextProvider;
import com.intellij.liquibase.core.inspection.CreateEmptyChangelogQuickFix;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReferenceHelper;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/core/inspection/ChangelogFileReferenceProvider;", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper;", "<init>", "()V", "isMine", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "registerFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "reference", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "getQuickFixes", "", "intellij.liquibase.core"})
@SourceDebugExtension(value={"SMAP\nChangelogFileReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangelogFileReferenceProvider.kt\ncom/intellij/liquibase/core/inspection/ChangelogFileReferenceProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,58:1\n20240#2,2:59\n*S KotlinDebug\n*F\n+ 1 ChangelogFileReferenceProvider.kt\ncom/intellij/liquibase/core/inspection/ChangelogFileReferenceProvider\n*L\n38#1:59,2\n*E\n"})
public final class ChangelogFileReferenceProvider
extends PsiFileReferenceHelper {
    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile = LiquibaseUtilKt.toPsiFile(file, project);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return false;
        }
        XmlFile xmlFile2 = xmlFile;
        DomFileDescription descr = DomManager.getDomManager((Project)project).getDomFileDescription(xmlFile2);
        return !DumbService.Companion.isDumb(project) && super.isMine(project, file) && descr instanceof DatabaseChangeLog;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(@NotNull FileReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return CollectionsKt.toMutableList((Collection)this.getQuickFixes(reference));
    }

    private final List<LocalQuickFix> getQuickFixes(FileReference reference) {
        boolean bl;
        String newFileName;
        block7: {
            if (!reference.isLast()) {
                return CollectionsKt.emptyList();
            }
            int index = reference.getIndex();
            if (index < 0) {
                return CollectionsKt.emptyList();
            }
            String string = reference.getFileNameToCreate();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileNameToCreate(...)");
            newFileName = string;
            String fileExtension = PathUtil.getFileExtension((String)newFileName);
            String[] $this$none$iv = LiquibaseFileType.XML.getFileExtensions();
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$none$iv[i];
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)fileExtension)) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (bl) {
            return CollectionsKt.emptyList();
        }
        if (((CharSequence)newFileName).length() == 0 || StringsKt.contains$default((CharSequence)newFileName, (char)'\\', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)newFileName, (char)'*', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)newFileName, (char)'?', (boolean)false, (int)2, null) || SystemInfo.isWindows && StringsKt.contains$default((CharSequence)newFileName, (char)':', (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        NewFileLocation newFileLocation = FileReferenceQuickFixProvider.getNewFileLocation((FileReference)reference, (String)newFileName, (boolean)false);
        if (newFileLocation == null) {
            return CollectionsKt.emptyList();
        }
        NewFileLocation location = newFileLocation;
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement element = psiElement;
        List result = new ArrayList();
        result.add(new CreateEmptyChangelogQuickFix(element, location));
        for (LiquibaseFrameworkContextProvider provider : LiquibaseFrameworkContextProvider.Companion.getEP_NAME().getExtensionList()) {
            result.addAll((Collection)provider.createChangelogQuickFixes(element, location));
        }
        return result;
    }
}

