/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency;

import java.io.IOException;
import java.util.Comparator;
import java.util.function.Function;
import org.jetbrains.jps.dependency.DataReader;
import org.jetbrains.jps.dependency.ExternalizableGraphElement;
import org.jetbrains.jps.dependency.Externalizer;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;

public interface ComparableTypeExternalizer<T>
extends Externalizer<T>,
Comparator<T> {
    public T[] createStorage(int var1);

    public static <T extends ExternalizableGraphElement> ComparableTypeExternalizer<T> forGraphElement(final DataReader<? extends T> reader, final Function<Integer, T[]> arrayFactory, final Comparator<T> comparator) {
        return new ComparableTypeExternalizer<T>(){

            @Override
            public int compare(T o1, T o2) {
                return comparator.compare(o1, o2);
            }

            @Override
            public T[] createStorage(int size) {
                return (ExternalizableGraphElement[])arrayFactory.apply(size);
            }

            @Override
            public T load(GraphDataInput in) throws IOException {
                return (ExternalizableGraphElement)reader.load(in);
            }

            @Override
            public void save(GraphDataOutput out, T value) throws IOException {
                value.write(out);
            }
        };
    }

    public static <T extends ExternalizableGraphElement> ComparableTypeExternalizer<T> forAnyGraphElement(final Function<Integer, T[]> arrayFactory, final Comparator<? super T> comparator) {
        return new ComparableTypeExternalizer<T>(){

            @Override
            public int compare(T o1, T o2) {
                return comparator.compare(o1, o2);
            }

            @Override
            public T[] createStorage(int size) {
                return (ExternalizableGraphElement[])arrayFactory.apply(size);
            }

            @Override
            public T load(GraphDataInput in) throws IOException {
                return in.readGraphElement();
            }

            @Override
            public void save(GraphDataOutput out, T value) throws IOException {
                out.writeGraphElement(value);
            }
        };
    }
}

