/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.core.toolbox;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.station.core.toolbox.ToolboxDiscovery;
import com.intellij.station.core.toolbox.ToolboxStatus;
import com.intellij.station.core.toolbox.ToolboxStatusService;
import com.intellij.station.core.toolbox.ToolboxStatusServiceKt;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0010J\u0006\u0010\u001a\u001a\u00020\u0010J\u0006\u0010\u001b\u001a\u00020\u0016J\u000e\u0010\u001c\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/intellij/station/core/toolbox/ToolboxStatusService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "_toolboxStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/station/core/toolbox/ToolboxStatus;", "toolboxStatus", "Lkotlinx/coroutines/flow/StateFlow;", "getToolboxStatus", "()Lkotlinx/coroutines/flow/StateFlow;", "_toolboxInstalling", "", "get_toolboxInstalling$intellij_station_core", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "toolboxInstalling", "getToolboxInstalling", "rememberAboutInstallationAttempt", "", "rememberToolboxPromoPlaceholderDismissed", "forgetAboutInstallationAttempt", "wasToolboxOpenedViaLink", "wasToolboxPromoPlaceholderDismissed", "scheduleUpdateToolboxStatus", "updateToolboxStatusSafe", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateToolboxStatusUnsafe", "Companion", "intellij.station.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nToolboxStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxStatusService.kt\ncom/intellij/station/core/toolbox/ToolboxStatusService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class ToolboxStatusService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<ToolboxStatus> _toolboxStatus;
    @NotNull
    private final StateFlow<ToolboxStatus> toolboxStatus;
    @NotNull
    private final MutableStateFlow<Boolean> _toolboxInstalling;
    @NotNull
    private final StateFlow<Boolean> toolboxInstalling;

    public ToolboxStatusService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this._toolboxStatus = StateFlowKt.MutableStateFlow((Object)ToolboxStatus.NotYetComputed.INSTANCE);
        this.toolboxStatus = (StateFlow)this._toolboxStatus;
        this._toolboxInstalling = StateFlowKt.MutableStateFlow((Object)false);
        this.toolboxInstalling = (StateFlow)this._toolboxInstalling;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public final StateFlow<ToolboxStatus> getToolboxStatus() {
        return this.toolboxStatus;
    }

    @NotNull
    public final MutableStateFlow<Boolean> get_toolboxInstalling$intellij_station_core() {
        return this._toolboxInstalling;
    }

    @NotNull
    public final StateFlow<Boolean> getToolboxInstalling() {
        return this.toolboxInstalling;
    }

    public final void rememberAboutInstallationAttempt() {
        PropertiesComponent.getInstance().setValue("toolbox.installation.attempt", true);
    }

    public final void rememberToolboxPromoPlaceholderDismissed() {
        PropertiesComponent.getInstance().setValue("toolbox.promo.placeholder.dismissed", true);
    }

    public final void forgetAboutInstallationAttempt() {
        PropertiesComponent.getInstance().setValue("toolbox.installation.attempt", false);
        PropertiesComponent.getInstance().setValue("toolbox.promo.placeholder.dismissed", false);
    }

    public final boolean wasToolboxOpenedViaLink() {
        boolean registryKeyEnabled = Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled", false);
        boolean userHadClickedOnOpenToolboxLink = PropertiesComponent.getInstance().getBoolean("toolbox.installation.attempt", false);
        ToolboxStatus $this$wasToolboxOpenedViaLink_u24lambda_u240 = (ToolboxStatus)this.toolboxStatus.getValue();
        boolean bl = false;
        boolean isUpToDateToolboxInstallationConfirmed = $this$wasToolboxOpenedViaLink_u24lambda_u240 instanceof ToolboxStatus.Installed && ((ToolboxStatus.Installed)$this$wasToolboxOpenedViaLink_u24lambda_u240).isUpToDate();
        ToolboxStatusServiceKt.access$getLOG().debug("Previous toolbox opening data: registry key enabled: " + registryKeyEnabled + ", user had clicked on 'open' link: " + userHadClickedOnOpenToolboxLink + ", is up to date toolbox installed: " + isUpToDateToolboxInstallationConfirmed);
        return registryKeyEnabled && userHadClickedOnOpenToolboxLink && isUpToDateToolboxInstallationConfirmed;
    }

    public final boolean wasToolboxPromoPlaceholderDismissed() {
        return PropertiesComponent.getInstance().getBoolean("toolbox.promo.placeholder.dismissed", false);
    }

    public final void scheduleUpdateToolboxStatus() {
        if (!PlatformUtils.isCommercialEdition()) {
            return;
        }
        if (!(Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled", false) || Registry.Companion.is("gateway.welcome.screen.toolbox.promo.enabled", false) || Registry.Companion.is("station.enable.welcome.screen.promo", false))) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ToolboxStatusService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.updateToolboxStatusSafe((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateToolboxStatusSafe(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateToolboxStatusSafe.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxStatusService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateToolboxStatusSafe((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.updateToolboxStatusUnsafe((Continuation<? super Unit>)$continuation);
                ** if (v0 != var5_4) goto lbl18
lbl17:
                // 1 sources

                return var5_4;
lbl18:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (IllegalArgumentException exception) {
                    ToolboxStatusServiceKt.access$getLOG().warn("Failed to update toolbox status. Unsatisfied requirement: ", (Throwable)exception);
                    this._toolboxStatus.setValue((Object)ToolboxStatus.Unsupported.INSTANCE);
                }
lbl28:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateToolboxStatusUnsafe(Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateToolboxStatusUnsafe.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxStatusService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolboxStatusService.access$updateToolboxStatusUnsafe(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                installedToolboxBuildNumber = ToolboxDiscovery.INSTANCE.getInstalledBuild$intellij_station_core();
                runningToolboxProcesses = ToolboxDiscovery.INSTANCE.listRunningToolboxProcesses();
                $continuation.L$0 = installedToolboxBuildNumber;
                $continuation.L$1 = runningToolboxProcesses;
                $continuation.label = 1;
                v0 = ToolboxDiscovery.INSTANCE.findOrDownloadFreshToolboxInstaller(false, (Continuation<? super Pair<? extends Path, BuildNumber>>)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                runningToolboxProcesses = (List<ProcessInfo>)$continuation.L$1;
                installedToolboxBuildNumber = (BuildNumber)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                installerVersion = (BuildNumber)((Pair)v0).component2();
                ToolboxStatusServiceKt.access$getLOG().debug("Toolbox discovery status: existing toolbox build " + installedToolboxBuildNumber + ", running processes " + runningToolboxProcesses.size() + ",installer version " + installerVersion);
                if (installedToolboxBuildNumber != null) {
                    isUpToDate = installedToolboxBuildNumber.compareTo(installerVersion) >= 0;
                    isRunning = ((Collection)runningToolboxProcesses).isEmpty() == false;
                    ToolboxStatusServiceKt.access$getLOG().debug("Toolbox is installed: up to date: " + (isUpToDate != false) + ", is running: " + (isRunning != false));
                    v1 = new ToolboxStatus.Installed(installedToolboxBuildNumber, isUpToDate != false, isRunning != false);
                } else {
                    if (((Collection)runningToolboxProcesses).isEmpty() == false) {
                        ToolboxStatusServiceKt.access$getLOG().debug("Toolbox discovery is unsure about installed version. Falling back to `not installed`");
                    }
                    v1 = ToolboxStatus.NotInstalled.INSTANCE;
                }
                this._toolboxStatus.setValue((Object)v1);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$updateToolboxStatusUnsafe(ToolboxStatusService $this, Continuation $completion) {
        return $this.updateToolboxStatusUnsafe((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/station/core/toolbox/ToolboxStatusService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/station/core/toolbox/ToolboxStatusService;", "intellij.station.core"})
    @SourceDebugExtension(value={"SMAP\nToolboxStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxStatusService.kt\ncom/intellij/station/core/toolbox/ToolboxStatusService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,124:1\n42#2,3:125\n*S KotlinDebug\n*F\n+ 1 ToolboxStatusService.kt\ncom/intellij/station/core/toolbox/ToolboxStatusService$Companion\n*L\n112#1:125,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolboxStatusService getInstance() {
            boolean $i$f$service = false;
            Class<ToolboxStatusService> serviceClass$iv = ToolboxStatusService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ToolboxStatusService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

