/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class SpringBootAdditionalConfigUtils {
    private static boolean USE_CONTENT_ROOTS_FOR_TESTS = false;
    private final Module myModule;
    private final List<VirtualFile> myResourceRoots;
    private static boolean OVERRIDE = false;

    @TestOnly
    public static void setUseContentRootsForTests(boolean useContentRootsForTests) {
        USE_CONTENT_ROOTS_FOR_TESTS = useContentRootsForTests;
    }

    public SpringBootAdditionalConfigUtils(Module module) {
        this.myModule = module;
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        JavaSourceRootType sourceRootType = testMode ? JavaSourceRootType.SOURCE : JavaResourceRootType.RESOURCE;
        this.myResourceRoots = !USE_CONTENT_ROOTS_FOR_TESTS ? ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)sourceRootType) : Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    public boolean hasResourceRoots() {
        return !this.myResourceRoots.isEmpty();
    }

    public List<VirtualFile> getResourceRoots() {
        return this.myResourceRoots;
    }

    public boolean processAllAdditionalMetadataFiles(Processor<? super PsiFile> processor) {
        for (VirtualFile root : this.myResourceRoots) {
            PsiFile psiFile;
            VirtualFile vf = root.findFileByRelativePath("META-INF/additional-spring-configuration-metadata.json");
            if (vf == null || processor.process((Object)(psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(vf)))) continue;
            return false;
        }
        return true;
    }

    public boolean processAdditionalMetadataFiles(Processor<? super PsiFile> processor) {
        return this.processAllAdditionalMetadataFiles((Processor<? super PsiFile>)((Processor)psiFile -> !SpringBootAdditionalConfigUtils.isJsonFile(psiFile) || processor.process(psiFile)));
    }

    @TestOnly
    public static void setOverrideDetection(boolean value) {
        OVERRIDE = value;
    }

    public static boolean isAdditionalMetadataFile(PsiFile psiFile) {
        if (OVERRIDE) {
            return true;
        }
        return SpringBootAdditionalConfigUtils.isJsonFile(psiFile) && psiFile.getName().equals("additional-spring-configuration-metadata.json");
    }

    public static boolean isJsonFile(@NotNull PsiFile file) {
        if (file == null) {
            SpringBootAdditionalConfigUtils.$$$reportNull$$$0(0);
        }
        return "JSON".equals(file.getLanguage().getID());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigUtils", "isJsonFile"));
    }
}

