/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.control.icons.newUi;

import com.intellij.cwm.plugin.common.control.icons.newUi.ColoredIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001b\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H&R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/cwm/plugin/common/control/icons/newUi/AbstractLineIcon;", "Lcom/intellij/cwm/plugin/common/control/icons/newUi/ColoredIcon;", "color", "Ljava/awt/Color;", "unscaledWidth", "", "<init>", "(Ljava/awt/Color;I)V", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "padding", "", "getIconWidth", "getIconHeight", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "getStroke", "Ljava/awt/BasicStroke;", "intellij.cwm.plugin.common"})
public abstract class AbstractLineIcon
implements ColoredIcon {
    @Nullable
    private Color color;
    private final int unscaledWidth;
    private final float padding;

    protected AbstractLineIcon(@Nullable Color color, int unscaledWidth) {
        this.color = color;
        this.unscaledWidth = unscaledWidth;
        this.padding = JBUIScale.scale((float)4.0f);
    }

    @Override
    @Nullable
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(@Nullable Color color) {
        this.color = color;
    }

    @Override
    public int getIconWidth() {
        return JBUI.scale((int)this.unscaledWidth);
    }

    @Override
    public int getIconHeight() {
        return JBUI.scale((int)this.unscaledWidth);
    }

    @Override
    public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float myX = (float)x - this.padding;
        float myY = (float)y - this.padding;
        float myWidth = (float)this.getIconWidth() + (float)2 * this.padding;
        float myHeight = (float)this.getIconHeight() + (float)2 * this.padding;
        g2d.setStroke(this.getStroke());
        g2d.setColor(this.getColor());
        g2d.draw(new RoundRectangle2D.Float(myX, myY, myWidth, myHeight, myWidth, myHeight));
        g2d.dispose();
    }

    @NotNull
    public abstract BasicStroke getStroke();
}

