/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.codeInsight.template.emmet.XmlEmmetBundle;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentZenCodingFilter
extends ZenCodingFilter {
    private static String buildCommentString(@Nullable String classAttr, @Nullable String idAttr) {
        StringBuilder builder = new StringBuilder();
        if (!Strings.isEmpty((String)idAttr)) {
            builder.append('#').append(idAttr);
        }
        if (!Strings.isEmpty((String)classAttr)) {
            builder.append('.').append(classAttr);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String filterText(@NotNull String text, @NotNull TemplateToken token) {
        XmlTag tag;
        if (text == null) {
            CommentZenCodingFilter.$$$reportNull$$$0(0);
        }
        if (token == null) {
            CommentZenCodingFilter.$$$reportNull$$$0(1);
        }
        if ((tag = token.getXmlTag()) != null) {
            String classAttr = token.getAttributes().get("class");
            String idAttr = token.getAttributes().get("id");
            if (!Strings.isEmpty((String)classAttr) || !Strings.isEmpty((String)idAttr)) {
                String commentString = CommentZenCodingFilter.buildCommentString(classAttr, idAttr);
                String string = String.format(this.getCommentFormat(), text, commentString);
                if (string == null) {
                    CommentZenCodingFilter.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = text;
        if (string == null) {
            CommentZenCodingFilter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String getCommentFormat() {
        return "%s\n<!-- /%s -->";
    }

    @Override
    @NotNull
    public String getSuffix() {
        return "c";
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        PsiElement parent;
        if (context == null) {
            CommentZenCodingFilter.$$$reportNull$$$0(4);
        }
        return (parent = context.getParent()) != null && parent.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = XmlEmmetBundle.message("emmet.filter.comment.tags", new Object[0]);
        if (string == null) {
            CommentZenCodingFilter.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/filters/CommentZenCodingFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/filters/CommentZenCodingFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterText";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

