/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.rpc.backend.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.platform.rpc.RemoteApiProviderService;
import com.intellij.platform.rpc.backend.RemoteApiProvider;
import com.intellij.platform.rpc.backend.impl.RemoteApiRegistry;
import com.intellij.util.containers.ContainerUtil;
import fleet.rpc.RemoteApi;
import fleet.rpc.RemoteApiDescriptor;
import fleet.rpc.core.InstanceId;
import fleet.rpc.server.RpcServiceLocator;
import fleet.rpc.server.ServiceImplementation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002*\u0002\u0012\u0015\b\u0000\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u0017\u001a\u0002H\u0018\"\u000e\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u00020\u00100\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u000b\u001a'\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f\u0012\u000e\u0012\f0\u0010\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f0\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/platform/rpc/backend/impl/RemoteApiRegistry;", "Lcom/intellij/platform/rpc/RemoteApiProviderService;", "Lfleet/rpc/server/RpcServiceLocator;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "remoteApis", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lfleet/rpc/server/ServiceImplementation;", "visitedEPs", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/platform/rpc/backend/RemoteApiProvider;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "registeringSink", "com/intellij/platform/rpc/backend/impl/RemoteApiRegistry$registeringSink$1", "Lcom/intellij/platform/rpc/backend/impl/RemoteApiRegistry$registeringSink$1;", "unregisteringSink", "com/intellij/platform/rpc/backend/impl/RemoteApiRegistry$unregisteringSink$1", "Lcom/intellij/platform/rpc/backend/impl/RemoteApiRegistry$unregisteringSink$1;", "resolve", "T", "Lfleet/rpc/RemoteApi;", "descriptor", "Lfleet/rpc/RemoteApiDescriptor;", "(Lfleet/rpc/RemoteApiDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "serviceId", "Lfleet/rpc/core/InstanceId;", "listRegisteredApis", "", "Companion", "intellij.platform.rpc.backend"})
@SourceDebugExtension(value={"SMAP\nRemoteApiRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteApiRegistry.kt\ncom/intellij/platform/rpc/backend/impl/RemoteApiRegistry\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n67#2,4:95\n13#2:99\n*S KotlinDebug\n*F\n+ 1 RemoteApiRegistry.kt\ncom/intellij/platform/rpc/backend/impl/RemoteApiRegistry\n*L\n81#1:95,4\n91#1:99\n*E\n"})
public final class RemoteApiRegistry
implements RemoteApiProviderService,
RpcServiceLocator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, ServiceImplementation> remoteApis;
    @NotNull
    private final ConcurrentMap<RemoteApiProvider, Unit> visitedEPs;
    @NotNull
    private final registeringSink.1 registeringSink;
    @NotNull
    private final unregisteringSink.1 unregisteringSink;
    @NotNull
    private static final Logger LOG;

    public RemoteApiRegistry(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.remoteApis = new ConcurrentHashMap();
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakKeyWeakValueMap(...)");
        this.visitedEPs = concurrentMap;
        this.registeringSink = new RemoteApiProvider.Sink(this){
            final /* synthetic */ RemoteApiRegistry this$0;
            {
                this.this$0 = $receiver;
            }

            public <T extends RemoteApi<Unit>> void remoteApi(RemoteApiDescriptor<T> descriptor, Function0<? extends T> implementation) {
                Intrinsics.checkNotNullParameter(descriptor, (String)"descriptor");
                Intrinsics.checkNotNullParameter(implementation, (String)"implementation");
                RemoteApiRegistry.access$getLOG$cp().debug("Registering remote api " + descriptor.getApiFqn() + " - " + descriptor);
                ((Map)RemoteApiRegistry.access$getRemoteApis$p(this.this$0)).put(descriptor.getApiFqn(), new ServiceImplementation(descriptor, (RemoteApi)implementation.invoke(), null));
            }
        };
        this.unregisteringSink = new RemoteApiProvider.Sink(this){
            final /* synthetic */ RemoteApiRegistry this$0;
            {
                this.this$0 = $receiver;
            }

            public <T extends RemoteApi<Unit>> void remoteApi(RemoteApiDescriptor<T> descriptor, Function0<? extends T> implementation) {
                Intrinsics.checkNotNullParameter(descriptor, (String)"descriptor");
                Intrinsics.checkNotNullParameter(implementation, (String)"implementation");
                RemoteApiRegistry.access$getLOG$cp().debug("Unregistering remote api " + descriptor.getApiFqn() + " - " + descriptor);
                RemoteApiRegistry.access$getRemoteApis$p(this.this$0).remove(descriptor.getApiFqn());
            }
        };
        RemoteApiProvider.Companion.getEP_NAME().addExtensionPointListener(coroutineScope, (ExtensionPointListener)new ExtensionPointListener<RemoteApiProvider>(){

            public void extensionAdded(RemoteApiProvider extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (visitedEPs.putIfAbsent(extension, Unit.INSTANCE) == null) {
                    LOG.debug("A new remote api provider has been added - " + extension);
                    RemoteApiRegistry remoteApiRegistry = this;
                    RemoteApiProvider $this$extensionAdded_u24lambda_u240 = extension;
                    boolean bl = false;
                    $this$extensionAdded_u24lambda_u240.remoteApis(remoteApiRegistry.registeringSink);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void extensionRemoved(RemoteApiProvider extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                visitedEPs.remove(extension);
                LOG.debug("Remote api provider has been removed - " + extension);
                RemoteApiRegistry remoteApiRegistry = this;
                1 var4_4 = this;
                synchronized (var4_4) {
                    boolean bl = false;
                    RemoteApiProvider $this$extensionRemoved_u24lambda_u241_u240 = extension;
                    boolean bl2 = false;
                    $this$extensionRemoved_u24lambda_u241_u240.remoteApis(remoteApiRegistry.unregisteringSink);
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        for (RemoteApiProvider extension : RemoteApiProvider.Companion.getEP_NAME().getExtensionList()) {
            if (this.visitedEPs.putIfAbsent(extension, Unit.INSTANCE) != null) continue;
            LOG.debug("Processing remote api provider extension - " + extension);
            RemoteApiProvider $this$_init__u24lambda_u240 = extension;
            boolean bl = false;
            $this$_init__u24lambda_u240.remoteApis(this.registeringSink);
        }
    }

    @Nullable
    public <T extends RemoteApi<Unit>> Object resolve(@NotNull RemoteApiDescriptor<T> descriptor, @NotNull Continuation<? super T> $completion) {
        ServiceImplementation serviceImplementation = this.remoteApis.get(descriptor.getApiFqn());
        RemoteApi remoteApi = serviceImplementation != null ? serviceImplementation.getInstance() : null;
        Object object = remoteApi instanceof RemoteApi ? remoteApi : null;
        if (object == null) {
            throw new IllegalStateException("No remote API found for " + descriptor);
        }
        return object;
    }

    @Nullable
    public ServiceImplementation resolve(@NotNull InstanceId serviceId) {
        ServiceImplementation serviceImplementation;
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        ServiceImplementation it = serviceImplementation = this.remoteApis.get(serviceId.getId());
        boolean bl = false;
        if (it == null) {
            LOG.debug("No remote API found for service ID: " + serviceId.getId());
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                Set set = this.remoteApis.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                logger.trace("Available remote APIs: " + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null));
            }
        }
        return serviceImplementation;
    }

    @NotNull
    public List<String> listRegisteredApis() {
        Set set = this.remoteApis.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getRemoteApis$p(RemoteApiRegistry $this) {
        return $this.remoteApis;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteApiRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/rpc/backend/impl/RemoteApiRegistry$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.rpc.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

