/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.terminal;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

public class NodeModulesEnvTerminalCustomizer
extends LocalTerminalCustomizer {
    private static final String PATH_ENV_NAME = "PATH";
    private static final Logger LOG = Logger.getInstance(NodeModulesEnvTerminalCustomizer.class);

    @NotNull
    public List<String> customizeCommandAndEnvironment(@NotNull Project project, @Nullable String workingDirectory, @NotNull List<String> shellCommand, @NotNull Map<String, String> envs, @NotNull EelDescriptor eelDescriptor) {
        if (project == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(0);
        }
        if (shellCommand == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(1);
        }
        if (envs == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(2);
        }
        if (eelDescriptor == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(3);
        }
        if (!project.isDisposed() && TerminalSettings.getInstance().isNodeModulesBinAdded()) {
            NodeModulesEnvTerminalCustomizer.customize(project, envs, eelDescriptor);
        }
        List list = super.customizeCommandAndEnvironment(project, workingDirectory, shellCommand, envs, eelDescriptor);
        if (list == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static void customize(@NotNull Project project, @NotNull Map<String, String> envs, @NotNull EelDescriptor eelDescriptor) {
        EelPath binDirEelPath;
        if (project == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(5);
        }
        if (envs == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(6);
        }
        if (eelDescriptor == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(7);
        }
        if ((binDirEelPath = NodeModulesEnvTerminalCustomizer.findBinDirPath(project)) == null) {
            return;
        }
        if (!eelDescriptor.equals((Object)binDirEelPath.getDescriptor())) {
            LOG.warn("Different EelDescriptors: expected: " + String.valueOf(eelDescriptor) + ", actual: " + String.valueOf(binDirEelPath.getDescriptor()));
            return;
        }
        String prevValue = envs.get(PATH_ENV_NAME);
        String newValue = prevValue != null ? prevValue + EelPlatformKt.getPathSeparator((EelOsFamily)eelDescriptor.getOsFamily()) + String.valueOf(binDirEelPath) : binDirEelPath.toString();
        envs.put(PATH_ENV_NAME, newValue);
    }

    @Nullable
    private static EelPath findBinDirPath(@NotNull Project project) {
        VirtualFile root;
        if (project == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(8);
        }
        if ((root = NodeModulesEnvTerminalCustomizer.guessNodeModulesRoot(project)) == null) {
            return null;
        }
        VirtualFile binDirVirtualFile = root.findFileByRelativePath("node_modules/.bin");
        if (binDirVirtualFile == null) {
            return null;
        }
        try {
            Path binDirPath = binDirVirtualFile.toNioPath();
            return EelNioBridgeServiceKt.asEelPath((Path)binDirPath);
        }
        catch (Exception e) {
            LOG.warn("Cannot find EelPath for " + binDirVirtualFile.getPath(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static VirtualFile guessNodeModulesRoot(@Nullable Project project) {
        VirtualFile baseDir;
        VirtualFile virtualFile = baseDir = project != null ? ProjectUtil.guessProjectDir((Project)project) : null;
        if (baseDir != null && (NodeModuleUtil.findChildNodeModulesDir((VirtualFile)baseDir) != null || PackageJsonUtil.findChildPackageJsonFile((VirtualFile)baseDir) != null)) {
            return baseDir;
        }
        return null;
    }

    @Nullable
    public UnnamedConfigurable getConfigurable(@NotNull Project project) {
        if (project == null) {
            NodeModulesEnvTerminalCustomizer.$$$reportNull$$$0(9);
        }
        EelDescriptor descriptor = EelProviderUtil.getEelDescriptor((Project)project);
        return NodeModulesEnvTerminalCustomizer.guessNodeModulesRoot(project) != null ? new NodeModulesBinConfigurable(descriptor.getOsFamily()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eelDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "customizeCommandAndEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCommandAndEnvironment";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBinDirPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    @State(name="NodeModulesEnvTerminalCustomizer", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
    private static class TerminalSettings
    implements PersistentStateComponent<SettingsState> {
        private SettingsState myState = new SettingsState();

        private TerminalSettings() {
        }

        private boolean isNodeModulesBinAdded() {
            return this.myState.myAddNodeModulesBin;
        }

        private void setNodeModulesBinAdded(boolean nodeModulesBinAdded) {
            this.myState.myAddNodeModulesBin = nodeModulesBinAdded;
        }

        @Nullable
        public SettingsState getState() {
            return this.myState;
        }

        public void loadState(@NotNull SettingsState state) {
            if (state == null) {
                TerminalSettings.$$$reportNull$$$0(0);
            }
            this.myState = state;
        }

        @NotNull
        private static TerminalSettings getInstance() {
            TerminalSettings terminalSettings = (TerminalSettings)ApplicationManager.getApplication().getService(TerminalSettings.class);
            if (terminalSettings == null) {
                TerminalSettings.$$$reportNull$$$0(1);
            }
            return terminalSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }

        public static class SettingsState {
            public boolean myAddNodeModulesBin = true;
        }
    }

    private static class NodeModulesBinConfigurable
    implements UnnamedConfigurable {
        private final JCheckBox myCheckbox;
        private final TerminalSettings mySettings;

        NodeModulesBinConfigurable(@NotNull EelOsFamily osFamily) {
            if (osFamily == null) {
                NodeModulesBinConfigurable.$$$reportNull$$$0(0);
            }
            this.mySettings = TerminalSettings.getInstance();
            this.myCheckbox = new JCheckBox(JavaScriptBundle.message((String)"terminal.add_node_modules_bin_to_path.label", (Object[])new Object[]{EelPlatformKt.isWindows((EelOsFamily)osFamily) ? "%PATH%" : "$PATH"}));
        }

        @Nullable
        public JComponent createComponent() {
            return this.myCheckbox;
        }

        public boolean isModified() {
            return this.mySettings.isNodeModulesBinAdded() != this.myCheckbox.isSelected();
        }

        public void apply() {
            this.mySettings.setNodeModulesBinAdded(this.myCheckbox.isSelected());
        }

        public void reset() {
            this.myCheckbox.setSelected(this.mySettings.isNodeModulesBinAdded());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "osFamily", "com/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$NodeModulesBinConfigurable", "<init>"));
        }
    }
}

