/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.apiversioning.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.apiversioning.SpringApiVersioningModel;
import com.intellij.spring.mvc.apiversioning.SpringProgrammaticVersioningConfigSearcher;
import com.intellij.spring.mvc.apiversioning.highlighting.SpringApiVersioningMethodInspectionBase;
import com.intellij.spring.mvc.apiversioning.highlighting.fix.SpringConfigureApiVersioningFix;
import com.intellij.spring.mvc.apiversioning.highlighting.fix.SpringNavigateToWebConfigurerFix;
import com.intellij.spring.mvc.apiversioning.model.SpringApiVersioningConfiguration;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ+\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningConfigurationInspection;", "Lcom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningMethodInspectionBase;", "<init>", "()V", "checkMethodInternal", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "module", "Lcom/intellij/openapi/module/Module;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/openapi/module/Module;Lcom/intellij/codeInspection/ProblemsHolder;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkApiVersioningIsConfigured", "canAddApiVersioningConfiguration", "", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringApiVersioningConfigurationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringApiVersioningConfigurationInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningConfigurationInspection\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n18#2:69\n1786#3,3:70\n*S KotlinDebug\n*F\n+ 1 SpringApiVersioningConfigurationInspection.kt\ncom/intellij/spring/mvc/apiversioning/highlighting/SpringApiVersioningConfigurationInspection\n*L\n38#1:69\n66#1:70,3\n*E\n"})
public final class SpringApiVersioningConfigurationInspection
extends SpringApiVersioningMethodInspectionBase {
    @Override
    @NotNull
    public ProblemDescriptor[] checkMethodInternal(@NotNull UMethod uMethod, @NotNull Module module, @NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        return this.checkApiVersioningIsConfigured(uMethod, module, problemsHolder);
    }

    private final ProblemDescriptor[] checkApiVersioningIsConfigured(UMethod uMethod, Module module, ProblemsHolder problemsHolder) {
        LocalQuickFix[] localQuickFixArray;
        PsiElement $this$getParentOfType_u24default$iv;
        block9: {
            block8: {
                PsiMethod psiMethod = uMethod.getJavaPsi();
                RequestMapping.Method method = (RequestMapping.Method)JamService.getJamService((Project)module.getProject()).getJamElement(RequestMapping.METHOD_JAM_KEY, (PsiElement)psiMethod);
                if (method == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return ProblemDescriptor.EMPTY_ARRAY;
                }
                RequestMapping.Method requestMapping = method;
                if (requestMapping.getVersion() == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return ProblemDescriptor.EMPTY_ARRAY;
                }
                PsiAnnotation psiAnnotation = requestMapping.getIdentifyingAnnotation();
                UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)(psiAnnotation != null ? psiAnnotation.findDeclaredAttributeValue("version") : null)));
                if (uElement == null) break block8;
                UElement uElement2 = uElement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                UNamedExpression uNamedExpression = (UNamedExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UNamedExpression.class, (boolean)strict$iv);
                if (uNamedExpression != null && ($this$getParentOfType_u24default$iv = uNamedExpression.getSourcePsi()) != null) break block9;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement anchor = $this$getParentOfType_u24default$iv;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SpringApiVersioningConfiguration apiVersioningConfiguration = SpringApiVersioningModel.Companion.getInstance(project).getApiVersioningConfiguration(module);
        if (apiVersioningConfiguration != null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String inspectionMessage = SpringMvcBundle.message("mvc.inspection.api.versioning.not.configured", new Object[0]);
        if (this.canAddApiVersioningConfiguration(module)) {
            var10_9 = new SpringConfigureApiVersioningFix[]{new SpringConfigureApiVersioningFix()};
            localQuickFixArray = (LocalQuickFix[])var10_9;
        } else {
            var10_9 = new SpringNavigateToWebConfigurerFix[]{new SpringNavigateToWebConfigurerFix()};
            localQuickFixArray = (LocalQuickFix[])var10_9;
        }
        LocalQuickFix[] fixes = localQuickFixArray;
        problemsHolder.registerProblem(anchor, inspectionMessage, Arrays.copyOf(fixes, fixes.length));
        ProblemDescriptor[] problemDescriptorArray = problemsHolder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
        return problemDescriptorArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canAddApiVersioningConfiguration(Module module) {
        boolean bl;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<Pair<UClass, UMethod>> configurers = SpringProgrammaticVersioningConfigSearcher.Companion.getInstance(project).getConfigureApiVersioningMethods$intellij_spring_mvc_impl(module);
        if (configurers.isEmpty()) return true;
        Iterable $this$all$iv = configurers;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            UMethod method = (UMethod)pair.component2();
            if (method != null) return false;
            bl = true;
        } while (bl);
        return false;
    }
}

