/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.ModulesSorter;
import com.intellij.spring.mvc.model.SpringMvcUrlResolverKt;
import com.intellij.spring.mvc.model.SpringMvcUrlTargetInfo;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.spring.mvc.utils.SpringMvcUrlUtils;
import com.intellij.spring.mvc.views.SpringMvcViewTargetResolver;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="com.intellij.spring.SpringApiIcons.RequestMapping", typeName="Spring MVC")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/spring/mvc/model/SpringMvcUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "Lcom/intellij/spring/mvc/views/SpringMvcViewTargetResolver;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modules", "Lcom/intellij/spring/mvc/model/ModulesSorter;", "getModules", "()Lcom/intellij/spring/mvc/model/ModulesSorter;", "resolve", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "module", "Lcom/intellij/openapi/module/Module;", "getVariants", "isMvcCapableModule", "", "it", "Factory", "intellij.spring.mvc.impl"})
public final class SpringMvcUrlResolver
extends HttpUrlResolver
implements SpringMvcViewTargetResolver {
    @NotNull
    private final Project project;

    public SpringMvcUrlResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final ModulesSorter getModules() {
        return ModulesSorter.Companion.getInstance(this.project);
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)this.getModules(), (Function1)((Function1)new Function1<Module, Boolean>((Object)this){

            public final Boolean invoke(Module p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SpringMvcUrlResolver.access$isMvcCapableModule((SpringMvcUrlResolver)this.receiver, p0);
            }
        })), arg_0 -> SpringMvcUrlResolver.resolve$lambda$0(this, request, arg_0)));
    }

    @Override
    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull Module module, @NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(UrlPathContextKt.chopLeadingEmptyBlock((UrlPath)request.getPath())), arg_0 -> SpringMvcUrlResolver.resolve$lambda$1(module, arg_0)), arg_0 -> SpringMvcUrlResolver.resolve$lambda$2(module, this, arg_0)));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)this.getModules(), (Function1)((Function1)new Function1<Module, Boolean>((Object)this){

            public final Boolean invoke(Module p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SpringMvcUrlResolver.access$isMvcCapableModule((SpringMvcUrlResolver)this.receiver, p0);
            }
        })), arg_0 -> SpringMvcUrlResolver.getVariants$lambda$0(this, arg_0)));
    }

    private final boolean isMvcCapableModule(Module it) {
        return SpringMvcLibraryUtil.hasSpringMvcLibrary(it) || SpringMvcLibraryUtil.hasWebfluxLibrary(it);
    }

    private static final Iterable resolve$lambda$0(SpringMvcUrlResolver this$0, UrlResolveRequest $request, Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this$0.resolve(module, $request);
    }

    private static final Sequence resolve$lambda$2$0(Module $module, UrlMappingElement it) {
        Intrinsics.checkNotNull((Object)it);
        return SpringMvcUrlResolverKt.combineWithAppPath($module, it);
    }

    private static final SpringMvcUrlTargetInfo resolve$lambda$2$1(SpringMvcUrlResolver this$0, Module $module, UrlMappingElement resolved) {
        Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
        return new SpringMvcUrlTargetInfo(this$0.getSupportedSchemes(), resolved, SpringMvcUrlUtils.getAuthoritiesByModule($module));
    }

    private static final Sequence resolve$lambda$1(Module $module, UrlPath it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SpringMvcUrlResolverKt.access$trimAppPathPrefix($module, it);
    }

    private static final Sequence resolve$lambda$2(Module $module, SpringMvcUrlResolver this$0, UrlPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Collection<UrlMappingElement> collection = SpringMvcUtils.getMatchingUrlMappings($module, path);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getMatchingUrlMappings(...)");
        return SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> SpringMvcUrlResolver.resolve$lambda$2$0($module, arg_0)), arg_0 -> SpringMvcUrlResolver.resolve$lambda$2$1(this$0, $module, arg_0));
    }

    private static final void getVariants$lambda$0$0(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Sequence getVariants$lambda$0$1(Module $module, UrlMappingElement it) {
        Intrinsics.checkNotNull((Object)it);
        return SpringMvcUrlResolverKt.combineWithAppPath($module, it);
    }

    private static final SpringMvcUrlTargetInfo getVariants$lambda$0$2(SpringMvcUrlResolver this$0, Module $module, UrlMappingElement urlPath) {
        Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
        return new SpringMvcUrlTargetInfo(this$0.getSupportedSchemes(), urlPath, SpringMvcUrlUtils.getAuthoritiesByModule($module));
    }

    private static final Sequence getVariants$lambda$0(SpringMvcUrlResolver this$0, Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable<UrlMappingElement> iterable = SpringMvcUtils.getUrlMappingsWithoutSpringModel(module, (arg_0, arg_1) -> SpringMvcUrlResolver.getVariants$lambda$0$0(this$0.getModules().listener(module), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getUrlMappingsWithoutSpringModel(...)");
        return SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence(iterable), arg_0 -> SpringMvcUrlResolver.getVariants$lambda$0$1(module, arg_0)), arg_0 -> SpringMvcUrlResolver.getVariants$lambda$0$2(this$0, module, arg_0));
    }

    public static final /* synthetic */ boolean access$isMvcCapableModule(SpringMvcUrlResolver $this, Module it) {
        return $this.isMvcCapableModule(it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/spring/mvc/model/SpringMvcUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "<init>", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.mvc.impl"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SpringLibraryUtil.hasSpringLibrary((Project)project) ? (UrlResolver)new SpringMvcUrlResolver(project) : null;
        }
    }
}

