/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.DeleteProvider;
import com.intellij.jam.JamChief;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonDomModelElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelTarget;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public final class JamCommonUtil {
    @NonNls
    public static final String VALUE_PARAMETER = "value";
    private static final Key<CachedValue<Module[]>> MODULE_DEPENDENCIES = Key.create((String)"MODULE_DEPENDENCIES");
    private static final Key<CachedValue<Module[]>> MODULE_DEPENDENTS = Key.create((String)"MODULE_DEPENDENTS");

    private JamCommonUtil() {
    }

    @Nullable
    public static Object computeMemberValue(@Nullable PsiElement value) {
        if (value == null) {
            return null;
        }
        if (value instanceof XmlAttributeValue) {
            GenericAttributeValue genericValue = DomManager.getDomManager((Project)value.getProject()).getDomElement((XmlAttribute)value.getParent());
            return genericValue != null ? genericValue.getValue() : ((XmlAttributeValue)value).getValue();
        }
        try {
            return JavaPsiFacade.getInstance((Project)value.getProject()).getConstantEvaluationHelper().computeConstantExpression(value, false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    public static boolean isSuperClass(@Nullable PsiClass firstClass, String superClassQName) {
        return !JamCommonUtil.processSuperClassList(firstClass, (Collection<? super PsiClass>)new SmartList(), (Processor<? super PsiClass>)((Processor)superClass -> !Objects.equals(superClass.getQualifiedName(), superClassQName)));
    }

    @NotNull
    public static List<PsiClass> getSuperClassList(@Nullable PsiClass firstClass) {
        SmartList list = new SmartList();
        JamCommonUtil.processSuperClassList(firstClass, (Collection<? super PsiClass>)list, (Processor<? super PsiClass>)CommonProcessors.alwaysTrue());
        SmartList smartList = list;
        if (smartList == null) {
            JamCommonUtil.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    public static boolean processSuperClassList(@Nullable PsiClass firstClass, @NotNull Collection<? super PsiClass> supers, Processor<? super PsiClass> processor) {
        if (supers == null) {
            JamCommonUtil.$$$reportNull$$$0(1);
        }
        for (PsiClass curClass = firstClass; curClass != null && !"java.lang.Object".equals(curClass.getQualifiedName()) && !supers.contains(curClass); curClass = curClass.getSuperClass()) {
            ProgressManager.checkCanceled();
            if (!processor.process((Object)curClass)) {
                return false;
            }
            supers.add((PsiClass)curClass);
        }
        return true;
    }

    @Nullable
    public static <T> T getRootElement(PsiFile file, Class<T> domClass) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        DomManager domManager = DomManager.getDomManager((Project)file.getProject());
        DomFileElement element = domManager.getFileElement((XmlFile)file, DomElement.class);
        if (element == null) {
            return null;
        }
        DomElement root = element.getRootElement();
        if (!ReflectionUtil.isAssignable(domClass, (Class)root.getClass())) {
            return null;
        }
        return domClass.cast(root);
    }

    @Nullable
    public static String getDisplayName(Object element) {
        if (element instanceof CommonModelElement) {
            CommonModelElement modelElement = (CommonModelElement)element;
            String name = JamCommonUtil.getElementName(modelElement);
            if (name == null) {
                name = "";
            }
            return JamCommonUtil.getClassName(modelElement) + " '" + name + "'";
        }
        return null;
    }

    @Nullable
    public static String getElementName(CommonModelElement element) {
        return ElementPresentationManager.getElementName((Object)element);
    }

    public static String getClassName(CommonModelElement element) {
        return ElementPresentationManager.getTypeNameForObject((Object)element);
    }

    @Nullable
    public static Module findModuleForPsiElement(PsiElement element) {
        Module module;
        DomFileElement domFileElement;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            return virtualFile == null ? null : ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getModuleForFile(virtualFile);
        }
        if ((psiFile = psiFile.getOriginalFile()) instanceof XmlFile && (domFileElement = DomManager.getDomManager((Project)element.getProject()).getFileElement((XmlFile)psiFile, CommonDomModelElement.class)) != null && (module = ((CommonDomModelElement)domFileElement.getRootElement()).getModule()) != null) {
            return module;
        }
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
    }

    public static PsiElement @NotNull [] getTargetPsiElements(CommonModelElement element) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (CommonModelElement modelElement : ModelMergerUtil.getFilteredImplementations((Object)element)) {
            if (modelElement instanceof DomElement) {
                DomElement domModelElement = (DomElement)modelElement;
                if (domModelElement.getXmlTag() == null) continue;
                list.add(domModelElement.getXmlTag());
                continue;
            }
            if (modelElement instanceof JamChief) {
                list.add(((JamChief)((Object)modelElement)).getPsiElement());
                continue;
            }
            ContainerUtil.addIfNotNull(list, (Object)modelElement.getIdentifyingPsiElement());
        }
        PsiElement[] result = list.isEmpty() ? PsiElement.EMPTY_ARRAY : PsiUtilCore.toPsiElementArray(list);
        Arrays.sort(result, new Comparator<PsiElement>(){

            @Override
            public int compare(@NotNull PsiElement o1, @NotNull PsiElement o2) {
                if (o1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (o2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return 1.getWeight(o1) - 1.getWeight(o2);
            }

            private static int getWeight(PsiElement o) {
                if (o instanceof XmlTag) {
                    return 0;
                }
                if (o instanceof PsiMember) {
                    return 1;
                }
                if (o instanceof PsiAnnotation) {
                    return 2;
                }
                return 3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jam/model/util/JamCommonUtil$1";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (result == null) {
            JamCommonUtil.$$$reportNull$$$0(2);
        }
        return result;
    }

    @Contract(value="null -> false")
    public static boolean isInLibrary(CommonModelElement modelElement) {
        if (modelElement == null) {
            return false;
        }
        PsiElement psiElement = modelElement.getIdentifyingPsiElement();
        if (psiElement == null) {
            return false;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)modelElement.getPsiManager().getProject()).getFileIndex().isInLibraryClasses(virtualFile);
    }

    @Contract(value="null -> false")
    private static boolean isKindOfJavaFile(PsiElement element) {
        return element instanceof PsiJavaFile && element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Contract(value="null -> false")
    public static boolean isPlainJavaFile(PsiElement element) {
        return JamCommonUtil.isKindOfJavaFile(element) && ((PsiFile)element).getFileType() == StdFileTypes.JAVA;
    }

    @Contract(value="null -> false")
    public static boolean isPlainXmlFile(PsiElement element) {
        return element instanceof XmlFile && element.getLanguage() == XMLLanguage.INSTANCE;
    }

    public static Module @NotNull [] getAllModuleDependencies(@NotNull Module module) {
        if (module == null) {
            JamCommonUtil.$$$reportNull$$$0(3);
        }
        Module[] moduleArray = (Module[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, MODULE_DEPENDENCIES, () -> {
            Set<Module> result = JamCommonUtil.addModuleDependencies(module, new HashSet<Module>(), false);
            return new CachedValueProvider.Result((Object)result.toArray(Module.EMPTY_ARRAY), new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        }, false);
        if (moduleArray == null) {
            JamCommonUtil.$$$reportNull$$$0(4);
        }
        return moduleArray;
    }

    public static Module @NotNull [] getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            JamCommonUtil.$$$reportNull$$$0(5);
        }
        Module[] moduleArray = (Module[])CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, MODULE_DEPENDENTS, () -> {
            Module[] modules = ModuleManager.getInstance((Project)module.getProject()).getModules();
            Set<Module> result = JamCommonUtil.addModuleDependents(module, new HashSet<Module>(), modules);
            return new CachedValueProvider.Result((Object)result.toArray(Module.EMPTY_ARRAY), new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        }, false);
        if (moduleArray == null) {
            JamCommonUtil.$$$reportNull$$$0(6);
        }
        return moduleArray;
    }

    private static Set<Module> addModuleDependencies(Module module, Set<Module> result, boolean exported) {
        OrderEntry[] orderEntries;
        if (module.isDisposed()) {
            return Collections.emptySet();
        }
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            Module exportedModule;
            if (!orderEntry.isValid() || !(orderEntry instanceof ModuleOrderEntry) || exported && !((ModuleOrderEntry)orderEntry).isExported() || (exportedModule = ((ModuleOrderEntry)orderEntry).getModule()) == null || !result.add(exportedModule)) continue;
            JamCommonUtil.addModuleDependencies(exportedModule, result, true);
        }
        return result;
    }

    private static Set<Module> addModuleDependents(Module module, Set<Module> result, Module[] modules) {
        if (!result.add(module)) {
            return result;
        }
        for (Module allModule : modules) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)allModule).getOrderEntries()) {
                Module exportedModule;
                if (!orderEntry.isValid() || !(orderEntry instanceof ModuleOrderEntry) || (exportedModule = ((ModuleOrderEntry)orderEntry).getModule()) != module || !result.add(allModule) || !((ModuleOrderEntry)orderEntry).isExported()) continue;
                JamCommonUtil.addModuleDependents(allModule, result, modules);
            }
        }
        return result;
    }

    @Nullable
    public static XmlTag getXmlTag(CommonModelElement object) {
        DomElement dom = (DomElement)ModelMergerUtil.getImplementation((Object)object, DomElement.class);
        return dom != null ? dom.getXmlTag() : null;
    }

    public static <M extends PsiModifierListOwner, V extends JamElement> List<V> getElementsIncludingSingle(M member, JamAnnotationMeta multiMeta, JamAnnotationAttributeMeta<? extends V, ? extends List<V>> multiAttrMeta) {
        List multiValue = (List)multiMeta.getAttribute(member, multiAttrMeta);
        PsiElementRef<PsiAnnotation> singleAnno = multiAttrMeta.getAnnotationMeta().getAnnotationRef(member);
        return singleAnno.isImaginary() ? multiValue : ContainerUtil.concat(Collections.singletonList((JamElement)multiAttrMeta.getInstantiator().apply(singleAnno)), (List)multiValue);
    }

    public static String getFirstRootAnnotation(JamMemberMeta<?, ?> meta) {
        List<JamAnnotationMeta> annotationMetas = meta == null ? null : meta.getAnnotations();
        return annotationMetas == null || annotationMetas.isEmpty() ? null : annotationMetas.get(0).getAnnoName();
    }

    @Nullable
    public static Object getModelObject(PsiElement element) {
        if (!(element instanceof PomTargetPsiElement)) {
            return null;
        }
        PomTarget target = ((PomTargetPsiElement)element).getTarget();
        return target instanceof CommonModelTarget ? ((CommonModelTarget)target).getCommonElement() : (target instanceof JamPomTarget ? ((JamPomTarget)target).getJamElement() : (target instanceof DomTarget ? ((DomTarget)target).getDomElement() : null));
    }

    @Nullable
    public static DeleteProvider createDeleteProvider(@NotNull Set<? extends JamNodeDescriptor> descriptors) {
        if (descriptors == null) {
            JamCommonUtil.$$$reportNull$$$0(7);
        }
        final ArrayList<DeleteProvider> providers = new ArrayList<DeleteProvider>();
        ArrayList<JamDeleteProvider> jamProviders = new ArrayList<JamDeleteProvider>();
        for (JamNodeDescriptor jamNodeDescriptor : descriptors) {
            DeleteProvider provider;
            DeleteProvider deleteProvider = provider = jamNodeDescriptor.isValid() ? (DeleteProvider)jamNodeDescriptor.getDataForElement(PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getName()) : null;
            if (provider instanceof JamDeleteProvider) {
                jamProviders.add((JamDeleteProvider)provider);
                continue;
            }
            if (provider == null) continue;
            providers.add(provider);
        }
        if (!jamProviders.isEmpty()) {
            if (jamProviders.size() == 1) {
                providers.add((DeleteProvider)jamProviders.get(0));
            } else {
                providers.add(new JamDeleteProvider(jamProviders));
            }
        }
        if (providers.isEmpty()) {
            return null;
        }
        return new DeleteProvider(){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void deleteElement(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (DeleteProvider provider : providers) {
                    provider.deleteElement(dataContext);
                }
            }

            public boolean canDeleteElement(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (DeleteProvider provider : providers) {
                    if (provider.canDeleteElement(dataContext)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jam/model/util/JamCommonUtil$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jam/model/util/JamCommonUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "deleteElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "canDeleteElement";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public static void setAnnotationAttributeValue(PsiAnnotation annotation, String attribute, String value) {
        new JamStringAttributeElement<String>((PsiElementRef<? extends PsiAnnotation>)PsiElementRef.real((PsiElement)annotation), attribute, JamConverter.DUMMY_CONVERTER).setStringValue(value);
    }

    public static <T extends PsiModifierListOwner> void findAnnotatedElements(@NotNull Class<? extends T> elementClass, @NotNull String annotationClass, @NotNull PsiManager psiManager, @NotNull GlobalSearchScope scope, @NotNull Processor<? super T> processor) {
        Project project;
        JavaPsiFacade facade;
        PsiClass annotataionPsiClass;
        if (elementClass == null) {
            JamCommonUtil.$$$reportNull$$$0(8);
        }
        if (annotationClass == null) {
            JamCommonUtil.$$$reportNull$$$0(9);
        }
        if (psiManager == null) {
            JamCommonUtil.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JamCommonUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JamCommonUtil.$$$reportNull$$$0(12);
        }
        if ((annotataionPsiClass = (facade = JavaPsiFacade.getInstance((Project)(project = psiManager.getProject()))).findClass(annotationClass, GlobalSearchScope.allScope((Project)project))) == null) {
            return;
        }
        AnnotatedElementsSearch.searchElements((PsiClass)annotataionPsiClass, (SearchScope)scope, (Class[])new Class[]{elementClass}).forEach(processor);
    }

    public static boolean processObjectArrayValue(PsiAnnotation annotation, String attributeName, Processor<? super PsiAnnotationMemberValue> processor) {
        return annotation == null || JamCommonUtil.processObjectArrayValue(annotation.findAttributeValue(attributeName), processor);
    }

    public static boolean processObjectArrayValue(@Nullable PsiAnnotationMemberValue memberValue, Processor<? super PsiAnnotationMemberValue> processor) {
        return ContainerUtil.process((List)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)memberValue), processor);
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiElement psiAnnotationMemberValue) {
        Object value;
        PsiClass psiClass = null;
        if (psiAnnotationMemberValue instanceof PsiClassObjectAccessExpression) {
            PsiType type = ((PsiClassObjectAccessExpression)psiAnnotationMemberValue).getOperand().getType();
            if (type instanceof PsiClassType) {
                psiClass = ((PsiClassType)type).resolve();
            }
        } else if (psiAnnotationMemberValue instanceof PsiExpression && (value = JamCommonUtil.computeMemberValue(psiAnnotationMemberValue)) instanceof String) {
            String className = StringUtil.unquoteString((String)((String)value));
            psiClass = JavaPsiFacade.getInstance((Project)psiAnnotationMemberValue.getProject()).findClass(className, psiAnnotationMemberValue.getResolveScope());
        }
        if (psiClass != null && "java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        return psiClass;
    }

    @Nullable
    public static <T> T getObjectValue(@Nullable PsiElement value, Class<T> clazz) {
        boolean isString;
        boolean bl = isString = clazz == String.class;
        if (ReflectionUtil.isAssignable(Enum.class, clazz)) {
            return clazz.cast(JamCommonUtil.getEnumValue(value, clazz));
        }
        Object obj = JamCommonUtil.computeMemberValue(value);
        if (obj != null && ReflectionUtil.isAssignable(clazz, obj.getClass())) {
            return clazz.cast(isString ? StringUtil.unquoteString((String)((String)obj)) : obj);
        }
        return null;
    }

    @Nullable
    public static <T extends Enum> T getEnumValue(PsiElement memberValue, Class<T> clazz) {
        PsiElement psiElement;
        assert (ReflectionUtil.isAssignable(Enum.class, clazz));
        UReferenceExpression uReferenceExpression = (UReferenceExpression)UastContextKt.toUElement((PsiElement)memberValue, UReferenceExpression.class);
        if (uReferenceExpression != null && (psiElement = uReferenceExpression.resolve()) instanceof PsiField) {
            PsiField psiField = (PsiField)psiElement;
            return (T)((Enum)clazz.cast(Enum.valueOf(clazz, psiField.getName())));
        }
        return null;
    }

    @Nullable
    public static <T extends JamElement> T getJamElementForMethodOrSupers(@NotNull JamService jamService, @NotNull PsiMethod method, JamMemberMeta<? extends PsiModifierListOwner, ? extends T> ... metas) {
        if (jamService == null) {
            JamCommonUtil.$$$reportNull$$$0(13);
        }
        if (method == null) {
            JamCommonUtil.$$$reportNull$$$0(14);
        }
        return (T)JamCommonUtil.computeForSelfOrSupper(method, m -> jamService.getJamElement((PsiElement)m, metas));
    }

    @Nullable
    public static <T extends JamElement> T getJamElementForMethodOrSupers(@NotNull JamService jamService, @NotNull SemKey<T> key, @NotNull PsiMethod method) {
        if (jamService == null) {
            JamCommonUtil.$$$reportNull$$$0(15);
        }
        if (key == null) {
            JamCommonUtil.$$$reportNull$$$0(16);
        }
        if (method == null) {
            JamCommonUtil.$$$reportNull$$$0(17);
        }
        return (T)JamCommonUtil.computeForSelfOrSupper(method, m -> jamService.getJamElement(key, (PsiElement)m));
    }

    @Nullable
    private static <T> T computeForSelfOrSupper(@NotNull PsiMethod method, @NotNull Function<? super PsiMethod, ? extends T> resultProvider) {
        T result;
        if (method == null) {
            JamCommonUtil.$$$reportNull$$$0(18);
        }
        if (resultProvider == null) {
            JamCommonUtil.$$$reportNull$$$0(19);
        }
        if ((result = resultProvider.apply((PsiMethod)method)) != null) {
            return result;
        }
        for (PsiMethod superMethod : method.findSuperMethods()) {
            result = resultProvider.apply((PsiMethod)superMethod);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/model/util/JamCommonUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supers";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jamService";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassList";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/model/util/JamCommonUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPsiElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClassList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllModuleDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteProvider";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotatedElements";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getJamElementForMethodOrSupers";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeForSelfOrSupper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }
}

