/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamMemberMeta<Psi extends PsiModifierListOwner, Jam extends JamElement>
extends JamMemberArchetype<Psi, Jam>
implements SemElement,
Function<Psi, JamMemberMeta> {
    private final SemKey<Jam> myJamKey;
    private final SemKey<JamMemberMeta> myMetaKey;
    private final Function<PsiElementRef<?>, ? extends Jam> myCreator;
    private final List<JamAnnotationMeta> myRootAnnos;

    protected JamMemberMeta(@NotNull Class<? extends Jam> jamClass, Function<PsiElementRef<?>, Jam> jamFactory) {
        if (jamClass == null) {
            JamMemberMeta.$$$reportNull$$$0(0);
        }
        this(null, jamFactory, JamService.JAM_ELEMENT_KEY.subKey(jamClass.getSimpleName(), new SemKey[0]));
    }

    public JamMemberMeta(@Nullable JamMemberArchetype<? super Psi, ? super Jam> parent, @NotNull Class<? extends Jam> jamClass, @NotNull Function<PsiElementRef<?>, Jam> jamFactory) {
        if (jamClass == null) {
            JamMemberMeta.$$$reportNull$$$0(1);
        }
        if (jamFactory == null) {
            JamMemberMeta.$$$reportNull$$$0(2);
        }
        this(parent, jamFactory, JamService.JAM_ELEMENT_KEY.subKey(jamClass.getSimpleName(), new SemKey[0]));
    }

    public JamMemberMeta(@Nullable JamMemberArchetype<? super Psi, ? super Jam> parent, @NotNull Function<PsiElementRef<?>, Jam> jamFactory, SemKey<Jam> jamKey) {
        if (jamFactory == null) {
            JamMemberMeta.$$$reportNull$$$0(3);
        }
        super(parent);
        this.myRootAnnos = new SmartList();
        this.myJamKey = jamKey;
        this.myCreator = jamFactory;
        this.myMetaKey = JamService.getMetaKey(this.myJamKey);
    }

    public JamMemberMeta(@Nullable JamMemberArchetype<? super Psi, ? super Jam> parent, SemKey<Jam> jamKey, Function<PsiElementRef<Psi>, ? extends Jam> creator) {
        super(parent);
        this.myRootAnnos = new SmartList();
        this.myJamKey = jamKey;
        this.myCreator = creator;
        this.myMetaKey = JamService.getMetaKey(this.myJamKey);
    }

    public SemKey<Jam> getJamKey() {
        return this.myJamKey;
    }

    public SemKey<JamMemberMeta> getMetaKey() {
        return this.myMetaKey;
    }

    public List<JamAnnotationMeta> getRootAnnotations() {
        return this.myRootAnnos;
    }

    public void register(SemRegistrar registrar, ElementPattern<? extends Psi> pattern) {
        registrar.registerSemElementProvider(this.myMetaKey, pattern, (Function)this);
        registrar.registerSemElementProvider(this.myJamKey, pattern, this::createJamElement);
        this.registerChildren(registrar, pattern);
        for (JamMemberArchetype cur = this; cur != null; cur = cur.getParent()) {
            for (JamAnnotationMeta anno : cur.getAnnotations()) {
                anno.registerTopLevelSem(registrar, pattern, this);
            }
        }
    }

    @Override
    @Nullable
    public JamMemberMeta<?, ?> apply(Psi psi) {
        return this;
    }

    @Override
    @NotNull
    public JamMemberMeta<Psi, Jam> addPomTargetProducer(@NotNull PairConsumer<Jam, Consumer<PomTarget>> producer) {
        if (producer == null) {
            JamMemberMeta.$$$reportNull$$$0(4);
        }
        super.addPomTargetProducer(producer);
        JamMemberMeta jamMemberMeta = this;
        if (jamMemberMeta == null) {
            JamMemberMeta.$$$reportNull$$$0(5);
        }
        return jamMemberMeta;
    }

    @Nullable
    public final Jam getJamElement(@NotNull Psi member) {
        if (member == null) {
            JamMemberMeta.$$$reportNull$$$0(6);
        }
        return (Jam)((JamElement)SemService.getSemService((Project)member.getProject()).getSemElement(this.myJamKey, member));
    }

    @Nullable
    private Jam createJamElement(@NotNull Psi psi) {
        if (psi == null) {
            JamMemberMeta.$$$reportNull$$$0(7);
        }
        return (Jam)((JamElement)this.myCreator.apply(PsiElementRef.real(psi)));
    }

    @Nullable
    public Jam createJamElement(PsiElementRef<Psi> ref) {
        return (Jam)((JamElement)this.myCreator.apply(ref));
    }

    @Override
    public JamMemberMeta<Psi, Jam> addAnnotation(JamAnnotationMeta meta) {
        super.addAnnotation(meta);
        return this;
    }

    public JamMemberMeta<Psi, Jam> addRootAnnotation(JamAnnotationMeta meta) {
        super.addAnnotation(meta);
        this.myRootAnnos.add(meta);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jamClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jamFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/reflect/JamMemberMeta";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/reflect/JamMemberMeta";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addPomTargetProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPomTargetProducer";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJamElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createJamElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

