/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.proxy.handlers;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.kotlin.jupyter.debug.proxy.JdiDescriptorAwareProxy;
import com.intellij.kotlin.jupyter.debug.proxy.context.DebugValueContext;
import com.sun.jdi.ObjectReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/intellij/kotlin/jupyter/debug/proxy/handlers/JdiProxyDescriptorAwareBaseHandler;", "Lcom/intellij/kotlin/jupyter/debug/proxy/JdiDescriptorAwareProxy;", "valueContext", "Lcom/intellij/kotlin/jupyter/debug/proxy/context/DebugValueContext;", "<init>", "(Lcom/intellij/kotlin/jupyter/debug/proxy/context/DebugValueContext;)V", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "getEvaluationContext", "()Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "evaluationContext$delegate", "Lkotlin/Lazy;", "_javaValue", "Lcom/intellij/debugger/engine/JavaValue;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "objectReference", "Lcom/sun/jdi/ObjectReference;", "getObjectReference", "()Lcom/sun/jdi/ObjectReference;", "javaValue", "getJavaValue", "()Lcom/intellij/debugger/engine/JavaValue;", "bindDescriptor", "", "valueDescriptor", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "bindValueFromRuntime", "value", "computeJavaValue", "intellij.kotlin.jupyter.debug"})
public class JdiProxyDescriptorAwareBaseHandler
implements JdiDescriptorAwareProxy {
    @NotNull
    private final Lazy evaluationContext$delegate;
    @Nullable
    private volatile JavaValue _javaValue;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final ObjectReference objectReference;

    public JdiProxyDescriptorAwareBaseHandler(@NotNull DebugValueContext valueContext) {
        Intrinsics.checkNotNullParameter((Object)valueContext, (String)"valueContext");
        this.evaluationContext$delegate = LazyKt.lazy(() -> JdiProxyDescriptorAwareBaseHandler.evaluationContext_delegate$lambda$0(valueContext));
        this.debugProcess = valueContext.getDebugProcess();
        this.objectReference = valueContext.getObjectReference();
    }

    private final EvaluationContextImpl getEvaluationContext() {
        Lazy lazy = this.evaluationContext$delegate;
        return (EvaluationContextImpl)lazy.getValue();
    }

    @Override
    @NotNull
    public DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    @Override
    @NotNull
    public ObjectReference getObjectReference() {
        return this.objectReference;
    }

    @Override
    @Nullable
    public JavaValue getJavaValue() {
        return this._javaValue;
    }

    @Override
    public void bindDescriptor(@NotNull ValueDescriptorImpl valueDescriptor) {
        JavaValue currentValue;
        Intrinsics.checkNotNullParameter((Object)valueDescriptor, (String)"valueDescriptor");
        JavaValue javaValue = currentValue = this._javaValue;
        if (Intrinsics.areEqual((Object)(javaValue != null ? javaValue.getDescriptor() : null), (Object)valueDescriptor)) {
            return;
        }
        this._javaValue = this.computeJavaValue(valueDescriptor);
    }

    @Override
    public void bindValueFromRuntime(@Nullable JavaValue value) {
        this._javaValue = value;
    }

    private final JavaValue computeJavaValue(ValueDescriptorImpl valueDescriptor) {
        JavaDebugProcess javaDebugProcess = this.getDebugProcess().getXdebugProcess();
        if (javaDebugProcess == null || (javaDebugProcess = javaDebugProcess.getNodeManager()) == null) {
            return null;
        }
        JavaDebugProcess nodeManager = javaDebugProcess;
        EvaluationContextImpl evaluationContextImpl = this.getEvaluationContext();
        if (evaluationContextImpl == null) {
            return null;
        }
        EvaluationContextImpl context = evaluationContextImpl;
        JavaValue javaValue = JavaValue.create(null, (ValueDescriptorImpl)valueDescriptor, (EvaluationContextImpl)context, (NodeManagerImpl)nodeManager, (boolean)false);
        javaValue.getDescriptor().setContext(context);
        return javaValue;
    }

    private static final EvaluationContextImpl evaluationContext_delegate$lambda$0(DebugValueContext $valueContext) {
        return $valueContext.getEvaluationContext();
    }
}

