/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.proxy.handlers.delegates.notebook.state;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.kotlin.jupyter.debug.proxy.ProxyFactoryKt;
import com.intellij.kotlin.jupyter.debug.proxy.context.DebugValueContext;
import com.intellij.kotlin.jupyter.debug.proxy.handlers.JdiProxyDescriptorAwareBaseHandler;
import com.intellij.kotlin.jupyter.debug.proxy.notebook.state.JdiVariableStateExtension;
import com.intellij.kotlin.jupyter.debug.util.JdiUtilsKt;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J'\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\n\u0010\u001f\u001a\u0004\u0018\u00010\tH\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/kotlin/jupyter/debug/proxy/handlers/delegates/notebook/state/JdiVariableStateDelegateHandler;", "Lcom/intellij/kotlin/jupyter/debug/proxy/notebook/state/JdiVariableStateExtension;", "Lcom/intellij/kotlin/jupyter/debug/proxy/handlers/JdiProxyDescriptorAwareBaseHandler;", "valueContext", "Lcom/intellij/kotlin/jupyter/debug/proxy/context/DebugValueContext;", "<init>", "(Lcom/intellij/kotlin/jupyter/debug/proxy/context/DebugValueContext;)V", "cachedVariableRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/sun/jdi/Value;", "invalidateValueCache", "", "bindDescriptor", "valueDescriptor", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "bindValueFromRuntime", "value", "Lcom/intellij/debugger/engine/JavaValue;", "variableValue", "getVariableValue", "()Lcom/sun/jdi/Value;", "findVariableField", "Lcom/sun/jdi/Field;", "name", "", "createProxyForValue", "T", "", "proxyType", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "findVariableValue", "getScriptInstance", "Lcom/sun/jdi/ObjectReference;", "Lcom/intellij/debugger/ui/tree/ValueDescriptor;", "intellij.kotlin.jupyter.debug"})
public final class JdiVariableStateDelegateHandler
extends JdiProxyDescriptorAwareBaseHandler
implements JdiVariableStateExtension {
    @NotNull
    private final DebugValueContext valueContext;
    @NotNull
    private final AtomicReference<Value> cachedVariableRef;

    public JdiVariableStateDelegateHandler(@NotNull DebugValueContext valueContext) {
        Intrinsics.checkNotNullParameter((Object)valueContext, (String)"valueContext");
        super(valueContext);
        this.valueContext = valueContext;
        this.cachedVariableRef = new AtomicReference<Object>(null);
    }

    private final void invalidateValueCache() {
        this.cachedVariableRef.set(null);
    }

    @Override
    public void bindDescriptor(@NotNull ValueDescriptorImpl valueDescriptor) {
        Intrinsics.checkNotNullParameter((Object)valueDescriptor, (String)"valueDescriptor");
        super.bindDescriptor(valueDescriptor);
        this.invalidateValueCache();
    }

    @Override
    public void bindValueFromRuntime(@Nullable JavaValue value) {
        super.bindValueFromRuntime(value);
        this.invalidateValueCache();
    }

    @Override
    @Nullable
    public Value getVariableValue() {
        return this.findVariableValue();
    }

    @Override
    @Nullable
    public Field findVariableField(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ObjectReference objectReference = this.getScriptInstance();
        if (objectReference == null) {
            throw new IllegalStateException("Cannot retrieve 'scriptInstance' field from VariableState");
        }
        ObjectReference scriptInstance = objectReference;
        return JdiUtilsKt.findFieldByName(scriptInstance, name);
    }

    @Override
    @Nullable
    public <T> T createProxyForValue(@NotNull Class<T> proxyType) {
        Intrinsics.checkNotNullParameter(proxyType, (String)"proxyType");
        if (!proxyType.isInterface()) {
            boolean $i$a$-require-JdiVariableStateDelegateHandler$createProxyForValue$22 = false;
            String $i$a$-require-JdiVariableStateDelegateHandler$createProxyForValue$22 = "Type parameter T must be an interface, got " + proxyType;
            throw new IllegalArgumentException($i$a$-require-JdiVariableStateDelegateHandler$createProxyForValue$22.toString());
        }
        Value value = this.getVariableValue();
        ObjectReference objectReference = value instanceof ObjectReference ? (ObjectReference)value : null;
        if (objectReference == null) {
            return null;
        }
        ObjectReference underlyingValue = objectReference;
        DebugValueContext context = new DebugValueContext(this.getDebugProcess(), underlyingValue, this.valueContext.getEvaluationContext(), null, 8, null);
        return (T)ProxyFactoryKt.createJdiObjectProxy(context, proxyType);
    }

    private final Value findVariableValue() {
        ValueDescriptorImpl currentDescriptor;
        JavaValue javaValue = this.getJavaValue();
        Object object = currentDescriptor = javaValue != null ? javaValue.getDescriptor() : null;
        if (currentDescriptor == null) {
            this.invalidateValueCache();
            return null;
        }
        Value cachedVariable = this.cachedVariableRef.get();
        if (cachedVariable != null) {
            return cachedVariable;
        }
        Value computed = this.findVariableValue((ValueDescriptor)currentDescriptor);
        this.cachedVariableRef.set(computed);
        return computed;
    }

    private final ObjectReference getScriptInstance() {
        Value value = JdiUtilsKt.getFieldValueByName(this.getObjectReference(), "scriptInstance");
        return value instanceof ObjectReference ? (ObjectReference)value : null;
    }

    private final Value findVariableValue(ValueDescriptor valueDescriptor) {
        Value value;
        String variableName = valueDescriptor.getName();
        ObjectReference objectReference = this.getScriptInstance();
        if (objectReference != null) {
            Intrinsics.checkNotNull((Object)variableName);
            value = JdiUtilsKt.getFieldValueByName(objectReference, variableName);
        } else {
            value = null;
        }
        return value;
    }
}

