/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.llm.nes;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.detection.DocumentChangeKindDetector;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.code.provenance.core.llm.nes.RecentHistoryDocumentListenerKt;
import com.intellij.code.provenance.core.llm.nes.events.RecentHistoryDocumentChanges;
import com.intellij.code.provenance.core.llm.nes.events.RecentHistoryEventsImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001f B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/code/provenance/core/llm/nes/RecentHistoryDocumentListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "events", "Lcom/intellij/code/provenance/core/llm/nes/events/RecentHistoryEventsImpl;", "getEvents", "()Lcom/intellij/code/provenance/core/llm/nes/events/RecentHistoryEventsImpl;", "events$delegate", "Lkotlin/Lazy;", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "getContext", "Lcom/intellij/code/provenance/core/llm/nes/RecentHistoryDocumentListener$ContextInfo;", "contextLinesNumber", "", "BeforeDocumentChangeInfo", "ContextInfo", "intellij.code.provenance.core.llm"})
@SourceDebugExtension(value={"SMAP\nRecentHistoryDocumentListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentHistoryDocumentListener.kt\ncom/intellij/code/provenance/core/llm/nes/RecentHistoryDocumentListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class RecentHistoryDocumentListener
implements BulkAwareDocumentListener {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile virtualFile;
    @NotNull
    private final Lazy events$delegate;

    public RecentHistoryDocumentListener(@NotNull EditorImpl editor, @NotNull Project project, @Nullable VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.editor = editor;
        this.project = project;
        this.virtualFile = virtualFile;
        this.events$delegate = LazyKt.lazy(() -> RecentHistoryDocumentListener.events_delegate$lambda$0(this));
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    private final RecentHistoryEventsImpl getEvents() {
        Lazy lazy = this.events$delegate;
        return (RecentHistoryEventsImpl)lazy.getValue();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getDocument().isInBulkUpdate()) {
            return;
        }
        CharSequence charSequence = this.editor.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        long beforeHash = UtilsKt.contentHash((CharSequence)charSequence);
        BeforeDocumentChangeInfo eventInfo = new BeforeDocumentChangeInfo(beforeHash, event);
        this.editor.putUserData(RecentHistoryDocumentListenerKt.access$getEDITOR_BEFORE_CHANGE_INFO_KEY$p(), (Object)eventInfo);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        block8: {
            RecentHistoryDocumentChanges newEvent;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getDocument().isInBulkUpdate()) {
                return;
            }
            BeforeDocumentChangeInfo beforeDocumentChangeInfo = (BeforeDocumentChangeInfo)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)this.editor), (Key)RecentHistoryDocumentListenerKt.access$getEDITOR_BEFORE_CHANGE_INFO_KEY$p());
            if (beforeDocumentChangeInfo == null) {
                return;
            }
            BeforeDocumentChangeInfo beforeDocumentChangeInfo2 = beforeDocumentChangeInfo;
            long beforeHash = beforeDocumentChangeInfo2.component1();
            DocumentEvent beforeEvent = beforeDocumentChangeInfo2.component2();
            if (!Intrinsics.areEqual((Object)beforeEvent, (Object)event)) {
                return;
            }
            DocumentChangesKind kind = DocumentChangeKindDetector.INSTANCE.detect(this.project, (Editor)this.editor, this.virtualFile, event);
            int n = event.getOffset();
            int n2 = event.getOldLength();
            CharSequence charSequence = event.getNewFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
            ProvenanceEntry.SingleDocumentChange change = new ProvenanceEntry.SingleDocumentChange(n, n2, charSequence);
            CharSequence charSequence2 = this.editor.getDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getImmutableCharSequence(...)");
            long afterHash = UtilsKt.contentHash((CharSequence)charSequence2);
            if (beforeHash == afterHash) {
                return;
            }
            Object object = this.virtualFile;
            if (object == null || (object = object.getPath()) == null) {
                object = "Unknown";
            }
            Object filePath = object;
            RecentHistoryDocumentChanges recentHistoryDocumentChanges = newEvent = (switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1, 2, 3, 4 -> {
                    CharSequence v6 = event.getOldFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getOldFragment(...)");
                    CharSequence var13_9 = v6;
                    ContextInfo var14_11 = this.getContext(event, 2);
                    long var15_12 = Clock.getTime();
                    yield new RecentHistoryDocumentChanges(change, beforeHash, afterHash, var13_9, (String)filePath, var15_12, var14_11, kind);
                }
                default -> null;
            });
            if (recentHistoryDocumentChanges == null) break block8;
            RecentHistoryDocumentChanges it = recentHistoryDocumentChanges;
            boolean bl = false;
            this.getEvents().add$intellij_code_provenance_core_llm(it);
        }
    }

    private final ContextInfo getContext(DocumentEvent event, int contextLinesNumber) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int startOffset = event.getOffset();
        int changedFragmentLength = event.getNewFragment().length();
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(startOffset + changedFragmentLength);
        int contextStartLine = RangesKt.coerceAtLeast((int)(startLine - contextLinesNumber), (int)0);
        int contextEndLine = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(endLine + contextLinesNumber), (int)(document.getLineCount() - 1)), (int)0);
        int contextStartOffset = document.getLineStartOffset(contextStartLine);
        int contextEndOffset = document.getLineEndOffset(contextEndLine);
        CharSequence content = document.getImmutableCharSequence().subSequence(contextStartOffset, contextEndOffset);
        CharSequence contextBefore = StringsKt.take((CharSequence)content, (int)(startOffset - contextStartOffset));
        int actualEndOffset = startOffset + changedFragmentLength;
        CharSequence contextAfter = StringsKt.takeLast((CharSequence)content, (int)(contextEndOffset - actualEndOffset));
        return new ContextInfo(contextStartLine, contextStartOffset, contextEndOffset, contextBefore, contextAfter);
    }

    private static final RecentHistoryEventsImpl events_delegate$lambda$0(RecentHistoryDocumentListener this$0) {
        return RecentHistoryEventsImpl.Companion.getInstance(this$0.project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/code/provenance/core/llm/nes/RecentHistoryDocumentListener$BeforeDocumentChangeInfo;", "", "beforeHash", "", "documentEvent", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "<init>", "(JLcom/intellij/openapi/editor/event/DocumentEvent;)V", "getBeforeHash", "()J", "getDocumentEvent", "()Lcom/intellij/openapi/editor/event/DocumentEvent;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.code.provenance.core.llm"})
    public static final class BeforeDocumentChangeInfo {
        private final long beforeHash;
        @NotNull
        private final DocumentEvent documentEvent;

        public BeforeDocumentChangeInfo(long beforeHash, @NotNull DocumentEvent documentEvent) {
            Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"documentEvent");
            this.beforeHash = beforeHash;
            this.documentEvent = documentEvent;
        }

        public final long getBeforeHash() {
            return this.beforeHash;
        }

        @NotNull
        public final DocumentEvent getDocumentEvent() {
            return this.documentEvent;
        }

        public final long component1() {
            return this.beforeHash;
        }

        @NotNull
        public final DocumentEvent component2() {
            return this.documentEvent;
        }

        @NotNull
        public final BeforeDocumentChangeInfo copy(long beforeHash, @NotNull DocumentEvent documentEvent) {
            Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"documentEvent");
            return new BeforeDocumentChangeInfo(beforeHash, documentEvent);
        }

        public static /* synthetic */ BeforeDocumentChangeInfo copy$default(BeforeDocumentChangeInfo beforeDocumentChangeInfo, long l, DocumentEvent documentEvent, int n, Object object) {
            if ((n & 1) != 0) {
                l = beforeDocumentChangeInfo.beforeHash;
            }
            if ((n & 2) != 0) {
                documentEvent = beforeDocumentChangeInfo.documentEvent;
            }
            return beforeDocumentChangeInfo.copy(l, documentEvent);
        }

        @NotNull
        public String toString() {
            return "BeforeDocumentChangeInfo(beforeHash=" + this.beforeHash + ", documentEvent=" + this.documentEvent + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.beforeHash);
            result = result * 31 + this.documentEvent.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BeforeDocumentChangeInfo)) {
                return false;
            }
            BeforeDocumentChangeInfo beforeDocumentChangeInfo = (BeforeDocumentChangeInfo)other;
            if (this.beforeHash != beforeDocumentChangeInfo.beforeHash) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.documentEvent, (Object)beforeDocumentChangeInfo.documentEvent);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/code/provenance/core/llm/nes/RecentHistoryDocumentListener$ContextInfo;", "", "contextStartLine", "", "contextStartOffset", "contextEndOffset", "contextBefore", "", "contextAfter", "<init>", "(IIILjava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getContextStartLine", "()I", "getContextStartOffset", "getContextEndOffset", "getContextBefore", "()Ljava/lang/CharSequence;", "getContextAfter", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.code.provenance.core.llm"})
    public static final class ContextInfo {
        private final int contextStartLine;
        private final int contextStartOffset;
        private final int contextEndOffset;
        @NotNull
        private final CharSequence contextBefore;
        @NotNull
        private final CharSequence contextAfter;

        public ContextInfo(int contextStartLine, int contextStartOffset, int contextEndOffset, @NotNull CharSequence contextBefore, @NotNull CharSequence contextAfter) {
            Intrinsics.checkNotNullParameter((Object)contextBefore, (String)"contextBefore");
            Intrinsics.checkNotNullParameter((Object)contextAfter, (String)"contextAfter");
            this.contextStartLine = contextStartLine;
            this.contextStartOffset = contextStartOffset;
            this.contextEndOffset = contextEndOffset;
            this.contextBefore = contextBefore;
            this.contextAfter = contextAfter;
        }

        public final int getContextStartLine() {
            return this.contextStartLine;
        }

        public final int getContextStartOffset() {
            return this.contextStartOffset;
        }

        public final int getContextEndOffset() {
            return this.contextEndOffset;
        }

        @NotNull
        public final CharSequence getContextBefore() {
            return this.contextBefore;
        }

        @NotNull
        public final CharSequence getContextAfter() {
            return this.contextAfter;
        }

        public final int component1() {
            return this.contextStartLine;
        }

        public final int component2() {
            return this.contextStartOffset;
        }

        public final int component3() {
            return this.contextEndOffset;
        }

        @NotNull
        public final CharSequence component4() {
            return this.contextBefore;
        }

        @NotNull
        public final CharSequence component5() {
            return this.contextAfter;
        }

        @NotNull
        public final ContextInfo copy(int contextStartLine, int contextStartOffset, int contextEndOffset, @NotNull CharSequence contextBefore, @NotNull CharSequence contextAfter) {
            Intrinsics.checkNotNullParameter((Object)contextBefore, (String)"contextBefore");
            Intrinsics.checkNotNullParameter((Object)contextAfter, (String)"contextAfter");
            return new ContextInfo(contextStartLine, contextStartOffset, contextEndOffset, contextBefore, contextAfter);
        }

        public static /* synthetic */ ContextInfo copy$default(ContextInfo contextInfo, int n, int n2, int n3, CharSequence charSequence, CharSequence charSequence2, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = contextInfo.contextStartLine;
            }
            if ((n4 & 2) != 0) {
                n2 = contextInfo.contextStartOffset;
            }
            if ((n4 & 4) != 0) {
                n3 = contextInfo.contextEndOffset;
            }
            if ((n4 & 8) != 0) {
                charSequence = contextInfo.contextBefore;
            }
            if ((n4 & 0x10) != 0) {
                charSequence2 = contextInfo.contextAfter;
            }
            return contextInfo.copy(n, n2, n3, charSequence, charSequence2);
        }

        @NotNull
        public String toString() {
            return "ContextInfo(contextStartLine=" + this.contextStartLine + ", contextStartOffset=" + this.contextStartOffset + ", contextEndOffset=" + this.contextEndOffset + ", contextBefore=" + this.contextBefore + ", contextAfter=" + this.contextAfter + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.contextStartLine);
            result = result * 31 + Integer.hashCode(this.contextStartOffset);
            result = result * 31 + Integer.hashCode(this.contextEndOffset);
            result = result * 31 + this.contextBefore.hashCode();
            result = result * 31 + this.contextAfter.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextInfo)) {
                return false;
            }
            ContextInfo contextInfo = (ContextInfo)other;
            if (this.contextStartLine != contextInfo.contextStartLine) {
                return false;
            }
            if (this.contextStartOffset != contextInfo.contextStartOffset) {
                return false;
            }
            if (this.contextEndOffset != contextInfo.contextEndOffset) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contextBefore, (Object)contextInfo.contextBefore)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.contextAfter, (Object)contextInfo.contextAfter);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocumentChangesKind.values().length];
            try {
                nArray[DocumentChangesKind.TYPING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentChangesKind.PASTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentChangesKind.AI_APPLY_SNIPPET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocumentChangesKind.AI_CODE_GENERATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

