/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.dnd;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.jupyter.core.editor.handlers.CsvDropUtilKt;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.jupyter.py.editor.dnd.CustomCellDataFileDropHandler;
import com.intellij.jupyter.py.editor.dnd.PythonXlsDropHandlerKt;
import com.intellij.jupyter.py.utils.JupyterPyBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/py/editor/dnd/PythonCsvDropHandler;", "Lcom/intellij/jupyter/py/editor/dnd/CustomCellDataFileDropHandler;", "<init>", "()V", "generateCellCode", "", "context", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "intellij.jupyter.py"})
public final class PythonCsvDropHandler
extends CustomCellDataFileDropHandler {
    public PythonCsvDropHandler() {
        Object[] objectArray = new String[]{"csv", "tsv"};
        super(JupyterPyBundle.message("jupyter.drop.csv.command", new Object[0]), SetsKt.setOf((Object[])objectArray));
    }

    @NotNull
    public String generateCellCode(@NotNull TableDataFileDropHandlerContext context) {
        CsvFormat csvFormat;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(context.absoluteFilePath());
        CsvFormat csvFormat2 = csvFormat = file != null ? CsvFormatResolver.getFormat((Project)context.getProjectOrNull(), (VirtualFile)file, (boolean)true, null) : null;
        if (csvFormat == null) {
            CsvFormat csvFormat3;
            Path path = Path.of(context.absoluteFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            Character c = CsvDropUtilKt.guessCsvSeparator((Path)path);
            if (c != null) {
                char csvSeparator = c.charValue();
                boolean bl = false;
                CsvRecordFormat recordFormat = new CsvRecordFormat("", "", null, CollectionsKt.emptyList(), CsvRecordFormat.QuotationPolicy.AS_NEEDED, String.valueOf(csvSeparator), "\n", false);
                csvFormat3 = new CsvFormat(recordFormat, recordFormat, false);
            } else {
                csvFormat3 = null;
            }
            csvFormat = csvFormat3;
        }
        List args = new ArrayList();
        if (csvFormat != null) {
            Charset charset;
            Collection collection = args;
            String string = csvFormat.dataRecord.valueSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueSeparator");
            collection.add("sep=" + PythonXlsDropHandlerKt.pyStr(string));
            if (!Intrinsics.areEqual((Object)csvFormat.dataRecord.recordSeparator, (Object)"\n")) {
                collection = args;
                String string2 = csvFormat.dataRecord.recordSeparator;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"recordSeparator");
                collection.add("lineterminator=" + PythonXlsDropHandlerKt.pyStr(string2));
            }
            if (csvFormat.headerRecord == null) {
                ((Collection)args).add("header=None");
            }
            if (csvFormat.dataRecord.nullText != null) {
                collection = args;
                String string3 = csvFormat.dataRecord.nullText;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nullText");
                collection.add("na_values=[" + PythonXlsDropHandlerKt.pyStr(string3) + "]");
            }
            List list = csvFormat.dataRecord.quotes;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"quotes");
            if (!((Collection)list).isEmpty()) {
                collection = args;
                String string4 = ((CsvRecordFormat.Quotes)csvFormat.dataRecord.quotes.get((int)0)).leftQuote;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"leftQuote");
                collection.add("quotechar=" + PythonXlsDropHandlerKt.pyStr(string4));
            }
            VirtualFile virtualFile = file;
            Charset charset2 = charset = virtualFile != null ? virtualFile.getCharset() : null;
            if (charset != null && !Intrinsics.areEqual((Object)charset, (Object)StandardCharsets.UTF_8)) {
                Collection csvSeparator = args;
                String string5 = charset.name();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name(...)");
                csvSeparator.add("encoding=" + PythonXlsDropHandlerKt.pyStr(string5));
            }
        }
        String csvPath = context.resolveFilePath();
        String string = context.getDataframeName();
        if (string == null) {
            string = this.getNameSuggester().createDataframeName(context.getProjectOrNull(), context.getDataFileNameWithoutExtension(), context.getNotebookOrNull());
        }
        String dfName = string;
        return StringsKt.trimIndent((String)("\n      import pandas as pd\n      " + dfName + " = pd.read_csv(" + PythonXlsDropHandlerKt.pyStr(csvPath) + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)"", null, null, (int)0, null, PythonCsvDropHandler::generateCellCode$lambda$1, (int)30, null) + ")\n      " + dfName + "\n    "));
    }

    private static final CharSequence generateCellCode$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ", " + it;
    }
}

