/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.dnd;

import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.jupyter.py.editor.dnd.CustomCellDataFileDropHandler;
import com.intellij.jupyter.py.editor.dnd.PythonXlsDropHandlerKt;
import com.intellij.jupyter.py.utils.JupyterPyBundle;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/py/editor/dnd/PythonXlsDropHandler;", "Lcom/intellij/jupyter/py/editor/dnd/CustomCellDataFileDropHandler;", "<init>", "()V", "generateCellCode", "", "context", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "intellij.jupyter.py"})
public final class PythonXlsDropHandler
extends CustomCellDataFileDropHandler {
    public PythonXlsDropHandler() {
        Object[] objectArray = new String[]{"xls", "xlsx", "xlsm", "xlsb", "odf", "ods", "odt"};
        super(JupyterPyBundle.message("jupyter.drop.xls.command", new Object[0]), SetsKt.setOf((Object[])objectArray));
    }

    @NotNull
    public String generateCellCode(@NotNull TableDataFileDropHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String xlsPath = context.resolveFilePath();
        String string = context.getDataframeName();
        if (string == null) {
            string = this.getNameSuggester().createDataframeName(context.getProjectOrNull(), context.getDataFileNameWithoutExtension(), context.getNotebookOrNull());
        }
        String dfName = string;
        return StringsKt.trimIndent((String)("\n      import pandas as pd\n      " + dfName + " = pd.read_excel(" + PythonXlsDropHandlerKt.pyStr(xlsPath) + ", index_col=0, header=0)\n      " + dfName + "\n    "));
    }
}

